/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.ui.palette.plugin;

import java.util.HashMap;
import java.util.Map;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.framework.palette.AbstractPalettePlugin;
import oracle.diagram.framework.palette.PaletteItemHandler;
import oracle.ide.palette2.PaletteItem;
import org.jetbrains.annotations.NotNull;

public class ModularPalettePlugin
extends AbstractPalettePlugin {
    private final Map<Class<? extends PaletteItem>, PaletteItemHandler> handlerByItemClass = new HashMap<Class<? extends PaletteItem>, PaletteItemHandler>();
    @NotNull
    private final LastEntry last = new LastEntry();

    public ModularPalettePlugin(DiagramContext context) {
        super(context);
    }

    public void registerPaletteItemTypeHandler(Class<? extends PaletteItem> itemClass, PaletteItemHandler handler) {
        this.handlerByItemClass.put(itemClass, handler);
    }

    public PaletteItemHandler getPaletteItemTypeHandler(Class<? extends PaletteItem> itemClass) {
        PaletteItemHandler result = this.last.is(itemClass) ? this.last.getValue() : this.last.update(itemClass, this.handlerByItemClass.get(itemClass));
        return result;
    }

    protected PaletteItemHandler getHandler(PaletteItem paletteItem) {
        PaletteItemHandler result = null;
        if (paletteItem != null) {
            result = this.getPaletteItemTypeHandler(paletteItem.getClass());
        }
        return result;
    }

    private final class LastEntry
    implements Map.Entry<Class<? extends PaletteItem>, PaletteItemHandler> {
        private PaletteItemHandler handler;
        private Class<? extends PaletteItem> itemClass;

        private LastEntry() {
        }

        @Override
        public Class<? extends PaletteItem> getKey() {
            return this.itemClass;
        }

        @Override
        public PaletteItemHandler getValue() {
            return this.handler;
        }

        @Override
        public PaletteItemHandler setValue(PaletteItemHandler value) {
            throw new UnsupportedOperationException();
        }

        private boolean is(Class<? extends PaletteItem> itemClass) {
            return this.itemClass == itemClass;
        }

        private PaletteItemHandler update(Class<? extends PaletteItem> itemClass, PaletteItemHandler handler) {
            this.itemClass = itemClass;
            this.handler = handler;
            return this.handler;
        }
    }
}

