/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.ui.palette.handler;

import oracle.bpm.designer.Domain;
import oracle.bpm.designer.DomainStateManager;
import oracle.bpm.fusion.ui.palette.handler.AbstractStudioPaletteItemHandler;
import oracle.bpm.geom.Point;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.event.MouseEvent;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.framework.palette.PaletteTask;
import oracle.diagram.framework.palette.event.PaletteItemDropTargetDragEvent;
import oracle.diagram.framework.palette.event.PaletteItemDropTargetDropEvent;
import oracle.diagram.framework.palette.event.PaletteItemDropTargetEvent;
import org.jetbrains.annotations.NotNull;

public final class StudioDragEventDispatch {
    private StudioDragEventDispatch() {
    }

    public static void dragEnter(AbstractStudioPaletteItemHandler handler, PaletteItemDropTargetDragEvent target) {
        PaletteTask task = handler.createPaletteTask(target.getDiagramContext(), target.getPaletteItem());
        if (task != null) {
            task.invoke(false);
        }
        Domain domain = StudioDragEventDispatch.retrieveDomain(target.getDiagramContext());
        Point location = new Point(target.getAWTDragEvent().getLocation());
        MouseEvent event = MouseEvent.createMove(null, (Point)location);
        domain.getStateManager().getCurrentState().mouseDragged(event, location);
    }

    public static void dragExit(AbstractStudioPaletteItemHandler handler, PaletteItemDropTargetEvent target) {
        Domain domain = StudioDragEventDispatch.retrieveDomain(target.getDiagramContext());
        domain.getStateManager().getCurrentState().cancel();
    }

    public static void dragOver(AbstractStudioPaletteItemHandler handler, PaletteItemDropTargetDragEvent target) {
        Domain domain = StudioDragEventDispatch.retrieveDomain(target.getDiagramContext());
        Point location = new Point(target.getAWTDragEvent().getLocation());
        MouseEvent event = MouseEvent.createMove(null, (Point)location);
        domain.getStateManager().getCurrentState().mouseDragged(event, location);
    }

    public static void dropActionChanged(AbstractStudioPaletteItemHandler handler, PaletteItemDropTargetDragEvent target) {
    }

    public static PaletteTask drop(AbstractStudioPaletteItemHandler handler, PaletteItemDropTargetDropEvent target) {
        final Domain domain = StudioDragEventDispatch.retrieveDomain(target.getDiagramContext());
        final Point location = new Point(target.getAWTDropEvent().getLocation());
        final MouseEvent event = MouseEvent.createReleased(null, (Point)location);
        UiUtilities.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                domain.getStateManager().getCurrentState().mouseRealeased(event, location);
            }
        }, (boolean)true);
        return null;
    }

    private static Domain retrieveDomain(@NotNull DiagramContext context) {
        DomainStateManager manager = (DomainStateManager)context.getHost();
        return manager.getDomain();
    }
}

