/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.ui.editor;

import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.StudioEditor;
import oracle.bpm.designer.StudioWorkbench;
import oracle.bpm.extension.Extension;
import oracle.bpm.extensionpoint.metadata.EditorSupportMetadata;
import oracle.bpm.fusion.core.ProjectObjectNode;
import oracle.bpm.fusion.ui.editor.FusionEditorSupport;
import oracle.bpm.fusion.ui.editor.FusionEditorVisibilityListener;
import oracle.bpm.lang.Platform;
import oracle.bpm.project.model.ErrorSource;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.project.model.events.BatchProjectListenerAdapter;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.events.ProjectEventSet;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.ide.Context;
import oracle.ide.controller.IdeActions;
import oracle.ide.editor.Editor;
import oracle.ide.editor.OpenAbortedException;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.UpdateMessage;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;

public class FusionEditor
extends Editor {
    private Component gui;
    private ProjectListener<ProjectObject> projectListener;
    private StudioEditor studioEditor;
    private FusionEditorSupport support;

    public FusionEditor() {
        this.addViewListener(new ViewListener(){

            public void viewActivated(ViewEvent viewEvent) {
                if (FusionEditor.this.studioEditor != null) {
                    FusionEditor.this.studioEditor.onActivation();
                }
            }

            public void viewDeactivated(ViewEvent viewEvent) {
            }

            public void viewClosed(ViewEvent viewEvent) {
            }
        });
    }

    public void open() {
        if (this.getStudioEditor() == null) {
            throw new OpenAbortedException();
        }
        this.getNode().getObject().getProject().addListener(this.getProjectListener());
        this.support.onOpen();
    }

    public synchronized void setContext(Context context) {
        super.setContext(context);
        this.ensureSupport();
        this.support.onSetContext();
    }

    public void close() {
        super.close();
        this.disposeStudioEditor();
        ((ProjectObjectNode)this.getContext().getNode()).getObject().getProject().removeListener(this.getProjectListener());
        this.support.onClose();
    }

    public ProjectListener getProjectListener() {
        if (this.projectListener == null) {
            this.projectListener = new BatchProjectListenerAdapter<ProjectObject>(ProjectObject.class){

                public void processPostEvents(ProjectEventSet events) {
                    for (ProjectEvent projectEvent : events) {
                        ProjectObject projectObject;
                        if (projectEvent.getProjectObject() != ((ProjectObjectNode)FusionEditor.this.getContext().getNode()).getObject()) continue;
                        ProjectEvent.Type eventType = projectEvent.getType();
                        if (eventType == ProjectEvent.Type.REPLACE) {
                            FusionEditor.this.getNode().replaceObject(projectEvent.getReplacement());
                            continue;
                        }
                        if (eventType != ProjectEvent.Type.CHANGE || !((projectObject = projectEvent.getProjectObject()) instanceof ResourceObject)) continue;
                        FusionEditor.this.getNode().markDirty(((ResourceObject)projectObject).isDirty());
                    }
                }
            };
        }
        return this.projectListener;
    }

    public Component getGUI() {
        if (this.gui == null) {
            Component result;
            try {
                ErrorSource source;
                ProjectObject object = this.getNode().getObject();
                if (object instanceof ErrorSource && (source = (ErrorSource)object).isBroken() && source.hasErrors()) {
                    throw (ProjectException)source.getErrors().get(0);
                }
                StudioEditor editor = this.getStudioEditor();
                if (editor instanceof UiComponent) {
                    UiComponent uiComponent = (UiComponent)editor;
                    result = (Component)uiComponent.getNative();
                } else {
                    result = this.getErrorEditor();
                }
            }
            catch (Throwable unexpected) {
                result = new JLabel(unexpected.toString());
            }
            this.gui = result;
        }
        return this.gui;
    }

    public synchronized Icon getTabIcon() {
        return this.getStudioEditor().getIcon().asSwingIcon();
    }

    public HelpInfo getHelpInfo() {
        String id = this.getStudioEditor().getHelpId();
        String realHelpId = Ui.getHelpService().getRealHelpId(id);
        return new HelpInfo(realHelpId);
    }

    public StudioEditor getStudioEditor() {
        if (this.studioEditor == null) {
            this.studioEditor = this.instantiate(this.getNode());
            this.setEditorAttribute("scrollable", Boolean.FALSE);
            if (this.studioEditor != null) {
                this.studioEditor.addChangeListener(this.getChangeListener());
            }
        }
        return this.studioEditor;
    }

    public void update(Object object, UpdateMessage updateMessage) {
    }

    public void editorHidden() {
        if (this.getStudioEditor() instanceof FusionEditorVisibilityListener) {
            ((FusionEditorVisibilityListener)this.getStudioEditor()).editorHidden();
        }
        super.editorHidden();
    }

    public void editorShown() {
        if (this.getStudioEditor() instanceof FusionEditorVisibilityListener) {
            ((FusionEditorVisibilityListener)this.getStudioEditor()).editorShown();
        }
        super.editorShown();
    }

    protected ProjectObjectNode getNode() {
        ProjectObjectNode projectObjectNode = (ProjectObjectNode)this.getContext().getNode();
        projectObjectNode.ensureOpen();
        return projectObjectNode;
    }

    private ChangeListener getChangeListener() {
        return new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                FusionEditor.this.getNode().ensureOpen();
                FusionEditor.this.getNode().markDirty(true);
                IdeActions.getFileSaveAction().updateAction();
            }
        };
    }

    private void ensureSupport() {
        if (this.support == null) {
            FusionEditorSupport result = null;
            try {
                ProjectObject object = this.getNode().getObject();
                result = this.findEditorSupport(object);
            }
            catch (InstantiationException e) {
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (result == null) {
                result = new FusionEditorSupport.Default();
            }
            result.setEditor(this);
            this.support = result;
        }
    }

    private void disposeStudioEditor() {
        StudioEditor editor = this.getStudioEditor();
        if (editor != null) {
            editor.disposeEditor();
        }
    }

    private FusionEditorSupport findEditorSupport(ProjectObject object) throws InstantiationException {
        FusionEditorSupport result = null;
        List<Extension<EditorSupportMetadata>> extensions = Platform.getExtensionService().getExtensionsByPoint(EditorSupportMetadata.class);
        for (Extension<EditorSupportMetadata> extension : extensions) {
            Class objectType = extension.getMetadata().objectType();
            if (!objectType.isAssignableFrom(object.getClass())) continue;
            result = extension.instantiateAs(FusionEditorSupport.class);
        }
        return result;
    }

    private StudioEditor instantiate(ProjectObjectNode node) {
        StudioWorkbench workbench = AbstractStudioWorkbench.getInstance();
        return workbench.createEditor((Object)node.getObject());
    }

    private Component getErrorEditor() {
        return new JLabel("No editor for " + this.getNode().getObject().getId(), 0);
    }
}

