/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.processbuilder.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.xml.namespace.QName;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.datasources.CompoundDataSource;
import oracle.tip.tools.ide.common.datasources.schema.ProjectSchemaDataSource;
import oracle.tip.tools.ide.common.datasources.schema.SchemaDataSource;
import oracle.tip.tools.ide.common.datasources.wsdl.ProjectWSDLDataSource;
import oracle.tip.tools.ide.common.datasources.wsdl.WSDLDataSource;
import oracle.tip.tools.ide.common.datasources.wsdl.WSDLDataSourceObject;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.jdev.JDevHelper;
import oracle.tip.tools.ide.common.typeexplorer.DefaultSchemaImportHandler;
import oracle.tip.tools.ide.common.typeexplorer.DefaultWSDLImportHandler;
import oracle.tip.tools.ide.common.typeexplorer.SchemaImportHandler;
import oracle.tip.tools.ide.common.typeexplorer.TypeChooser;
import oracle.tip.tools.ide.common.typeexplorer.TypeExplorer;
import oracle.tip.tools.ide.common.typeexplorer.TypeExplorerTreeNode;
import oracle.tip.tools.ide.common.typeexplorer.TypeObject;
import oracle.tip.tools.ide.common.typeexplorer.WSDLImportHandler;
import oracle.tip.tools.ide.common.ui.GlobalImageCache;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.treeexplorer.NodeText;
import oracle.tip.tools.ide.common.ui.treeexplorer.TextInfo;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorerCellRenderer;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorerDataSource;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorerTreeNode;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.processbuilder.model.ProcessData;
import oracle.tip.tools.ide.pm.processbuilder.model.ProjectImportedURLInfo;
import oracle.tip.tools.ide.pm.processbuilder.ui.GeneralPanel2;

public class InputOutputPanel
extends JPanel
implements ActionListener {
    protected JComponent m_descLabel;
    protected JTextField m_inputPartField;
    protected JTextField m_outputPartField;
    protected JButton m_inputBrowseBtn;
    protected JButton m_outputBrowseBtn;
    protected JLabel m_outputLbl;
    protected TypeObject m_inputTypeObj;
    protected TypeObject m_outputTypeObj;
    protected boolean m_bLoadSchema;
    protected URL m_initImportURL;
    protected GeneralPanel2 m_generalPnl;

    public InputOutputPanel(GeneralPanel2 genPnl) {
        this.m_generalPnl = genPnl;
        this.createControls();
        this.layoutControls();
        this.installListeners();
    }

    public void setOnewayMode() {
        this.m_outputPartField.setVisible(false);
        this.m_outputBrowseBtn.setVisible(false);
        this.m_outputLbl.setVisible(false);
    }

    protected void installListeners() {
        this.m_generalPnl.m_namespaceField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                InputOutputPanel.this.syncWithGeneralPanel();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                InputOutputPanel.this.syncWithGeneralPanel();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                InputOutputPanel.this.syncWithGeneralPanel();
            }
        });
        this.m_generalPnl.m_typeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InputOutputPanel.this.syncWithGeneralPanel();
            }
        });
    }

    protected void syncWithGeneralPanel() {
        this.setControlValues(this.m_generalPnl.m_nameField.getText(), this.m_generalPnl.m_namespaceField.getText());
    }

    protected void setControlValues(String processName, String namespace) {
        QName qname;
        if (this.m_inputTypeObj == null) {
            this.m_inputPartField.setText("{" + namespace + "}" + "process");
        } else {
            qname = this.m_inputTypeObj.getQName();
            this.m_inputPartField.setText("{" + qname.getNamespaceURI() + "}" + qname.getLocalPart());
        }
        if (this.m_outputTypeObj == null) {
            this.m_outputPartField.setText("{" + namespace + "}" + "processResponse");
        } else {
            qname = this.m_outputTypeObj.getQName();
            this.m_outputPartField.setText("{" + qname.getNamespaceURI() + "}" + qname.getLocalPart());
        }
    }

    public boolean save(ProcessData data) {
        if (this.m_inputTypeObj != null) {
            data.m_inputqname = this.m_inputTypeObj.getQName();
            data.m_inputInfo = new ProjectImportedURLInfo();
            data.m_inputInfo.setImportedURL((URL)this.m_inputTypeObj.getData("RESOURCE_URL_KEY"));
            data.m_inputInfo.setNamespaceURI(this.m_inputTypeObj.getQName().getNamespaceURI());
            data.m_inputInfo.setXSDImport(this.m_inputTypeObj.getFileType() == 6 || this.m_inputTypeObj.getFileType() == 1);
        }
        if (this.m_outputTypeObj != null) {
            data.m_outputqname = this.m_outputTypeObj.getQName();
            data.m_outputInfo = new ProjectImportedURLInfo();
            data.m_outputInfo.setImportedURL((URL)this.m_outputTypeObj.getData("RESOURCE_URL_KEY"));
            data.m_outputInfo.setNamespaceURI(this.m_outputTypeObj.getQName().getNamespaceURI());
            data.m_outputInfo.setXSDImport(this.m_outputTypeObj.getFileType() == 6 || this.m_outputTypeObj.getFileType() == 1);
        }
        return true;
    }

    protected String getPageDesc() {
        return BPELStringTranslator.getString("INPUT_OUTPUT_DEFAULTS");
    }

    protected void createControls() {
        this.m_descLabel = UIHelper.getMultiLineLabel((String)this.getPageDesc());
        this.m_inputPartField = new JTextField();
        this.m_inputPartField.setEditable(false);
        this.m_outputPartField = new JTextField();
        this.m_outputPartField.setEditable(false);
        this.m_inputBrowseBtn = new JButton(GlobalImageCache.getIcon((String)"browse16"));
        this.m_inputBrowseBtn.setToolTipText(BPELStringTranslator.getString("PROJECTWIZARD_BROWSE_INPUT_ELEMENTS"));
        this.m_inputBrowseBtn.addActionListener(this);
        this.m_outputBrowseBtn = new JButton(GlobalImageCache.getIcon((String)"browse16"));
        this.m_outputBrowseBtn.setToolTipText(BPELStringTranslator.getString("PROJECTWIZARD_BROWSE_OUTPUT_ELEMENTS"));
        this.m_outputBrowseBtn.addActionListener(this);
    }

    protected void layoutControls() {
        InputOutputPanel p = this;
        this.setLayout(new GridBagLayout());
        JToolBar inputBrowseTB = new JToolBar();
        inputBrowseTB.setBorderPainted(false);
        inputBrowseTB.add(this.m_inputBrowseBtn);
        JToolBar outputBrowseTB = new JToolBar();
        outputBrowseTB.setBorderPainted(false);
        outputBrowseTB.add(this.m_outputBrowseBtn);
        JLabel inlbl = new JLabel();
        BPELStringTranslator.setLabel(inlbl, this.m_inputPartField, BPELStringTranslator.getString("PROJECTWIZARD_INPUT_ELEMENT"));
        this.m_outputLbl = new JLabel();
        BPELStringTranslator.setLabel(this.m_outputLbl, this.m_outputPartField, BPELStringTranslator.getString("PROJECTWIZARD_OUTPUT_ELEMENT"));
        int row = 0;
        GraphUtils.addComponent((Container)p, (Component)inlbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)this.m_inputPartField, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)inputBrowseTB, (int)2, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)this.m_outputLbl, (int)0, (int)row, (int)1, (int)1, (int)18, (int)0, (Insets)new Insets(5, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)1.0);
        GraphUtils.addComponent((Container)p, (Component)this.m_outputPartField, (int)1, (int)row, (int)1, (int)1, (int)18, (int)2, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)p, (Component)outputBrowseTB, (int)2, (int)row++, (int)1, (int)1, (int)18, (int)0, (Insets)new Insets(5, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)1.0);
    }

    protected void handleBrowseElement(Object src) {
        TypeChooser chooser = new TypeChooser(UIHelper.getFrame((Component)this));
        TypeExplorer explorer = chooser.getTypeExplorer();
        ProjectSchemaImportHandler s = new ProjectSchemaImportHandler();
        ProjectWSDLImportHandler w = new ProjectWSDLImportHandler();
        s.setTargetDirLocation(URLFactory.newURL((URL)Helper.getParent((URL)this.m_generalPnl.m_builder.getProjectURL()), (String)"xsd"));
        w.setTargetDirLocation(Helper.getParent((URL)this.m_generalPnl.m_builder.getProjectURL()));
        explorer.setWSDLImportHandler((WSDLImportHandler)w);
        explorer.setSchemaImportHandler((SchemaImportHandler)s);
        CompoundDataSource inputElementDS = new CompoundDataSource();
        inputElementDS.addDataSource((TreeExplorerDataSource)new ProjectSchemaDataSource(JDevHelper.getContext((Project)this.m_generalPnl.m_project), false, true));
        inputElementDS.addDataSource((TreeExplorerDataSource)new ProjectWSDLDataSource(JDevHelper.getContext((Project)this.m_generalPnl.m_project), false, true, false));
        if (chooser.display((TreeExplorerDataSource)inputElementDS) == 0) {
            if (src == this.m_inputBrowseBtn) {
                this.m_inputTypeObj = chooser.getTypeObject();
                QName qname = this.m_inputTypeObj.getQName();
                this.m_inputPartField.setText("{" + qname.getNamespaceURI() + "}" + qname.getLocalPart());
            } else {
                this.m_outputTypeObj = chooser.getTypeObject();
                QName qname = this.m_outputTypeObj.getQName();
                this.m_outputPartField.setText("{" + qname.getNamespaceURI() + "}" + qname.getLocalPart());
            }
        }
    }

    protected URL showResourcePicker(int type) {
        int filter = 12;
        switch (type) {
            case 0: {
                filter = 0;
                break;
            }
        }
        return UIHelper.showResourcePicker((Component)this, (int)filter);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_inputBrowseBtn) {
            this.handleBrowseElement(src);
        } else if (src == this.m_outputBrowseBtn) {
            this.handleBrowseElement(src);
        }
    }

    class ImportedSchemasDataSource
    implements TreeExplorerDataSource {
        protected Icon FOLDER_ICON = TreeExplorerCellRenderer.DEFAULT_ICON;
        TypeExplorerTreeNode m_root;
        SchemaDataSource m_ds;
        TypeExplorer m_explorer;

        public ImportedSchemasDataSource(TypeExplorer explorer, SchemaDataSource ds) {
            this.m_explorer = explorer;
            this.m_ds = ds;
        }

        public TreeExplorerTreeNode[] getRoots() {
            TreeExplorerTreeNode[] roots;
            TextInfo t1 = new TextInfo();
            t1.setText(BPELStringTranslator.getString("PROJECTWIZARD_IMPORTED_SCHEMAS"));
            t1.setFont(TextInfo.PLAIN_FONT);
            t1.setColor(Color.black);
            NodeText nodeTxt = new NodeText(new TextInfo[]{t1}, new TextInfo[]{t1});
            this.m_root = new TypeExplorerTreeNode(new Icon[]{this.FOLDER_ICON}, nodeTxt, (Object)"", null);
            for (TreeExplorerTreeNode root : roots = this.m_ds.getRoots()) {
                this.m_root.add((MutableTreeNode)root);
            }
            return new TreeExplorerTreeNode[]{this.m_root};
        }

        public void addDataSource(SchemaDataSource ds) {
            TreeExplorerTreeNode[] roots;
            DefaultTreeModel model = (DefaultTreeModel)this.m_explorer.getTree().getModel();
            for (TreeExplorerTreeNode root : roots = ds.getRoots()) {
                model.insertNodeInto((MutableTreeNode)root, (MutableTreeNode)this.m_root, this.m_root.getChildCount());
            }
        }
    }

    class ProjectSchemaImportHandler
    extends DefaultSchemaImportHandler {
        public ProjectSchemaImportHandler() {
            super(null);
        }

        public SchemaDataSource getSchemaDataSource(URL url) {
            return new SchemaDataSource(url, false, true, 6);
        }

        public URL getURLToImport(TypeExplorer explorer) {
            return InputOutputPanel.this.showResourcePicker(0);
        }
    }

    class ProjectWSDLImportHandler
    extends DefaultWSDLImportHandler {
        public ProjectWSDLImportHandler() {
            super(null);
        }

        public WSDLDataSource getWSDLDataSource(URL url) {
            WSDLDataSourceObject obj = new WSDLDataSourceObject();
            obj.setUrl(url);
            obj.setShowComplex(false);
            obj.setShowElements(true);
            obj.setShowMessageTypes(false);
            obj.setSourceFileType(5);
            return new WSDLDataSource(obj);
        }

        public URL getURLToImport(TypeExplorer explorer) {
            return InputOutputPanel.this.showResourcePicker(1);
        }
    }
}

