/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.processbuilder.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.jdev.JDevHelper;
import oracle.tip.tools.ide.common.sca.CommonScaUtils;
import oracle.tip.tools.ide.common.ui.CardPanel;
import oracle.tip.tools.ide.common.ui.NCNameField;
import oracle.tip.tools.ide.common.ui.helpcombo.HelpComboBox;
import oracle.tip.tools.ide.pm.designerplugins.standard.plugin.templatetypes.DefineLaterTemplateType;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.metadata.XMLUtil;
import oracle.tip.tools.ide.pm.modules.sca.util.JDevSCAIntegrationUtil;
import oracle.tip.tools.ide.pm.plugin.BPELModelerPlugin;
import oracle.tip.tools.ide.pm.plugin.BPELPlugInManager;
import oracle.tip.tools.ide.pm.plugin.TemplateType;
import oracle.tip.tools.ide.pm.processbuilder.iface.IDEProcessBuilder;
import oracle.tip.tools.ide.pm.processbuilder.model.ProcessData;
import oracle.tip.tools.ide.pm.processbuilder.ui.TemplateComboItem;
import oracle.tip.tools.ide.pm.processbuilder.ui.TemplateTypeCellRenderer;

public class GeneralPanel2
extends JPanel
implements ActionListener {
    public static final String ORACLE_NAMESPACE_PREFIX = "http://xmlns.oracle.com/";
    private static final String EMPTY_PANEL = "EMPTY_PANEL";
    protected NCNameField m_nameField;
    protected JTextField m_namespaceField;
    protected JCheckBox m_exposeAsServiceCB;
    protected NCNameField m_serviceNameField;
    protected JLabel m_serviceNameLbl;
    protected JComboBox m_typeCombo;
    protected CardPanel m_cardPnl;
    protected Project m_project;
    protected IDEProcessBuilder m_builder;
    protected ProcessData m_data;
    protected String m_projectName;
    protected String m_applicationName;
    protected boolean m_hasService = true;

    public GeneralPanel2(ProcessData data, IDEProcessBuilder builder, Project project) {
        this.m_data = data;
        this.m_builder = builder;
        this.m_project = project;
        this.computeNames(builder, project);
        this.createControls();
        this.layoutControls();
        this.onInit();
    }

    protected void computeNames(IDEProcessBuilder builder, Project project) {
        this.m_applicationName = "";
        URL u = JDevHelper.getWorkspace((Project)project).getURL();
        String s = u.toExternalForm();
        int idx = (s = Helper.stripTrailingSlash((String)s)).lastIndexOf(47);
        if (idx != -1) {
            this.m_applicationName = s.substring(idx + 1);
        }
        this.m_projectName = "";
        URL projURL = project.getURL();
        s = projURL.toExternalForm();
        idx = (s = Helper.stripTrailingSlash((String)s)).lastIndexOf(47);
        if (idx != -1) {
            this.m_projectName = s.substring(idx + 1);
        }
        if (this.m_projectName.endsWith(builder.getIDEProjectExtension())) {
            this.m_projectName = this.m_projectName.substring(0, this.m_projectName.length() - builder.getIDEProjectExtension().length());
        }
    }

    public boolean save() {
        int ret;
        String processName = this.m_nameField.getText();
        if (!Helper.hasValue((String)processName) || !XMLUtil.isValidName(processName)) {
            GraphUtils.displayMessage((Component)this, (String)BPELStringTranslator.getString("PROJECTWIZARD_INVALID_PROCESS_NAME"), (int)0);
            return false;
        }
        String serviceName = this.m_serviceNameField.getText();
        if (!Helper.hasValue((String)serviceName) && this.m_hasService) {
            GraphUtils.displayMessage((Component)this, (String)BPELStringTranslator.getString("PROJECTWIZARD_EMPTY_SERVICE_NAME"), (int)0);
            return false;
        }
        boolean bUnique = true;
        try {
            bUnique = JDevSCAIntegrationUtil.isNameUniqueWithinComposite(this.m_project, processName);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (!bUnique) {
            GraphUtils.displayMessage((Component)this, (String)BPELStringTranslator.formatString("PROCESS_ALREADY_EXIST_TITLE", processName), (int)0);
            this.m_nameField.requestFocus();
            return false;
        }
        String nameSpace = this.m_namespaceField.getText();
        if (!Helper.hasValue((String)nameSpace) || nameSpace.indexOf(" ") != -1) {
            GraphUtils.displayMessage((Component)this, (String)BPELStringTranslator.getString("PROJECTWIZARD_INVALID_NAMESPACE"), (int)0);
            return false;
        }
        URL dirURL = this.m_builder.getProjectURL();
        URL processURL = URLFactory.newURL((URL)dirURL, (String)(processName + ".bpel"));
        if (Helper.exists((URL)processURL) && (ret = GraphUtils.showConfirmDialog((Component)this, (String)BPELStringTranslator.formatString("PROCESS_ALREADY_EXIST_MSG", processURL.getFile()), (String)BPELStringTranslator.getString("PROCESS_ALREADY_EXIST_TITLE"))) == 1) {
            return false;
        }
        TemplateType templateType = this.getSelectedTemplateType();
        templateType.saveToProcessData(this.m_data);
        this.m_data.m_processName = this.m_nameField.getText();
        this.m_data.m_namespace = nameSpace;
        this.m_data.m_projectDirectory = dirURL;
        this.m_data.m_templateID = templateType.getTemplateID();
        this.m_data.m_bExportAsService = this.m_exposeAsServiceCB.isSelected();
        this.m_data.m_serviceName = this.m_serviceNameField.getText();
        return true;
    }

    protected void handleProcessNameChange() {
        String appName = CommonScaUtils.getEncodedName((String)this.m_applicationName.replaceAll("-", "_").replaceAll(" ", "_").replaceAll("\\.", "_"));
        String projName = CommonScaUtils.getEncodedName((String)this.m_projectName.replaceAll("-", "_").replaceAll(" ", "_").replaceAll("\\.", "_"));
        String bpelName = CommonScaUtils.getEncodedName((String)this.m_nameField.getText());
        String ns = ORACLE_NAMESPACE_PREFIX + appName + "/" + projName + "/" + bpelName;
        this.m_namespaceField.setText(ns);
        this.m_serviceNameField.setText(this.m_nameField.getText().toLowerCase() + "_client");
    }

    protected void onInit() {
        String extension;
        URL projectURL = this.m_builder.getProjectURL();
        String processName = Helper.getFileName((URL)projectURL);
        if (processName.endsWith(extension = this.m_builder.getIDEProjectExtension())) {
            processName = processName.substring(0, processName.length() - extension.length());
        }
        this.m_nameField.setText(processName);
        DefaultComboBoxModel<TemplateComboItem> m = new DefaultComboBoxModel<TemplateComboItem>();
        for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
            List<TemplateType> templateTypes = plugin.getTemplateTypes();
            if (templateTypes == null) continue;
            for (TemplateType templateType : templateTypes) {
                m.addElement(new TemplateComboItem(templateType));
                this.m_cardPnl.add(templateType.getTemplateID(), (Component)templateType.getTemplateEditor(this));
            }
        }
        this.m_typeCombo.setModel(m);
        if (m.getSize() > 0) {
            this.m_typeCombo.setSelectedIndex(0);
        }
        this.m_serviceNameField.setText(processName.toLowerCase() + "_client");
    }

    protected void createControls() {
        this.m_cardPnl = new CardPanel();
        this.m_cardPnl.add(EMPTY_PANEL, (Component)new JPanel());
        this.m_typeCombo = new JComboBox();
        this.m_typeCombo.addActionListener(this);
        this.m_typeCombo.setRenderer(new TemplateTypeCellRenderer());
        this.m_cardPnl.show(EMPTY_PANEL);
        this.m_nameField = new NCNameField(new String[]{".", "-"});
        this.m_nameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                GeneralPanel2.this.handleProcessNameChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                GeneralPanel2.this.handleProcessNameChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                GeneralPanel2.this.handleProcessNameChange();
            }
        });
        this.m_namespaceField = new JTextField(ORACLE_NAMESPACE_PREFIX);
        this.m_exposeAsServiceCB = new JCheckBox("", this.m_data.m_bExportAsService);
        this.m_exposeAsServiceCB.addActionListener(this);
        BPELStringTranslator.setButton(this.m_exposeAsServiceCB, BPELStringTranslator.getString("ENABLE_SERVICE"));
        this.m_serviceNameField = new NCNameField(new String[]{".", "-"});
        this.m_serviceNameLbl = new JLabel();
        BPELStringTranslator.setLabel(this.m_serviceNameLbl, (Component)this.m_serviceNameField, BPELStringTranslator.getString("BPEL_PROCESS_SERVICE_NAME_WIZARD"));
    }

    protected void layoutControls() {
        JLabel processLbl = new JLabel();
        BPELStringTranslator.setLabel(processLbl, (Component)this.m_nameField, BPELStringTranslator.getString("BPEL_PROCESS_NAME_WIZARD"));
        JLabel namespaceLbl = new JLabel();
        BPELStringTranslator.setLabel(namespaceLbl, this.m_namespaceField, BPELStringTranslator.getString("BPEL_NAMESPACE"));
        JLabel templateLbl = new JLabel();
        BPELStringTranslator.setLabel(templateLbl, this.m_typeCombo, BPELStringTranslator.getString("BPEL_PROCESS_TEMPLATE_WIZARD"));
        HelpComboBox helpCombo = new HelpComboBox(this.m_typeCombo);
        this.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)this, (Component)processLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_nameField, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(10, 5, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)namespaceLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 10, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_namespaceField, (int)1, (int)row++, (int)12, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)templateLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 10, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)helpCombo, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_serviceNameLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 10, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_serviceNameField, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        if (!this.m_data.m_bFromBPEL) {
            GraphUtils.addComponent((Container)this, (Component)this.m_exposeAsServiceCB, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        }
        GraphUtils.addComponent((Container)this, (Component)this.m_cardPnl, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(5, 5, 10, 10), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    protected TemplateType getSelectedTemplateType() {
        TemplateComboItem item = (TemplateComboItem)this.m_typeCombo.getSelectedItem();
        if (item != null) {
            return item.getTemplateType();
        }
        return null;
    }

    protected void handleTemplateTypeSelected() {
        TemplateType t = this.getSelectedTemplateType();
        if (t != null) {
            this.m_cardPnl.show(t.getTemplateID());
            this.m_hasService = !(t instanceof DefineLaterTemplateType) && !t.getTemplateID().equals("SUBSCRIBE_EVENTS");
            this.m_exposeAsServiceCB.setVisible(this.m_hasService);
            this.m_serviceNameField.setVisible(this.m_hasService);
            this.m_serviceNameLbl.setVisible(this.m_hasService);
        } else {
            this.m_cardPnl.show(EMPTY_PANEL);
            this.m_exposeAsServiceCB.setVisible(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_typeCombo) {
            this.handleTemplateTypeSelected();
        }
    }

    public Project getProject() {
        return this.m_project;
    }
}

