/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.processbuilder.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.ide.model.Project;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.BaseDialog;
import oracle.tip.tools.ide.common.ui.WizardTitlePanel;
import oracle.tip.tools.ide.common.ui.statusglasspane.StatusGlassPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.help.HelpSystem;
import oracle.tip.tools.ide.pm.processbuilder.iface.IDEProcessBuilder;
import oracle.tip.tools.ide.pm.processbuilder.iface.IDEProcessBuilderStatusCallback;
import oracle.tip.tools.ide.pm.processbuilder.model.ProcessData;
import oracle.tip.tools.ide.pm.processbuilder.ui.GeneralPanel2;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class BPELProcessCreateDialog
extends BaseDialog
implements ActionListener {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    public static final int GENERAL_TAB_INDEX = 0;
    protected JButton m_cancelBtn;
    protected JButton m_okBtn;
    protected JButton m_helpBtn;
    protected int m_retVal = 1;
    protected ProcessData m_data;
    protected IDEProcessBuilder m_builder;
    protected GeneralPanel2 m_generalPnl;
    protected Project m_project;

    public BPELProcessCreateDialog(JFrame f, ProcessData data, IDEProcessBuilder projectBuilder, Project prj) {
        super(f, BPELStringTranslator.getString("CREATE_BPEL_PROCESS", "Create BPEL Process"), true);
        this.m_builder = projectBuilder;
        this.m_data = data;
        this.m_project = prj;
        this.createControls();
        this.layoutControls();
    }

    public int display() {
        this.setVisible(true);
        return this.m_retVal;
    }

    protected void createControls() {
        this.m_generalPnl = new GeneralPanel2(this.m_data, this.m_builder, this.m_project);
        this.m_cancelBtn = new JButton();
        BPELStringTranslator.setButton(this.m_cancelBtn, BPELStringTranslator.getString("CANCEL_BUTTON_TEXT_RES"));
        this.m_cancelBtn.addActionListener(this);
        this.m_okBtn = new JButton();
        BPELStringTranslator.setButton(this.m_okBtn, BPELStringTranslator.getString("OK_BUTTON_TEXT_RES"));
        this.m_okBtn.addActionListener(this);
        this.getRootPane().setDefaultButton(this.m_okBtn);
        this.m_helpBtn = new JButton();
        BPELStringTranslator.setButton(this.m_helpBtn, BPELStringTranslator.getString("HELP_BUTTON_TEXT_RES"));
        this.m_helpBtn.addActionListener(this);
    }

    protected void layoutControls() {
        String desc = BPELStringTranslator.getString("BPEL_PROCESS_DESC");
        WizardTitlePanel titlePnl = new WizardTitlePanel(BPELStringTranslator.getString("BPEL_PROCESS", "BPEL Process"), desc, ImageCache.getIcon("application/bpel/bpel_header.png"));
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)c, (Component)titlePnl, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)this.m_generalPnl, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)c, (Component)this.m_helpBtn, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)btnPnl, (int)1, (int)row, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 0, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setSize(600, 410);
        this.setLocationRelativeTo(this.getParent());
    }

    protected void handleHelp(Component comp) {
        String topicId = HelpSystem.getHelpTopicId(this.getClass().getName());
        Container p = SwingUtilities.getAncestorOfClass(Window.class, this.getParent());
        if (p != null) {
            HelpSystem.showHelp((Window)p, comp, topicId);
        } else {
            HelpSystem.showHelp(comp, topicId);
        }
    }

    protected void handleCancel() {
        this.m_retVal = 1;
        this.dispose();
    }

    protected void handleEnterKey() {
        this.handleOK();
    }

    protected void handleOK() {
        if (!this.m_generalPnl.save()) {
            return;
        }
        final StatusGlassPane glass = new StatusGlassPane((Component)this.getContentPane());
        final IDEProcessBuilderStatusCallback callback = new IDEProcessBuilderStatusCallback(){

            @Override
            public void displayMessage(String msg) {
                glass.setStatusMessage(BPELStringTranslator.getString("PLEASE_WAIT_MSG"), msg);
            }
        };
        glass.enableUserInput(false);
        glass.setStatusMessage(BPELStringTranslator.getString("PLEASE_WAIT_MSG"), BPELStringTranslator.getString("BUILDING_BPEL_PROCESS"));
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (BPELProcessCreateDialog.this.m_builder.createIDEProject(BPELProcessCreateDialog.this.m_data, callback)) {
                        BPELProcessCreateDialog.this.closeDialog(0);
                    }
                }
                finally {
                    glass.enableUserInput(true);
                }
            }
        };
        new Thread(r).start();
    }

    protected void closeDialog(final int retVal) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.m_retVal = retVal;
            this.dispose();
        } else {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    BPELProcessCreateDialog.this.m_retVal = retVal;
                    BPELProcessCreateDialog.this.dispose();
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_cancelBtn) {
            this.handleCancel();
        } else if (src == this.m_okBtn) {
            this.handleOK();
        } else if (src == this.m_helpBtn) {
            this.handleHelp(this.getContentPane());
        }
    }
}

