/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.processbuilder.jdev;

import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.compiler.OjcConfiguration;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.PartnerLinkType;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpeldesigner.util.PartnerLinkWSDLUtil;
import oracle.tip.tools.ide.common.bpeldesigner.util.TemplateUtil;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ide.IDE;
import oracle.tip.tools.ide.common.ide.IDEResolver;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.utils.BPELWSDLNode;
import oracle.tip.tools.ide.common.utils.CustomizationUtil;
import oracle.tip.tools.ide.common.utils.IOUtil;
import oracle.tip.tools.ide.common.utils.WSDLImport;
import oracle.tip.tools.ide.common.utils.WSDLUtil;
import oracle.tip.tools.ide.common.utils.XMLIDGenerator;
import oracle.tip.tools.ide.fabric.api.EventInfo;
import oracle.tip.tools.ide.pm.addin.model.BPELNode;
import oracle.tip.tools.ide.pm.addin.preferences.BPELDesignerSettings;
import oracle.tip.tools.ide.pm.bpelgraph.settings.BPELSettings;
import oracle.tip.tools.ide.pm.bpelgraph.settings.GraphicsFileUtil;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.processbuilder.model.ProcessData;
import oracle.tip.tools.ide.pm.processbuilder.model.ProjectImportedURLInfo;

public class ProcessBuilderUtil {
    private static final String RELATIVE_XSD_PATH = "xsd/";

    public static void setJDevProjectProperties(ProcessData wizardData, BPELProject prj) {
        Project m_project = (Project)prj.getProjectContext();
        if (wizardData.m_wsdlURL != null) {
            String fileName = URLFileSystem.getFileName((URL)wizardData.m_wsdlURL);
            m_project.setProperty(wizardData.m_processName + "_wsdl", fileName);
        } else {
            m_project.setProperty(wizardData.m_processName + "_wsdl", wizardData.m_processName + ".wsdl");
        }
        m_project.setProperty("Namespace", wizardData.m_namespace);
        m_project.setProperty("ProcessName", wizardData.m_processName);
        m_project.setProperty(wizardData.m_processName + "_" + "Namespace", wizardData.m_namespace);
        m_project.setProperty(wizardData.m_processName + "_" + "ProcessName", wizardData.m_processName);
        if (wizardData.m_templateID != null) {
            m_project.setProperty("Template", wizardData.m_templateID);
            m_project.setProperty(wizardData.m_processName + "_" + "Template", wizardData.m_templateID);
        }
        OjcConfiguration ojcConfig = OjcConfiguration.getInstance((PropertyStorage)m_project);
        ProcessBuilderUtil.removeXMLFromResources(ojcConfig);
    }

    public static JFrame getIDEFrame() {
        IDE ide = IDEResolver.getIDE();
        if (ide != null) {
            return ide.getFrame();
        }
        return null;
    }

    public static void openEditor(final URL url, ProcessData processData) {
        if (!processData.m_bOpenEditor) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                IDE ide = IDEResolver.getIDE();
                if (ide != null) {
                    try {
                        ide.openEditor(url);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public static void createDefaultGraphicsFile(BPELProject prj) {
        try {
            URL url = prj.getGraphicsFileURL();
            BPELSettings settings = BPELDesignerSettings.getGlobalSettings().getData();
            GraphicsFileUtil.save(settings, url);
        }
        catch (Exception e) {
            GraphUtils.displayError((Component)IDEResolver.getIDE().getFrame(), (Throwable)e);
        }
    }

    public static void createRootDirectory(BPELProject project) {
        if (!URLFileSystem.exists((URL)project.getBPELDirectoryURL())) {
            URLFileSystem.mkdir((URL)project.getBPELDirectoryURL());
        }
    }

    public static void createDesignerDirectory(BPELProject project) {
        if (!URLFileSystem.exists((URL)project.getDesignerDirectoryURL())) {
            URLFileSystem.mkdir((URL)project.getDesignerDirectoryURL());
        }
    }

    public static void removeXMLFromResources(OjcConfiguration ojc) {
        String[] lRes = ojc.getCopyRes();
        ArrayList<String> listOfRes = new ArrayList<String>();
        for (String s : lRes) {
            if (s.equalsIgnoreCase(".xml")) continue;
            listOfRes.add(s);
        }
        String[] lNewRes = listOfRes.toArray(new String[0]);
        ojc.setCopyRes(lNewRes);
    }

    public static void writeBPELFileToDisk(BPELProject bpelProject, URL url, ProcessData data, String content) throws Exception {
        File file = Helper.getFile((URL)url);
        String bpelMarkup = content;
        boolean bWriteToFile = true;
        if (bpelMarkup == null) {
            int lastPeriodIndex = file.getAbsolutePath().lastIndexOf(".");
            String wsdlLocation = file.getAbsolutePath().substring(0, lastPeriodIndex) + ".wsdl";
            wsdlLocation = "file:///" + wsdlLocation.replace('\\', '/');
            String templateID = data.m_templateID;
            String processName = data.m_processName;
            String namespace = data.m_namespace;
            String servicveName = data.m_serviceName;
            if ("BPEL_SYNC_PROCESS".equals(templateID)) {
                bpelMarkup = TemplateUtil.getSyncBPELTemplate((String)processName, (String)namespace, (String)wsdlLocation, (String)servicveName);
            } else if ("BPEL_ASYNC_PROCESS".equals(templateID)) {
                bpelMarkup = TemplateUtil.getAsyncBPELTemplate((String)processName, (String)namespace, (String)wsdlLocation, (String)servicveName);
            } else if ("BPEL_ONE_WAY_PROCESS".equals(templateID)) {
                bpelMarkup = TemplateUtil.getOneWayBPELTemplate((String)processName, (String)namespace, (String)wsdlLocation, (String)servicveName);
            } else if ("BPEL_EMPTY_PROCESS".equals(templateID)) {
                bpelMarkup = TemplateUtil.getEmptyBPELTemplate((String)processName, (String)namespace, (String)wsdlLocation);
            } else if ("BPEL_BASE_ON_WSDL".equals(templateID)) {
                bpelMarkup = data.m_outputPortQName != null ? TemplateUtil.getAsyncBPELTemplateBasedOnWSDL((String)processName, (String)namespace, (String)wsdlLocation, (String)servicveName, (PartnerLinkType)data.m_plinkType, (QName)data.m_inputPortQName, (QName)data.m_outputPortQName) : TemplateUtil.getSyncBPELTemplateBasedOnWSDL((String)processName, (String)namespace, (String)wsdlLocation, (String)servicveName, (PartnerLinkType)data.m_plinkType, (QName)data.m_inputPortQName);
            } else if ("SUBSCRIBE_EVENTS".equals(templateID)) {
                if (data.m_eventInfo != null) {
                    Project proj = (Project)bpelProject.getProjectContext();
                    ArrayList<QName> eventQNs = new ArrayList<QName>();
                    ArrayList<QName> eTypeQNs = new ArrayList<QName>();
                    for (EventInfo einfo : data.m_eventInfo) {
                        QName eventQName = new QName(einfo.getNamespace(), einfo.getName());
                        eventQNs.add(eventQName);
                        QName eventTypeQName = einfo.getEventSchemaElement(proj);
                        eTypeQNs.add(eventTypeQName);
                    }
                    bpelMarkup = TemplateUtil.getSubscribeEventBPELTemplate((String)processName, (String)namespace, eventQNs, eTypeQNs);
                }
            } else {
                bWriteToFile = false;
            }
        }
        if (bWriteToFile) {
            if (CustomizationUtil.isCurrentProjectCustomizable()) {
                bpelMarkup = XMLIDGenerator.getInstance().generateXmlIdForDocumentString(bpelMarkup);
            }
            IOUtil.writeStringToFile((String)bpelMarkup, (File)file);
        }
    }

    public static void createGraphicsFile(BPELProject bpelProject) {
        boolean bCreate = true;
        URL graphicsFileURL = bpelProject.getGraphicsFileURL();
        if (URLFileSystem.exists((URL)graphicsFileURL)) {
            String msg = BPELStringTranslator.formatString("FILE_ALREADY_EXIST_MSG", graphicsFileURL.toString());
            String title = BPELStringTranslator.getString("FILE_ALREADY_EXIST_TITLE");
            if (GraphUtils.showConfirmDialog((Component)ProcessBuilderUtil.getIDEFrame(), (String)msg, (String)title) != 0) {
                bCreate = false;
            }
        }
        if (bCreate) {
            ProcessBuilderUtil.createDefaultGraphicsFile(bpelProject);
        }
    }

    public static void createWSDLFiles(BPELProject bpelProject, ProcessData wizardData) throws Exception {
        boolean bUserImportingSchemas;
        Project project = (Project)bpelProject.getProjectContext();
        String id = wizardData.m_templateID;
        boolean bl = bUserImportingSchemas = !(id == null || (wizardData.m_inputInfo == null && wizardData.m_outputInfo == null || !"BPEL_ASYNC_PROCESS".equals(id) && !"BPEL_SYNC_PROCESS".equals(id) && !"BPEL_ONE_WAY_PROCESS".equals(id)) && !"SUBSCRIBE_EVENTS".equals(id));
        if (bUserImportingSchemas && !ProcessBuilderUtil.createProjectWSDLFile(bpelProject, wizardData)) {
            throw new Exception("Unable to create project WSDL files!");
        }
        if (id != null && id.equals("BPEL_BASE_ON_WSDL")) {
            Definition def = WSDLUtil.parseWSDL((URL)wizardData.m_wsdlURL);
            PartnerLinkType pltype = PartnerLinkWSDLUtil.findPartlinkFromPortTypes((QName)wizardData.m_inputPortQName, (QName)wizardData.m_outputPortQName, (Definition)def);
            if (pltype == null) {
                pltype = PartnerLinkWSDLUtil.createPartnerLinkType((QName)wizardData.m_inputPortQName, null, (QName)wizardData.m_outputPortQName, null, (String)wizardData.m_processName, (Definition)def);
                String newWsdlLoc = PartnerLinkWSDLUtil.addPartlinkFromPortTypes((PartnerLinkType)pltype, (URL)wizardData.m_wsdlURL, (BPELProject)bpelProject);
                wizardData.m_wsdlURL = URLFactory.newURL((String)newWsdlLoc);
            }
            wizardData.m_plinkType = pltype;
        } else {
            URL wsdlURL = URLFactory.newURL((URL)bpelProject.getWSDLRoot(), (String)(wizardData.m_processName + ".wsdl"));
            WSDLUtil.getWSDLFile((Project)project, (URL)wsdlURL, (URL)bpelProject.getXSDRoot(), (String)wizardData.m_processName, (String)wizardData.m_namespace, (String)wizardData.m_templateID, (String)RELATIVE_XSD_PATH);
        }
    }

    public static void createBPELFile(BPELProject bpelProject, ProcessData wizardData, String fileContents) throws Exception {
        Project m_project = (Project)bpelProject.getProjectContext();
        URL bpelFileURL = bpelProject.getBPELFileURL();
        ProcessBuilderUtil.writeBPELFileToDisk(bpelProject, bpelFileURL, wizardData, fileContents);
        Node bpelNode = ProcessBuilderUtil.createNavigatorNode(BPELNode.class, bpelFileURL);
        ProcessBuilderUtil.addToProject(m_project, bpelNode);
    }

    public static boolean copyFileToBPELProject(URL bpelDirURL, URL origFile) {
        boolean bSuccess = false;
        try {
            if (URLFileSystem.isBaseURLFor((URL)bpelDirURL, (URL)origFile)) {
                return true;
            }
            if (!origFile.getProtocol().equalsIgnoreCase("file")) {
                return true;
            }
            URL newURL = URLFactory.newURL((URL)bpelDirURL, (String)URLFileSystem.getFileName((URL)origFile));
            if (URLFileSystem.equals((URL)origFile, (URL)newURL)) {
                return true;
            }
            URLFileSystem.copy((URL)origFile, (URL)newURL);
            bSuccess = true;
        }
        catch (Exception ex) {
            bSuccess = false;
        }
        return bSuccess;
    }

    public static WSDLImport createWSDLImport(ProjectImportedURLInfo info, URL projURL) {
        WSDLImport imp = new WSDLImport();
        imp.setLocationURI(URLFileSystem.toRelativeSpec((URL)info.getImportedURL(), (URL)projURL));
        imp.setNamespaceURI(info.getNamespaceURI());
        imp.setXSDImport(info.isXSDImport());
        return imp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createProjectWSDLFile(BPELProject bpelProject, ProcessData data) {
        boolean bSuccess = false;
        String processName = bpelProject.getProcessName();
        URL wsdlURL = bpelProject.getWSDLFileURL(processName);
        WSDLImport inputImport = null;
        if (data.m_inputInfo != null) {
            inputImport = ProcessBuilderUtil.createWSDLImport(data.m_inputInfo, Helper.getParent((URL)data.m_projectDirectory));
            if (!ProcessBuilderUtil.copyFileToBPELProject(data.m_inputInfo.isXSDImport() ? bpelProject.getXSDRoot() : bpelProject.getWSDLRoot(), data.m_inputInfo.getImportedURL())) {
                return false;
            }
        }
        WSDLImport outputImport = null;
        if (data.m_outputInfo != null) {
            if (data.m_inputInfo != null) {
                URL impURL = data.m_inputInfo.getImportedURL();
                if (!impURL.equals(data.m_outputInfo.getImportedURL())) {
                    outputImport = ProcessBuilderUtil.createWSDLImport(data.m_outputInfo, Helper.getParent((URL)data.m_projectDirectory));
                    if (!ProcessBuilderUtil.copyFileToBPELProject(data.m_outputInfo.isXSDImport() ? bpelProject.getXSDRoot() : bpelProject.getWSDLRoot(), data.m_outputInfo.getImportedURL())) {
                        return false;
                    }
                }
            } else {
                outputImport = ProcessBuilderUtil.createWSDLImport(data.m_outputInfo, Helper.getParent((URL)data.m_projectDirectory));
                if (!ProcessBuilderUtil.copyFileToBPELProject(data.m_outputInfo.isXSDImport() ? bpelProject.getXSDRoot() : bpelProject.getWSDLRoot(), data.m_outputInfo.getImportedURL())) {
                    return false;
                }
            }
        }
        String template = "";
        if ("BPEL_ASYNC_PROCESS".equals(data.m_templateID)) {
            try {
                TemplateUtil.createSchemaFile((URL)bpelProject.getXSDRoot(), (QName)data.m_inputqname, (QName)data.m_outputqname, (String)data.m_namespace, (String)data.m_processName, (boolean)false);
            }
            catch (Exception ex) {
                return false;
            }
            template = TemplateUtil.getAsyncWSDLTemplate((String)data.m_processName, (String)data.m_namespace, (QName)data.m_inputqname, (QName)data.m_outputqname, (WSDLImport)inputImport, (WSDLImport)outputImport, (String)RELATIVE_XSD_PATH);
        } else if ("BPEL_SYNC_PROCESS".equals(data.m_templateID)) {
            try {
                TemplateUtil.createSchemaFile((URL)bpelProject.getXSDRoot(), (QName)data.m_inputqname, (QName)data.m_outputqname, (String)data.m_namespace, (String)data.m_processName, (boolean)true);
            }
            catch (Exception ex) {
                return false;
            }
            template = TemplateUtil.getSyncWSDLTemplate((String)data.m_processName, (String)data.m_namespace, (QName)data.m_inputqname, (QName)data.m_outputqname, (WSDLImport)inputImport, (WSDLImport)outputImport, (String)RELATIVE_XSD_PATH, (String)data.m_templateID);
        } else if ("BPEL_ONE_WAY_PROCESS".equals(data.m_templateID)) {
            try {
                TemplateUtil.createSchemaFile((URL)bpelProject.getXSDRoot(), (QName)data.m_inputqname, null, (String)data.m_namespace, (String)data.m_processName, (boolean)true);
            }
            catch (Exception ex) {
                return false;
            }
            template = TemplateUtil.getSyncWSDLTemplate((String)data.m_processName, (String)data.m_namespace, (QName)data.m_inputqname, null, (WSDLImport)inputImport, null, (String)RELATIVE_XSD_PATH, (String)data.m_templateID);
        } else if ("SUBSCRIBE_EVENTS".equals(data.m_templateID) && data.m_eventInfo != null) {
            Project proj = (Project)bpelProject.getProjectContext();
            ArrayList<URL> urls = new ArrayList<URL>();
            ArrayList<QName> eventQNs = new ArrayList<QName>();
            ArrayList<QName> eTypeQNs = new ArrayList<QName>();
            ArrayList<WSDLImport> imports = new ArrayList<WSDLImport>();
            for (EventInfo einfo : data.m_eventInfo) {
                URL impURL = einfo.getEventSchemaUrl(proj);
                if (urls.contains(impURL)) continue;
                urls.add(impURL);
                QName eventQName = new QName(einfo.getNamespace(), einfo.getName());
                eventQNs.add(eventQName);
                QName eventTypeQName = einfo.getEventSchemaElement(proj);
                eTypeQNs.add(eventTypeQName);
                ProjectImportedURLInfo inputImp = new ProjectImportedURLInfo();
                inputImp.setImportedURL(einfo.getEventSchemaUrl(proj));
                inputImp.setNamespaceURI(einfo.getEventSchemaElement(proj).getNamespaceURI());
                inputImp.setXSDImport(true);
                inputImport = ProcessBuilderUtil.createWSDLImport(inputImp, Helper.getParent((URL)data.m_projectDirectory));
                imports.add(inputImport);
                if (ProcessBuilderUtil.copyFileToBPELProject(inputImp.isXSDImport() ? bpelProject.getXSDRoot() : bpelProject.getWSDLRoot(), inputImp.getImportedURL())) continue;
                return false;
            }
            template = TemplateUtil.getEventWSDLTemplate((String)data.m_processName, (String)data.m_namespace, null, null, imports, null, (String)RELATIVE_XSD_PATH, (String)data.m_templateID);
        }
        URL xsdURL = URLFactory.newURL((URL)bpelProject.getXSDRoot(), (String)(data.m_processName + ".xsd"));
        ProcessBuilderUtil.registerBpelXSdNavigatorNode(bpelProject, xsdURL);
        if (template.length() > 0) {
            OutputStreamWriter pw = null;
            try {
                pw = new OutputStreamWriter((OutputStream)new BufferedOutputStream(URLFileSystem.openOutputStream((URL)wsdlURL)), "UTF8");
                pw.write(template);
                ProcessBuilderUtil.registerBpelWSDLNavigatorNode(bpelProject, wsdlURL);
                bSuccess = true;
            }
            catch (IOException ioex) {
                ioex.printStackTrace(System.err);
            }
            finally {
                if (pw != null) {
                    try {
                        pw.close();
                    }
                    catch (Exception ex) {}
                }
            }
        }
        return bSuccess;
    }

    private static void registerBpelWSDLNavigatorNode(BPELProject bpelProject, URL wsdlURL) {
        Node bpelNode = ProcessBuilderUtil.createNavigatorNode(BPELWSDLNode.class, wsdlURL);
        Project m_project = (Project)bpelProject.getProjectContext();
        ProcessBuilderUtil.addToProject(m_project, bpelNode);
    }

    private static void registerBpelXSdNavigatorNode(BPELProject bpelProject, URL wsdlURL) {
        Node bpelNode = ProcessBuilderUtil.createNavigatorNode(XMLSourceNode.class, wsdlURL);
        Project m_project = (Project)bpelProject.getProjectContext();
        ProcessBuilderUtil.addToProject(m_project, bpelNode);
    }

    public static void addToProject(Project project, Node nodeToRegister) {
        if (nodeToRegister == null || project == null) {
            return;
        }
        project.add(nodeToRegister, "oracle.tip.tools.ide.fabric.addin.SCAContentSetProvider/sca-content");
        UpdateMessage.fireChildAdded((Subject)project, (Element)nodeToRegister);
    }

    public static Node createNavigatorNode(Class nodeClass, URL fileURL) {
        try {
            return NodeFactory.findOrCreate((URL)fileURL);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void saveJDevProject(BPELProject prj) throws Exception {
        Project project = (Project)prj.getProjectContext();
        project.save();
    }
}

