/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.processbuilder.jdev;

import java.awt.Component;
import java.net.URL;
import oracle.ide.model.Project;
import oracle.ide.net.DefaultNameGenerator;
import oracle.ide.net.NameGenerator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ide.IDEResolver;
import oracle.tip.tools.ide.fabric.addin.SCAProject;
import oracle.tip.tools.ide.pm.ide.bpel.jdeveloper.JDevBPELProject;
import oracle.tip.tools.ide.pm.modules.sca.util.SCAProcessBuilderUtil;
import oracle.tip.tools.ide.pm.processbuilder.iface.IDEProcessBuilder;
import oracle.tip.tools.ide.pm.processbuilder.iface.IDEProcessBuilderStatusCallback;
import oracle.tip.tools.ide.pm.processbuilder.jdev.ProcessBuilderUtil;
import oracle.tip.tools.ide.pm.processbuilder.model.ProcessData;

public class BPELProcessBuilder
implements IDEProcessBuilder {
    protected SCAProject m_scaProject;
    protected Project m_project;

    public BPELProcessBuilder(Project project) {
        this.m_project = project;
        this.m_scaProject = SCAProject.getSCAProject((Project)project);
    }

    @Override
    public boolean createIDEProject(ProcessData processData, IDEProcessBuilderStatusCallback status) {
        try {
            JDevBPELProject bpelProject = new JDevBPELProject(this.m_project, processData.m_processName);
            ProcessBuilderUtil.setJDevProjectProperties(processData, bpelProject);
            ProcessBuilderUtil.createRootDirectory(bpelProject);
            ProcessBuilderUtil.createDesignerDirectory(bpelProject);
            ProcessBuilderUtil.createWSDLFiles(bpelProject, processData);
            ProcessBuilderUtil.createGraphicsFile(bpelProject);
            ProcessBuilderUtil.createBPELFile(bpelProject, processData, null);
            ProcessBuilderUtil.saveJDevProject(bpelProject);
            SCAProcessBuilderUtil.createSCAComponents(processData, bpelProject, this.m_scaProject, this.m_project);
            ProcessBuilderUtil.openEditor(bpelProject.getBPELFileURL(), processData);
        }
        catch (Exception e) {
            GraphUtils.displayError((Component)IDEResolver.getIDE().getFrame(), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public String getIDEProjectExtension() {
        return ".jpr";
    }

    @Override
    public URL getProjectURL() {
        DefaultNameGenerator generator;
        URL projectURL = this.m_scaProject.getSCARoot();
        URL fileURL = URLFactory.newUniqueURL((URL)projectURL, (NameGenerator)(generator = new DefaultNameGenerator("BPELProcess", ".bpel", 1)));
        String name = URLFileSystem.getFileName((URL)fileURL);
        if (name.endsWith(".bpel")) {
            name = name.substring(0, name.length() - ".bpel".length());
        }
        return URLFactory.newURL((URL)projectURL, (String)(name + ".jpr"));
    }
}

