/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.plugin;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.plugin.BPELParserPlugin;
import oracle.tip.tools.ide.pm.bpelgraph.model.ModelBuilder;
import oracle.tip.tools.ide.pm.bpelgraph.model.ModelBuilderPlugin;
import oracle.tip.tools.ide.pm.bpelgraph.views.NodeEditorFactory;
import oracle.tip.tools.ide.pm.bpelgraph.views.NodeEditorSource;
import oracle.tip.tools.ide.pm.designerplugins.activityguide.plugin.ActivityGuideBPELModelerPlugin;
import oracle.tip.tools.ide.pm.designerplugins.adapterservice.plugin.AdapterBPELModelerPlugin;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.plugin.ExtensionsBPELModelerPlugin;
import oracle.tip.tools.ide.pm.designerplugins.phase.plugin.PhaseBPELModelerPlugin;
import oracle.tip.tools.ide.pm.designerplugins.resourcecatalog.plugin.ResourceCatalogBPELModelerPlugin;
import oracle.tip.tools.ide.pm.designerplugins.rules.plugin.RulesBPELModelerPlugin;
import oracle.tip.tools.ide.pm.designerplugins.sca.plugin.SCABPELModelerPlugin;
import oracle.tip.tools.ide.pm.designerplugins.standard.plugin.StandardBPELModelerPlugin;
import oracle.tip.tools.ide.pm.designerplugins.workflow.plugin.WorkflowBPELModelerPlugin;
import oracle.tip.tools.ide.pm.plugin.BPELModelerPlugin;
import oracle.tip.tools.ide.pm.plugin.BPELModelerPluginEvent;

public class BPELPlugInManager {
    private static boolean m_bInitialized = false;
    private static List<BPELModelerPlugin> m_plugins = new ArrayList<BPELModelerPlugin>();

    public static synchronized void shutdownPlugins() {
        for (BPELModelerPlugin plugin : m_plugins) {
            plugin.shutdown();
        }
    }

    public static synchronized void initializePlugins() {
        if (!m_bInitialized) {
            BPELPlugInManager.installPlugin(new StandardBPELModelerPlugin());
            BPELPlugInManager.installPlugin(new ExtensionsBPELModelerPlugin());
            BPELPlugInManager.installPlugin(new ResourceCatalogBPELModelerPlugin());
            BPELPlugInManager.installPlugin(new WorkflowBPELModelerPlugin());
            BPELPlugInManager.installPlugin(new AdapterBPELModelerPlugin());
            BPELPlugInManager.installPlugin(new SCABPELModelerPlugin());
            BPELPlugInManager.installPlugin(new RulesBPELModelerPlugin());
            BPELPlugInManager.installPlugin(new PhaseBPELModelerPlugin());
            BPELPlugInManager.installPlugin(ActivityGuideBPELModelerPlugin.createPlugin());
            m_bInitialized = true;
        }
    }

    public static List<BPELModelerPlugin> getPlugins() {
        return m_plugins;
    }

    public static BPELModelerPlugin getPluginByClass(Class clz) {
        for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
            if (!plugin.getClass().equals(clz)) continue;
            return plugin;
        }
        return null;
    }

    public static synchronized void installPlugin(BPELModelerPlugin plugin) {
        BPELPlugInManager.installPlugin(plugin, false);
    }

    public static synchronized void installPlugin(BPELModelerPlugin plugin, boolean bFront) {
        ModelBuilderPlugin modelPlugin;
        NodeEditorSource editorSource;
        if (plugin == null || m_plugins.contains(plugin)) {
            return;
        }
        if (bFront) {
            m_plugins.add(0, plugin);
        } else {
            m_plugins.add(plugin);
        }
        BPELParserPlugin parserPlugin = plugin.getBPELParserPlugin();
        if (parserPlugin != null) {
            BPELParser.getPlugins().add(0, parserPlugin);
        }
        if ((editorSource = plugin.getNodeEditorSource()) != null) {
            NodeEditorFactory.addNodeEditorSource(editorSource);
        }
        if ((modelPlugin = plugin.getModelBuilderPlugin()) != null) {
            ModelBuilder.addModelBuilderPlugin(modelPlugin);
        }
        plugin.initialize();
    }

    public static void notifyResourceDeleted(URL resourceURL, String resourceDescription) {
        for (BPELModelerPlugin plugin : m_plugins) {
            plugin.resourceWasDeleted(resourceURL, resourceDescription);
        }
    }

    public static void firePluginEvent(BPELModelerPluginEvent evt) {
        for (BPELModelerPlugin plugin : m_plugins) {
            plugin.firePluginEvent(evt);
        }
    }
}

