/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.wizard;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.utils.WSDLUtil;
import oracle.tip.tools.ide.pm.modules.workflow.wizard.ParameterNameProvider;
import oracle.tip.tools.ide.workflow.api.IPayloadData;

public class PayloadImpl
implements IPayloadData {
    private static final String XML_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    private Variable mVariable = null;
    private String mName = null;
    private String mType = "Element";
    private QName mContent = null;
    private String mTypeData = null;
    private String mNamespace = null;
    private boolean modifiable = true;
    private List<String> mSchemaLocations = new ArrayList<String>();
    private ParameterNameProvider mNameProvider = null;
    private BPELProject mProject = null;
    private Process mProcess = null;
    private Map properties = new HashMap();

    public PayloadImpl(Variable pVariable, ParameterNameProvider pNameProvider, BPELProject project, Process process) {
        if (pVariable == null) {
            throw new IllegalArgumentException("input variable cannot be null");
        }
        if (pNameProvider == null) {
            throw new IllegalArgumentException("parameter name provider cannot be null");
        }
        if (project == null || process == null) {
            throw new IllegalArgumentException("either process or project is null");
        }
        this.mProcess = process;
        this.mProject = project;
        this.initialize(pVariable, pNameProvider);
    }

    private void initialize(Variable pVariable, ParameterNameProvider pNameProvider) {
        this.mVariable = pVariable;
        this.mNameProvider = pNameProvider;
        this.prepareType();
        this.prepareTypeData();
        this.prepareNamespace();
        this.prepareSchemaLocations();
    }

    private void prepareType() {
        this.mContent = this.mVariable.getType();
        if (this.mContent != null) {
            String nsURI = this.mContent.getNamespaceURI();
            this.mType = XML_NAMESPACE.equals(nsURI) ? "SimpleType" : "ComplexType";
            this.mName = this.mNameProvider.getName();
        } else {
            this.mContent = this.mVariable.getElement();
            this.mName = this.mContent.getLocalPart();
            if (this.mContent == null) {
                throw new IllegalStateException("we have been had. Spit out the crap!");
            }
        }
    }

    private void prepareTypeData() {
        this.mTypeData = this.mContent.getLocalPart();
    }

    private void prepareNamespace() {
        this.mNamespace = this.mContent.getNamespaceURI();
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String pName) {
        this.mName = pName;
    }

    public void setType(String pType) {
        this.mType = pType;
    }

    public String getType() {
        return this.mType;
    }

    public void setTypeData(String pTypeData) {
        this.mTypeData = pTypeData;
    }

    public String getTypeData() {
        return this.mTypeData;
    }

    public void setNamespace(String pNamespace) {
        this.mNamespace = pNamespace;
    }

    public String getNamespace() {
        return this.mNamespace;
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    public void setModifiable(boolean pValue) {
        this.modifiable = pValue;
    }

    public void setSchemaLocations(List<String> pList) {
        if (pList == null) {
            this.mSchemaLocations.clear();
        }
        if (this.mSchemaLocations != pList) {
            this.mSchemaLocations.addAll(pList);
        }
    }

    public List<String> getSchemaLocations() {
        return this.mSchemaLocations;
    }

    private void prepareSchemaLocations() {
        try {
            URL url = WSDLUtil.resolveElementToFile((Definition)this.mProject.getWSDLFileDefinition(), (String)this.mNamespace, (String)this.mName, (boolean)true);
            this.mSchemaLocations.add(url.toExternalForm());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void update(IPayloadData pData) {
        if (pData == null) {
            return;
        }
        this.setModifiable(pData.isModifiable());
        this.setName(pData.getName());
        this.setNamespace(pData.getNamespace());
        this.setSchemaLocations(pData.getSchemaLocations());
        this.setType(pData.getType());
        this.setTypeData(pData.getTypeData());
    }

    public boolean isValid() {
        return this.mName != null && this.mNamespace != null && this.mType != null && this.mTypeData != null;
    }

    public void setProperty(Object key, Object value) {
        this.properties.put(key, value);
    }

    public Object getProperty(Object key) {
        return this.properties.get(key);
    }

    public Collection<IPayloadData> getPayloadComponents() {
        ArrayList<IPayloadData> c = new ArrayList<IPayloadData>();
        c.add(this);
        return c;
    }

    public String getPayloadType() {
        return "Normal";
    }

    public Map getProperties() {
        return this.properties;
    }
}

