/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.workflow.wizard.IVariableToPayloadTranslator;
import oracle.tip.tools.ide.pm.modules.workflow.wizard.ParameterData;
import oracle.tip.tools.ide.workflow.api.IPayloadData;

public class ParameterTableModel
extends AbstractTableModel {
    private static final String VARIABLE = BPELStringTranslator.getString("SOURCE_TITLE");
    private static final String PARAMETER = BPELStringTranslator.getString("PAYLOAD_IN_TASK");
    private static final String[] COLUMNS = new String[]{VARIABLE, PARAMETER};
    private static final int COLUMN_COUNT = COLUMNS.length;
    private List<ParameterData> mData = new ArrayList<ParameterData>();
    private Map<Integer, IPayloadData> mVariableToPayloadData = new HashMap<Integer, IPayloadData>();
    private IVariableToPayloadTranslator mTranslator = null;

    public ParameterTableModel(IVariableToPayloadTranslator pTranslator) {
    }

    @Override
    public int getRowCount() {
        return this.mData.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_COUNT;
    }

    @Override
    public Object getValueAt(int row, int column) {
        ParameterData pd = this.mData.get(row);
        return pd;
    }

    public ParameterData getParameter(int pRow) {
        return this.mData.get(pRow);
    }

    public void update(int row, ParameterData pData) {
        if (pData == null) {
            return;
        }
        this.mData.set(row, pData);
        this.fireTableRowsUpdated(row, row);
    }

    @Override
    public String getColumnName(int column) {
        return COLUMNS[column];
    }

    public void add(ParameterData pData) {
        if (pData != null) {
            this.mData.add(pData);
            int last = this.mData.size() - 1;
            this.fireTableRowsInserted(last, last);
        }
    }

    public void delete(ParameterData pData) {
        this.mData.remove(pData);
        this.fireTableDataChanged();
    }

    public void delete(Collection<ParameterData> params) {
        if (this.mData.removeAll(params)) {
            this.fireTableDataChanged();
        }
    }

    public void delete(int[] rows) {
        ArrayList<ParameterData> c = new ArrayList<ParameterData>();
        for (int i = 0; i < rows.length; ++i) {
            c.add(this.mData.get(rows[i]));
        }
        this.delete(c);
    }

    public Collection<ParameterData> getData() {
        return this.mData;
    }

    public Collection<IPayloadData> getParameters() {
        ArrayList<IPayloadData> c = new ArrayList<IPayloadData>();
        for (ParameterData pd : this.mData) {
            c.add(pd.getPayload());
        }
        return c;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public Collection<Integer> isInAValidState() {
        ArrayList<Integer> rows = new ArrayList<Integer>();
        for (int i = 0; i < this.mData.size(); ++i) {
            ParameterData pd = this.mData.get(i);
            if (pd.isValid()) continue;
            rows.add(i);
        }
        return rows;
    }
}

