/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.wizard;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.tip.tools.ide.pm.modules.workflow.wizard.CopyInformationProvider;
import oracle.tip.tools.ide.pm.modules.workflow.wizard.INamespaceStateProvider;
import oracle.tip.tools.ide.pm.modules.workflow.wizard.ParameterData;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;
import oracle.tip.tools.ide.workflow.api.IPayloadData;

public class ParameterRenderer
extends DefaultTableCellRenderer {
    private static final Color COLOR_UNSELECTED = new Color(243, 243, 243);
    private static final Icon IMAGE = ImageCache.getIcon("check16");
    private static final String MODIFIABLE = "Can modify in worklist? ";
    private static final String YES = "Yes";
    private static final String NO = "No";
    private final INamespaceStateProvider mProvider;
    private CopyInformationProvider mCopyInformationProvider = new CopyInformationProvider();

    public ParameterRenderer(INamespaceStateProvider provider) {
        this.mProvider = provider;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof ParameterData) {
            this.setData((ParameterData)value, column);
        }
        return this;
    }

    private void setData(ParameterData pData, int column) {
        if (column == 0) {
            this.handleCopy(pData);
        } else if (column == 1) {
            this.handlePayload(pData);
        }
    }

    private void handleCopy(ParameterData pData) {
        String text = this.mCopyInformationProvider.getFromInformation(pData.getCopy());
        this.setText(text);
        this.setToolTipText(text);
    }

    private void handlePayload(ParameterData pData) {
        IPayloadData data = pData.getPayload();
        String name = data.getName();
        String namespace = data.getNamespace();
        boolean e = data.isModifiable();
        StringBuilder sb = new StringBuilder();
        if (this.mProvider.isShowNamespaceSet()) {
            sb.append("{" + namespace + "}");
        }
        sb.append(name);
        String canModify = MODIFIABLE + (e ? YES : NO);
        this.setText(sb.toString());
        this.setToolTipText(sb.toString());
    }

    private void handleParameterName(ParameterData pData) {
        IPayloadData ipd = pData.getPayload();
        if (ipd == null) {
            this.setText(null);
        } else {
            this.setText(ipd.getName());
        }
    }

    private void handleParameterType(ParameterData pData) {
        IPayloadData ipd = pData.getPayload();
        if (ipd == null) {
            this.setText(null);
        } else {
            this.setText("{" + ipd.getNamespace() + "} " + ipd.getType());
        }
    }

    private void handleParameterEditable(ParameterData pData) {
        IPayloadData ipd = pData.getPayload();
        this.setText(null);
        this.setIcon(null);
        if (ipd != null) {
            Boolean b = ipd.isModifiable();
            this.setIcon(this.getIcon(b));
            this.setHorizontalAlignment(0);
        }
    }

    protected Icon getIcon(boolean pValue) {
        if (pValue) {
            return IMAGE;
        }
        return null;
    }
}

