/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.wizard;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.ide.util.ResourceUtils;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.WorkflowEditorContext;
import oracle.tip.tools.ide.pm.modules.workflow.wizard.INamespaceStateProvider;
import oracle.tip.tools.ide.pm.modules.workflow.wizard.IVariableToPayloadTranslator;
import oracle.tip.tools.ide.pm.modules.workflow.wizard.ParameterAddAction;
import oracle.tip.tools.ide.pm.modules.workflow.wizard.ParameterData;
import oracle.tip.tools.ide.pm.modules.workflow.wizard.ParameterDeleteAction;
import oracle.tip.tools.ide.pm.modules.workflow.wizard.ParameterEditAction;
import oracle.tip.tools.ide.pm.modules.workflow.wizard.ParameterNameProvider;
import oracle.tip.tools.ide.pm.modules.workflow.wizard.ParameterRenderer;
import oracle.tip.tools.ide.pm.modules.workflow.wizard.ParameterTableModel;
import oracle.tip.tools.ide.pm.modules.workflow.wizard.VariableToPayloadTranslator;
import oracle.tip.tools.ide.workflow.api.IPayloadData;

public class ParameterProviderPanel
extends JPanel
implements INamespaceStateProvider {
    private static final String PARAMETERS = BPELStringTranslator.getString("PARAMETERS");
    private static final String TYPE_UNKNOWN = BPELStringTranslator.getString("TYPE_UNKNOWN");
    private static final String ERROR = BPELStringTranslator.getString("TASK_CONFIGURATION_ERROR");
    private static final String SHOW_NAMESPACES = BPELStringTranslator.getString("EDITOR_VARS_EDIT_PNL_SHOW_NS_URI");
    private Action mAddAction = null;
    private Action mEditAction = null;
    private Action mDeleteAction = null;
    private ParameterTableModel mTableModel = null;
    private JTable mTable = null;
    private WorkflowEditorContext mContext = null;
    private IVariableToPayloadTranslator mTranslator = null;
    private ParameterNameProvider mNameProvider = null;
    private JCheckBox mShowNamespaces = null;

    public ParameterProviderPanel(WorkflowEditorContext pContext) {
        this.mContext = pContext;
        this.initialize();
        this.layoutComponents();
    }

    private Action[] getActions() {
        return new Action[]{this.mAddAction, this.mEditAction, this.mDeleteAction};
    }

    @Override
    public boolean isShowNamespaceSet() {
        return this.mShowNamespaces.isSelected();
    }

    private void initialize() {
        BPELGraphPane pane = this.mContext.getGraphPane();
        this.mTableModel = new ParameterTableModel(null);
        this.mTable = new JTable(this.mTableModel);
        this.mAddAction = new ParameterAddAction(this.mContext, this.mTableModel);
        this.mDeleteAction = new ParameterDeleteAction(this.mTable);
        this.mEditAction = new ParameterEditAction(this.mContext, this.mTable, this.mTableModel);
        this.mTable.setRowHeight(25);
        this.mTable.setDefaultRenderer(Object.class, new ParameterRenderer(this));
        this.mTable.setRowSelectionAllowed(true);
        this.mNameProvider = new ParameterNameProvider(this.mTableModel);
        this.mTranslator = new VariableToPayloadTranslator(pane.getBPELProject(), ((BPELGraphModel)pane.getModel()).getProcess());
        this.mShowNamespaces = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.mShowNamespaces, (String)SHOW_NAMESPACES);
        this.mShowNamespaces.addActionListener(new LocalNamespaceListener());
        this.mShowNamespaces.setSelected(false);
    }

    private void layoutComponents() {
        JPanel buttonPanel = this.createButtonPanel();
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        int x = 0;
        int y = 0;
        gbl.setConstraints(buttonPanel, new GridBagConstraints(x, y, 0, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add(buttonPanel);
        JScrollPane sp = new JScrollPane(this.mTable);
        sp.getViewport().setBackground(Color.WHITE);
        gbl.setConstraints(sp, new GridBagConstraints(x, ++y, 1, 1, 1.0, 1.0, 21, 1, new Insets(0, 5, 0, 0), 0, 0));
        this.add(sp);
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        BoxLayout bl = new BoxLayout(panel, 2);
        panel.setLayout(bl);
        JLabel label = new JLabel();
        ResourceUtils.resLabel((JLabel)label, (Component)this.mTable, (String)PARAMETERS);
        panel.add(label);
        panel.add(Box.createHorizontalGlue());
        Action[] actions = this.getActions();
        for (int i = 0; i < actions.length; ++i) {
            JButton button = new JButton(actions[i]);
            UIHelper.setupButton((JButton)button);
            panel.add(button);
            if (i == actions.length - 1) continue;
            panel.add(Box.createHorizontalStrut(2));
        }
        panel.setMaximumSize(new Dimension(Short.MAX_VALUE, panel.getPreferredSize().height));
        return panel;
    }

    public Collection<ParameterData> getAllParameters() {
        return this.mTableModel.getData();
    }

    public Collection<IPayloadData> getParameters() {
        return this.mTableModel.getParameters();
    }

    public void isInAValidState() throws Exception {
        Collection<Integer> c = this.mTableModel.isInAValidState();
        if (c.size() > 0) {
            throw new Exception(ERROR);
        }
    }

    private class LocalNamespaceListener
    implements ActionListener {
        private LocalNamespaceListener() {
        }

        @Override
        public void actionPerformed(ActionEvent pEvent) {
            ParameterProviderPanel.this.mTableModel.fireTableDataChanged();
        }
    }

    class LocalTableCellRenderer
    extends DefaultTableCellRenderer {
        LocalTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable pTable, Object pValue, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(pTable, pValue, isSelected, hasFocus, row, column);
            if (pValue instanceof IPayloadData) {
                IPayloadData ip = (IPayloadData)pValue;
                String ns = ip.getNamespace();
                StringBuilder text = new StringBuilder();
                if (ParameterProviderPanel.this.mShowNamespaces.isSelected()) {
                    text.append("{" + ns + "} ");
                }
                text.append(ip.getTypeData());
                this.setText(text.toString());
            }
            this.setToolTipText(this.getText());
            return this;
        }
    }
}

