/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.wizard;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.tip.tools.ide.common.ui.DialogOKListener;
import oracle.tip.tools.ide.common.ui.GenericDialog;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.IHelpUtil;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.WorkflowEditorContext;
import oracle.tip.tools.ide.pm.modules.workflow.help.WorkflowHelpSystem;
import oracle.tip.tools.ide.pm.modules.workflow.wizard.ParameterData;
import oracle.tip.tools.ide.pm.modules.workflow.wizard.ParameterDetailsPanel;
import oracle.tip.tools.ide.pm.modules.workflow.wizard.ParameterTableModel;
import oracle.tip.tools.ide.pm.modules.workflow.wizard.ParameterValidator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class ParameterEditAction
extends AbstractAction {
    private static final String TITLE = BPELStringTranslator.getString("EDIT_TASK_PARAMETER");
    private ParameterTableModel mTableModel = null;
    private WorkflowEditorContext mContext = null;
    private JTable mTable;
    private ParameterDetailsPanel mPanel;
    private OKListener mOKListener = null;

    public ParameterEditAction(WorkflowEditorContext pContext, JTable pTable, ParameterTableModel pModel) {
        if (pContext == null || pTable == null || pModel == null) {
            throw new IllegalArgumentException("inputs are not valid: context = " + pContext + ", " + "table = " + pTable + ", " + "model = " + pModel);
        }
        this.putValue("SmallIcon", ImageCache.getIcon("edit16"));
        this.putValue("ShortDescription", TITLE);
        this.mTable = pTable;
        this.mTableModel = pModel;
        this.mContext = pContext;
        this.setEnabled(false);
        this.mPanel = new ParameterDetailsPanel(this.mContext);
        this.mOKListener = new OKListener(this.mPanel);
        this.mTable.getSelectionModel().addListSelectionListener(new LocalSelectionListener());
    }

    @Override
    public void actionPerformed(ActionEvent pEvent) {
        Component c = (Component)pEvent.getSource();
        JFrame frame = UIHelper.getFrame((Component)c);
        GenericDialog dialog = new GenericDialog((Frame)frame, true);
        dialog.setButtons(28);
        dialog.setContent((JComponent)this.mPanel);
        dialog.setTitle(TITLE);
        dialog.addOKListener((DialogOKListener)this.mOKListener);
        dialog.setSize(550, 400);
        dialog.setHelpProvider((IHelpUtil)new WorkflowHelpSystem());
        int row = this.mTable.getSelectedRow();
        ParameterData data = this.mTableModel.getParameter(row);
        this.mPanel.setData(data);
        if (dialog.showDialog(false, true) == 200) {
            data = this.mPanel.getData();
            this.mTableModel.update(row, data);
        }
    }

    private class LocalSelectionListener
    implements ListSelectionListener {
        private LocalSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent pEvent) {
            if (pEvent.getValueIsAdjusting()) {
                return;
            }
            int[] rows = ParameterEditAction.this.mTable.getSelectedRows();
            ParameterEditAction.this.setEnabled(false);
            if (rows == null || rows.length == 0 || rows.length > 1) {
                return;
            }
            ParameterEditAction.this.setEnabled(true);
        }
    }

    private class OKListener
    implements DialogOKListener {
        private ParameterDetailsPanel mPanel = null;
        ParameterValidator mValidator = new ParameterValidator();

        public OKListener(ParameterDetailsPanel panel) {
            this.mPanel = panel;
        }

        public void OKOccured() throws Exception {
            if (this.mPanel != null) {
                this.mPanel.validateData();
            }
        }
    }
}

