/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import oracle.ide.util.ResourceUtils;
import oracle.tip.tools.ide.common.ide.integration.IntegrationProject;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.WorkflowEditorContext;
import oracle.tip.tools.ide.pm.modules.workflow.wizard.CopyInformationProvider;
import oracle.tip.tools.ide.pm.modules.workflow.wizard.IParameterDataProvider;
import oracle.tip.tools.ide.pm.modules.workflow.wizard.ParameterBrowseAction;
import oracle.tip.tools.ide.pm.modules.workflow.wizard.ParameterData;
import oracle.tip.tools.ide.workflow.api.PayloadDetailsPanel;

public class ParameterDetailsPanel
extends JPanel {
    private static final String SOURCE_CANNOT_BE_EMPTY = BPELStringTranslator.getString("SOURCE_CANNOT_BE_EMPTY");
    private static final String CHOOSE_PARAMETER = BPELStringTranslator.getString("CHOOSE_PARAMETER");
    private static final String SOURCE = BPELStringTranslator.getString("SOURCE");
    private Action mSourceAction;
    private WorkflowEditorContext mContext;
    private IntegrationProject mProject;
    private PayloadDetailsPanel mPayloadPanel;
    private JTextField mSourceField;
    private ParameterData mData = null;
    private CopyInformationProvider mCopyInformationProvider = null;
    private JButton mBrowseButton = null;

    public ParameterDetailsPanel(WorkflowEditorContext pContext) {
        if (pContext == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        this.mContext = pContext;
        this.mProject = this.mContext.getProject();
        if (this.mProject == null) {
            throw new IllegalArgumentException("project cannot be null");
        }
        this.initialize();
        this.layoutComponents();
    }

    private void initialize() {
        this.mCopyInformationProvider = new CopyInformationProvider();
        this.mSourceField = new JTextField();
        this.mSourceAction = new ParameterBrowseAction(this.mContext, new LocalParameterProvider());
        this.mPayloadPanel = new PayloadDetailsPanel(this.mProject);
        this.mBrowseButton = new JButton(this.mSourceAction);
        UIHelper.setupButton((JButton)this.mBrowseButton);
        this.mSourceField.setEditable(false);
    }

    private void layoutComponents() {
        JPanel topPanel = this.prepareTopPanel();
        JPanel bottomPanel = this.prepareBottomPanel();
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        int x = 0;
        int y = 0;
        gbl.setConstraints(topPanel, new GridBagConstraints(x, y, 0, -1, 1.0, 0.0, 21, 2, new Insets(2, 4, 2, 4), 0, 0));
        this.add(topPanel);
        gbl.setConstraints(bottomPanel, new GridBagConstraints(x, ++y, 0, 0, 1.0, 1.0, 21, 1, new Insets(6, 2, 2, 2), 0, 0));
        this.add(bottomPanel);
    }

    private JPanel prepareBottomPanel() {
        GridBagLayout gbl = new GridBagLayout();
        JPanel panel = new JPanel(gbl);
        int x = 0;
        int y = 0;
        gbl.setConstraints((Component)this.mPayloadPanel, new GridBagConstraints(x, y, 0, 1, 1.0, 1.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.mPayloadPanel);
        return panel;
    }

    private JPanel prepareTopPanel() {
        GridBagLayout gbl = new GridBagLayout();
        JPanel panel = new JPanel(gbl);
        int x = 0;
        int y = 0;
        Insets insets = new Insets(0, 0, 0, 0);
        JLabel directive = new JLabel();
        ResourceUtils.resLabel((JLabel)directive, (Component)directive, (String)CHOOSE_PARAMETER);
        gbl.setConstraints(directive, new GridBagConstraints(x, y, 0, 1, 1.0, 0.0, 21, 0, insets, 0, 0));
        panel.add(directive);
        JLabel source = new JLabel();
        ResourceUtils.resLabel((JLabel)source, (Component)this.mSourceField, (String)SOURCE);
        gbl.setConstraints(source, new GridBagConstraints(x, ++y, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 40, 5, 0), 0, 0));
        panel.add(source);
        gbl.setConstraints(this.mSourceField, new GridBagConstraints(++x, y, 1, 1, 1.0, 0.0, 21, 2, new Insets(5, 5, 0, 0), 0, 0));
        panel.add(this.mSourceField);
        gbl.setConstraints(this.mBrowseButton, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add(this.mBrowseButton);
        x = 0;
        Component glue = Box.createVerticalGlue();
        gbl.setConstraints(glue, new GridBagConstraints(x, ++y, 0, 0, 0.0, 1.0, 21, 3, insets, 0, 0));
        panel.add(glue);
        Border inside = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        Border outside = BorderFactory.createEtchedBorder();
        CompoundBorder border = BorderFactory.createCompoundBorder(outside, inside);
        panel.setBorder(border);
        return panel;
    }

    public void setData(ParameterData pData) {
        this.mData = pData == null ? new ParameterData() : new ParameterData(pData);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ParameterDetailsPanel.this.fillUI();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public ParameterData getData() {
        this.mData.setPayload(this.mPayloadPanel.getData());
        return this.mData;
    }

    private void fillUI() {
        this.fillSource();
        this.mPayloadPanel.setData(this.mData.getPayload());
    }

    private void fillSource() {
        this.mSourceField.setText(this.mCopyInformationProvider.getFromInformation(this.mData.getCopy()));
    }

    public void validateData() throws Exception {
        String source = this.mSourceField.getText();
        if (source == null || source.trim().length() == 0) {
            throw new IllegalStateException(SOURCE_CANNOT_BE_EMPTY);
        }
        this.mPayloadPanel.validateData();
    }

    class LocalParameterProvider
    implements IParameterDataProvider {
        LocalParameterProvider() {
        }

        @Override
        public ParameterData getParameter() {
            return ParameterDetailsPanel.this.mData;
        }

        @Override
        public void parameterUpdated(ParameterData pData) {
            ParameterDetailsPanel.this.mData.update(pData);
            ParameterDetailsPanel.this.fillSource();
        }
    }
}

