/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.wizard;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.workflow.wizard.ParameterTableModel;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class ParameterDeleteAction
extends AbstractAction {
    private static final String DELETE_PARAMETER = BPELStringTranslator.getString("DELETE_TASK_PARAMETER");
    private ParameterTableModel mTableModel = null;
    private JTable mTable = null;

    public ParameterDeleteAction(JTable pTable) {
        this.putValue("ShortDescription", DELETE_PARAMETER);
        this.putValue("SmallIcon", ImageCache.getIcon("delete16"));
        this.mTable = pTable;
        this.mTableModel = (ParameterTableModel)pTable.getModel();
        this.mTable.getSelectionModel().addListSelectionListener(new LocalListSelectionListener());
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent pEvent) {
        int[] rows = this.mTable.getSelectedRows();
        this.mTableModel.delete(rows);
    }

    class LocalListSelectionListener
    implements ListSelectionListener {
        LocalListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ParameterDeleteAction.this.setEnabled(false);
            int start = e.getFirstIndex();
            if (start == -1) {
                return;
            }
            ParameterDeleteAction.this.setEnabled(true);
        }
    }
}

