/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.wizard;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFrame;
import oracle.tip.tools.ide.common.ui.DialogOKListener;
import oracle.tip.tools.ide.common.ui.GenericDialog;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.IHelpUtil;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.WorkflowEditorContext;
import oracle.tip.tools.ide.pm.modules.workflow.help.WorkflowHelpSystem;
import oracle.tip.tools.ide.pm.modules.workflow.wizard.ParameterData;
import oracle.tip.tools.ide.pm.modules.workflow.wizard.ParameterDetailsPanel;
import oracle.tip.tools.ide.pm.modules.workflow.wizard.ParameterTableModel;
import oracle.tip.tools.ide.pm.modules.workflow.wizard.ParameterValidator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;
import oracle.tip.tools.ide.workflow.api.IPayloadContainer;
import oracle.tip.tools.ide.workflow.api.IPayloadData;
import oracle.tip.tools.ide.workflow.api.PayloadDataFactory;

public class ParameterAddAction
extends AbstractAction {
    private static final String TITLE = BPELStringTranslator.getString("ADD_TASK_PARAMETER");
    private ParameterTableModel mTableModel = null;
    private WorkflowEditorContext mContext = null;
    private PayloadDataFactory mFactory = null;
    private ParameterDetailsPanel mPanel = null;
    private OKListener mListener = null;

    public ParameterAddAction(WorkflowEditorContext pContext, ParameterTableModel pModel) {
        this.putValue("SmallIcon", ImageCache.getIcon("create16"));
        this.putValue("ShortDescription", TITLE);
        this.mTableModel = pModel;
        this.mContext = pContext;
        this.mFactory = new PayloadDataFactory((IPayloadContainer)new LocalContainer());
        this.mPanel = new ParameterDetailsPanel(this.mContext);
        this.mListener = new OKListener(this.mPanel);
    }

    @Override
    public void actionPerformed(ActionEvent pEvent) {
        Component c = (Component)pEvent.getSource();
        JFrame frame = UIHelper.getFrame((Component)c);
        GenericDialog dialog = new GenericDialog((Frame)frame, true);
        dialog.setButtons(28);
        dialog.setTitle(TITLE);
        dialog.setContent((JComponent)this.mPanel);
        dialog.setSize(550, 400);
        dialog.addOKListener((DialogOKListener)this.mListener);
        dialog.setHelpProvider((IHelpUtil)new WorkflowHelpSystem());
        IPayloadData pd = this.mFactory.newPayloadData();
        ParameterData data = new ParameterData();
        data.setPayload(pd);
        this.mPanel.setData(data);
        if (dialog.showDialog(false, true) == 200) {
            data = this.mPanel.getData();
            this.mTableModel.add(data);
        }
    }

    private class OKListener
    implements DialogOKListener {
        private ParameterDetailsPanel mPanel = null;
        ParameterValidator mValidator = new ParameterValidator();

        public OKListener(ParameterDetailsPanel panel) {
            this.mPanel = panel;
        }

        public void OKOccured() throws Exception {
            if (this.mPanel != null) {
                this.mPanel.validateData();
            }
        }
    }

    private class LocalContainer
    implements IPayloadContainer {
        private LocalContainer() {
        }

        public Collection<IPayloadData> getPayloadData() {
            Collection<ParameterData> c = ParameterAddAction.this.mTableModel.getData();
            ArrayList<IPayloadData> cp = new ArrayList<IPayloadData>();
            for (ParameterData pd : c) {
                IPayloadData ipd = pd.getPayload();
                if (ipd == null) continue;
                cp.add(ipd);
            }
            return cp;
        }

        public void setPayloadData(Collection<IPayloadData> pData) {
        }
    }
}

