/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.iface.UserTask;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.ContainerActivity;
import oracle.tip.tools.ide.common.bpelparser.iface.Invoke;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.bpelparser.iface.Variables;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.PartnerLinkNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.SwimLaneNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.SwimLaneView;

public class WFUtil {
    private static final String[] WF_WSDL = new String[]{"oramds:/soa/shared/workflow/TaskServiceInterface.wsdl", "oramds:/soa/shared/workflow/TaskServiceWSIF.wsdl"};
    private static final String[] WF_XSD = new String[]{"oramds:/soa/shared/workflow/TaskService.xsd", "oramds:/soa/shared/workflow/WorkflowCommon.xsd", "oramds:/soa/shared/workflow/WorkflowTask.xsd", "oramds:/soa/shared/workflow/RoutingSlip.xsd"};

    public static void addWFVariable(UserTask ut, Process process) {
        Variable v = WFUtil.createWFVariable(ut);
        process.getVariables().addVariable(v);
    }

    public static void addWFTaskXSDToProject(BPELGraphPane pane, UserTask ut) {
        BPELGraphModel model = (BPELGraphModel)pane.getModel();
        BPELProject project = model.getBPELProject();
        Process process = model.getProcess();
        String configPrefix = process.addNamespace("http://xmlns.oracle.com/bpel/workflow/task", "task");
        try {
            URL outputXsdURL = URLFactory.newURL((URL)project.getXSDRoot(), (String)ut.getTaskXsdFileName());
            if (URLFileSystem.exists((URL)outputXsdURL)) {
                return;
            }
            String inputXsdFileStr = "oracle/tip/pc/services/wsdl/WorkflowTask.xsd";
            URL resource = WFUtil.getClassLoader().getResource(inputXsdFileStr);
            if (resource != null) {
                InputStream in = resource.openStream();
                URLFileSystem.copy((InputStream)in, (URL)outputXsdURL);
                if (project != null) {
                    project.addXSDNode(outputXsdURL);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream inputFile, File outputFile) {
        FileWriter out = null;
        try {
            int c;
            out = new FileWriter(outputFile);
            while ((c = inputFile.read()) != -1) {
                out.write(c);
            }
        }
        catch (IOException e) {
            System.out.println(e.getStackTrace());
        }
        finally {
            try {
                if (inputFile != null) {
                    inputFile.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                System.out.println(e.getStackTrace());
            }
        }
    }

    public static ClassLoader getClassLoader() {
        Thread currentThread = Thread.currentThread();
        ClassLoader classLoader = currentThread.getContextClassLoader();
        return classLoader;
    }

    public static void deleteWFTaskXSDFromProject(BPELGraphPane pane) {
        BPELGraphModel model = (BPELGraphModel)pane.getModel();
        BPELProject project = model.getBPELProject();
        try {
            File XsdFile = new File(project.getBPELDirectoryURL().toExternalForm());
            if (XsdFile.exists() && project != null) {
                URL XsdFileURL = URLFactory.newFileURL((File)XsdFile);
                project.deleteProjectResource(XsdFileURL);
                URLFileSystem.delete((URL)XsdFileURL);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void deleteWFVariable(UserTask ut, Process process) {
        String varName = ut.getVariableName();
        Invoke invoke = ut.getInvoke();
        if (invoke == null) {
            return;
        }
        String operation = invoke.getOperation();
        if (!"reinitiateTask".equalsIgnoreCase(operation) && varName != null && !varName.trim().equals("")) {
            Variables vars = process.getVariables();
            List lst = vars.getVariables();
            for (Variable v : lst) {
                String name = v.getName();
                if (name == null || !name.equals(varName.trim())) continue;
                process.getVariables().deleteVariable(v);
                break;
            }
        }
    }

    public static Variable createWFVariable(UserTask ut) {
        String curVarName = ut.getVariableName();
        Variable v = (Variable)BPELParser.createImplementation(Variable.class);
        if (curVarName != null && !curVarName.trim().equals("")) {
            QName qName = new QName("http://xmlns.oracle.com/bpel/workflow/task", "task", "task");
            v.setName(curVarName);
            v.setElement(qName);
        }
        return v;
    }

    protected static boolean taskServicePartnerlinkExists(Process process) {
        Iterator iter = process.getPartnerLinks().getPartnerLinks().iterator();
        boolean bTMSExists = false;
        while (iter.hasNext() && !bTMSExists) {
            PartnerLink plink = (PartnerLink)iter.next();
            if (!plink.getName().equalsIgnoreCase("TaskService")) continue;
            bTMSExists = true;
        }
        return bTMSExists;
    }

    public static void addTaskServiceWsdlToProject(BPELGraphPane pane) {
        BPELGraphModel model = (BPELGraphModel)pane.getModel();
        BPELProject project = model.getBPELProject();
        Process process = model.getProcess();
        if (!WFUtil.taskServicePartnerlinkExists(process)) {
            URL outputWsdlFileURL = null;
            File outputWsdlFile = new File(project.getBPELDirectoryURL().getFile(), "WorkflowService.wsdl");
            if (!outputWsdlFile.exists()) {
                String inputWsdlFileStr = "oracle/tip/pc/services/wsdl/WorkflowService.wsdl";
                URL resource = WFUtil.getClassLoader().getResource(inputWsdlFileStr);
                if (resource != null) {
                    InputStream ipWsdlFile = null;
                    try {
                        ipWsdlFile = resource.openStream();
                        outputWsdlFile.createNewFile();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    WFUtil.copy(ipWsdlFile, outputWsdlFile);
                    if (project != null) {
                        outputWsdlFileURL = URLFactory.newFileURL((File)outputWsdlFile);
                        try {
                            project.addWSDLNode(outputWsdlFileURL);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                String prefixTms = process.addNamespace("http://xmlns.oracle.com/pcbpel/taskservice/task");
                PartnerLink plink = (PartnerLink)BPELParser.createImplementation(PartnerLink.class);
                plink.setName("TaskService");
                QName qNameTms = new QName("http://xmlns.oracle.com/pcbpel/taskservice/task", "TaskService", prefixTms);
                plink.setPartnerLinkType(qNameTms);
                plink.setPartnerRole("TaskService");
                plink.setMyRole("TaskServiceCallbackListener");
                try {
                    if (outputWsdlFileURL != null && outputWsdlFile.exists()) {
                        String strUrl = outputWsdlFileURL.getFile();
                        plink.setWSDLLocation(strUrl);
                    }
                }
                catch (Exception m) {
                    m.printStackTrace();
                }
                process.getPartnerLinks().addPartnerLink(plink);
                PartnerLinkNode partnerLinkNode = new PartnerLinkNode();
                partnerLinkNode.setUserObject(plink);
                SwimLaneView swimLaneView = pane.getLeftSwimLaneView();
                SwimLaneNode swimLaneNode = (SwimLaneNode)swimLaneView.getNode();
                model.addChildNode((oracle.tip.tools.ide.common.graph.model.Node)swimLaneNode, (oracle.tip.tools.ide.common.graph.model.Node)partnerLinkNode);
            }
        }
    }

    public static void removeTaskServiceWsdlFromProject() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addWFFilesToProject(BPELProject project) {
        int i;
        HashMap<String, URL> wf_file_map = new HashMap<String, URL>();
        for (i = 0; i < WF_WSDL.length; ++i) {
            URL wsdlURL = URLFactory.newURL((URL)project.getWSDLRoot(), (String)WF_WSDL[i]);
            wf_file_map.put(WF_WSDL[i], wsdlURL);
        }
        for (i = 0; i < WF_XSD.length; ++i) {
            URL xsdURL = URLFactory.newURL((URL)project.getXSDRoot(), (String)WF_XSD[i]);
            wf_file_map.put(WF_XSD[i], xsdURL);
        }
        Set keySet = wf_file_map.keySet();
        Iterator iter = keySet.iterator();
        while (iter.hasNext()) {
            InputStream in = null;
            try {
                String key = (String)iter.next();
                String inputFile = "oracle/bpel/services/workflow/schema/" + key;
                URL resource = WFUtil.getClassLoader().getResource(inputFile);
                URL outURL = (URL)wf_file_map.get(key);
                in = resource.openStream();
                if (URLFileSystem.exists((URL)outURL)) continue;
                URLFileSystem.copy((InputStream)in, (URL)outURL);
                Node n = NodeFactory.findOrCreate((URL)outURL);
                Project p = (Project)project.getProjectContext();
                p.add((Element)n);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (in == null) continue;
                try {
                    in.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static boolean canContainUserTask(Activity pActivity) {
        return pActivity instanceof ContainerActivity;
    }

    public static void getUserTasks(ContainerActivity pContainer, List<UserTask> pList) {
        Iterator iter = pContainer.getActivities();
        while (iter.hasNext()) {
            Activity a = (Activity)iter.next();
            if (!WFUtil.canContainUserTask(a)) continue;
            WFUtil.getUserTasks((ContainerActivity)a, pList);
            if (!(a instanceof UserTask)) continue;
            pList.add((UserTask)a);
        }
    }

    public static List findAllDefinedUserTask(UserTask u) {
        return WFUtil.findAllDefinedUserTaskFromParent(u.getParentActivity(), (Activity)u);
    }

    public static List findAllDefinedUserTaskFromParent(Activity parent, Activity siblAct) {
        ArrayList<UserTask> uList = new ArrayList<UserTask>();
        Activity tarAct = siblAct;
        while (parent != null) {
            List cList = BPELModelUtil.getPreviousActivitiesToChild((ContainerActivity)((ContainerActivity)parent), (Activity)tarAct);
            cList.remove(parent);
            for (int i = 0; i < cList.size(); ++i) {
                Activity act = (Activity)cList.get(i);
                if (act instanceof UserTask) {
                    uList.add((UserTask)act);
                }
                if (!WFUtil.canContainUserTask(act)) continue;
                ContainerActivity ca = (ContainerActivity)act;
                WFUtil.getUserTasks(ca, uList);
            }
            tarAct = parent;
            parent = parent.getParentActivity();
        }
        return uList;
    }
}

