/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.resource;

import java.awt.Image;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.ide.Ide;
import oracle.ide.util.GraphicsUtils;
import oracle.tip.tools.ide.common.resource.MessageBundleUtil;
import oracle.tip.tools.ide.pm.addin.model.BPELBeanPropertyElement;

public class WorkflowResourceUtil {
    public static final String WORKFLOW_BUNDLE = "oracle.tip.tools.ide.pm.modules.workflow.resource.WorkflowUIResource";
    public static String MODEL_IMAGE_DIR = "integration/bpm/designer/integration/icons";
    private static ResourceBundle m_bundle;
    private static Hashtable m_iconTable;

    public static String getWorkflowImagesDir() {
        String installPath = Ide.getProperty((String)"Ide.InstallPath");
        File jdevHome = new File(installPath).getParentFile().getParentFile();
        return jdevHome.getAbsolutePath() + System.getProperty("file.separator") + MODEL_IMAGE_DIR;
    }

    public static ResourceBundle getResourceBundle() {
        if (m_bundle == null) {
            m_bundle = MessageBundleUtil.getBundle((String)WORKFLOW_BUNDLE);
        }
        return m_bundle;
    }

    public static String getString(String key) {
        try {
            return WorkflowResourceUtil.getResourceBundle().getString(key);
        }
        catch (Exception e) {
            System.out.println("Resource for " + key + " not found in " + WORKFLOW_BUNDLE);
            return key;
        }
    }

    public static char getMnemonic(String key) {
        String val = WorkflowResourceUtil.getResourceBundle().getString(key);
        return val.charAt(0);
    }

    public static String getString(String key, String defaultVal) {
        try {
            return WorkflowResourceUtil.getResourceBundle().getString(key);
        }
        catch (Exception ex) {
            System.out.println("Resource for " + key + " not found in " + WORKFLOW_BUNDLE);
            return defaultVal;
        }
    }

    public static String formatString(String key, String arg) {
        String msg = WorkflowResourceUtil.getString(key);
        if (arg != null) {
            String[] args = new String[]{arg};
            MessageFormat msgFormat = new MessageFormat(msg);
            msg = msgFormat.format(args);
        }
        return msg;
    }

    public static String formatString(String key, Object[] args) {
        String msg = WorkflowResourceUtil.getString(key);
        if (args != null) {
            MessageFormat msgFormat = new MessageFormat(msg);
            msg = msgFormat.format(args);
        }
        return msg;
    }

    public static Icon getIcon(String iconPath) {
        Image img = GraphicsUtils.loadFromResource((String)iconPath, BPELBeanPropertyElement.class);
        return GraphicsUtils.createImageIcon((Image)img);
    }

    public static Image getImage(String imagePath) {
        return GraphicsUtils.loadFromResource((String)imagePath, BPELBeanPropertyElement.class);
    }

    public static Icon getIcon(String iconPath, Class objClass) {
        Image img = GraphicsUtils.loadFromResource((String)iconPath, (Class)objClass);
        return GraphicsUtils.createImageIcon((Image)img);
    }

    public static ImageIcon getImageIcon(String imageName) {
        ImageIcon imageIcon = null;
        if (m_iconTable.containsKey(imageName)) {
            imageIcon = (ImageIcon)m_iconTable.get(imageName);
        } else {
            String imageFile = WorkflowResourceUtil.getString(imageName);
            URL imageURL = ClassLoader.getSystemResource(imageFile);
            if (imageURL != null) {
                imageIcon = new ImageIcon(imageURL);
                m_iconTable.put(imageName, imageIcon);
            }
        }
        return imageIcon;
    }

    public static Image getImageFromName(String imageName) {
        ImageIcon imageIcon = WorkflowResourceUtil.getImageIcon(imageName);
        if (imageIcon != null) {
            return imageIcon.getImage();
        }
        return null;
    }

    static {
        m_iconTable = new Hashtable(100);
    }
}

