/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.util;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Invoke;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.fabric.api.SCAControllerImpl;
import oracle.tip.tools.ide.fabric.model.SCAComposite;
import oracle.tip.tools.ide.workflow.sca.SCAUtil;

public class WFBpelCodeUtil {
    public static final String QUERY_TITLE = "/task:task/task:title";
    public static final String QUERY_PAYLOAD = "/task:task/task:payload";
    public static final String QUERY_EXPIRATION_DURATION = "/task:task/task:expirationDuration";
    public static final String QUERY_TASK_CONFIG = "/task:task/task:taskType";
    public static final String QUERY_TASK_ROUTING_SLIP = "/task:task/task:taskType";
    public static final String QUERY_INSTANCE_ID = "/task:task/task:instanceId";
    public static final String EXP_INSTANCE_ID = "ora:getInstanceId()";
    public static final String QUERY_PROCESS_NAME = "/task:task/task:processName";
    public static final String EXP_PROCESS_NAME = "ora:getProcessId()";
    public static final String QUERY_PROCESS_ID = "/task:task/task:processId";
    public static final String EXP_PROCESS_ID = "ora:getProcessId()";
    public static final String QUERY_PROCESS_VERSION = "/task:task/task:processVersion";
    public static final String EXP_PROCESS_VERSION = "ora:getProcessVersion()";
    public static final String QUERY_DOMAIN_ID = "/task:task/task:domainId";
    public static final String EXP_DOMAIN_ID = "ora:getDomainId()";
    public static final String QUERY_PROCESS_OWNER = "/task:task/task:processOwner";
    public static final String EXP_PROCESS_OWNER = "ora:getProcessOwnerId()";
    public static final String QUERY_TASK_MSG_PAYLOAD = "payload";
    public static final String TO_VARIABLE_TASK_MSG_PAYLOAD = "oraBPMTaskMessage";

    public static String getTaskFileForPartnerLink(Project project, String plName) {
        SCAUtil scaUtil = new SCAUtil();
        SCAComposite scaComposite = scaUtil.getSCAComposite(project);
        if (scaComposite == null) {
            return null;
        }
        String targetWireName = scaUtil.getTargetWireName(project, plName);
        if (targetWireName == null) {
            return null;
        }
        String target = null;
        target = targetWireName.indexOf("/") != -1 ? targetWireName.substring(0, targetWireName.indexOf("/")) : targetWireName;
        return scaUtil.getImplementation(target, scaComposite);
    }

    public static SCAControllerImpl getSCAController(BPELProject project) {
        Context ct = (Context)project.getIDEContext();
        return new SCAControllerImpl(ct.getProject());
    }

    public static List getPartnerLinksForTaskDef(BPELProject project, String taskFileName, Process processModel) {
        taskFileName = taskFileName + ".task";
        if (project == null || taskFileName == null) {
            return null;
        }
        SCAControllerImpl sca_c = WFBpelCodeUtil.getSCAController(project);
        String componentName = sca_c.getComponentNameByImplemenation(taskFileName);
        if (componentName == null) {
            return null;
        }
        List services = sca_c.getComponentServices(componentName);
        if (services == null || services.size() != 1 || services.get(0) == null) {
            return null;
        }
        List sourceWiresList = sca_c.getWireSourcesByTarget(componentName, services.get(0).toString());
        if (sourceWiresList == null || sourceWiresList.size() == 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int count = 0; count < sourceWiresList.size(); ++count) {
            String ref;
            String wire = (String)sourceWiresList.get(count);
            if (wire == null || !project.getProcessName().equals(WFBpelCodeUtil.getSourceComponent(wire)) || (ref = WFBpelCodeUtil.getReferenceFromWire(wire)) == null) continue;
            boolean pLinkUsed = false;
            List invokes = BPELModelUtil.getAllActivitiesOfType((Process)processModel, Invoke.class);
            for (Invoke invoke : invokes) {
                if (!BPELModelUtil.isActivityUsingPartnerLink((Activity)invoke, (String)ref)) continue;
                pLinkUsed = true;
                break;
            }
            if (pLinkUsed) continue;
            System.out.println("adding ref " + ref);
            list.add(ref);
        }
        return list;
    }

    private static String getReferenceFromWire(String wire) {
        if (wire.indexOf("/") != -1) {
            return wire.substring(wire.indexOf("/") + 1, wire.length());
        }
        return null;
    }

    private static String getSourceComponent(String wire) {
        if (wire.indexOf("/") != -1) {
            return wire.substring(0, wire.indexOf("/"));
        }
        return wire;
    }
}

