/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors.statusrecipient;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors.statusrecipient.StatusRecipientData;

public class StatusRecipientModel
extends AbstractTableModel {
    private static final int ROW_COUNT = 2;
    private static final String TASK_STATUS_HEADER = "Task Status";
    private static final String RECIPIENT_HEADER = "Recipient";
    List mList = new ArrayList();

    public StatusRecipientModel(List pDataObjectList) {
        this.mList = pDataObjectList;
    }

    public StatusRecipientModel() {
    }

    public void setData(List pList) {
        if (pList != null) {
            this.mList = pList;
        }
        this.fireTableDataChanged();
    }

    public void addData(StatusRecipientData pData) {
        this.mList.add(pData);
        this.fireTableRowsInserted(this.mList.size(), this.mList.size());
    }

    public void removeData(StatusRecipientData pData) {
        int i = 0;
        Iterator iter = this.mList.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o != null && o.equals(pData)) {
                iter.remove();
                break;
            }
            ++i;
        }
        this.fireTableRowsDeleted(i, i);
    }

    public void removeDataAt(int pRow) {
        this.mList.remove(pRow);
        this.fireTableRowsDeleted(pRow, pRow);
    }

    @Override
    public int getRowCount() {
        return this.mList.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int pRowIndex, int pColumnIndex) {
        StatusRecipientData d = (StatusRecipientData)this.mList.get(pRowIndex);
        if (pColumnIndex == 0) {
            return d.getTaskStatus();
        }
        return d.getRecipient();
    }

    @Override
    public String getColumnName(int pColumnIndex) {
        if (pColumnIndex == 0) {
            return TASK_STATUS_HEADER;
        }
        return RECIPIENT_HEADER;
    }

    @Override
    public boolean isCellEditable(int pRowIndex, int pColumnIndex) {
        return true;
    }

    @Override
    public void setValueAt(Object obj, int pRowIndex, int pColumnIndex) {
        Object o = this.mList.get(pRowIndex);
        StatusRecipientData data = (StatusRecipientData)o;
        if (pColumnIndex == 0) {
            data.setTaskStatus((String)obj);
        } else {
            data.setRecipient((String)obj);
        }
    }
}

