/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import oracle.ide.util.ResourceUtils;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.Duration;
import oracle.tip.tools.ide.common.bpeldesigner.util.DurationExpressionUtil;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.modules.workflow.resource.WorkflowResourceUtil;

public class WFDurationPanel
extends JPanel
implements ActionListener {
    private String m_labelKey;
    private String m_commentKey;
    private JSpinner m_daySpinner;
    private JSpinner m_hourSpinner;
    private JSpinner m_minSpinner;
    private FocusListener m_listener;
    protected BPELGraphPane m_graph;
    protected Activity m_activity;
    private static int MAX_HOURS_ALLOWED = 1200;
    private static int MAX_MINUTES_ALLOWED = 6000;
    private static int MAX_DAYS_ALLOWED = 36500;

    public WFDurationPanel(BPELGraphPane graph, String labelKey, String commentKey, FocusListener listener) {
        this.m_listener = listener;
        this.m_graph = graph;
        this.m_labelKey = labelKey;
        this.m_commentKey = commentKey;
        this.init();
    }

    private void init() {
        this.createControls();
        this.layoutControls();
    }

    public WFDurationPanel(String labelKey, String commentKey) {
        this.m_labelKey = labelKey;
        this.m_commentKey = commentKey;
        this.init();
    }

    public WFDurationPanel() {
        this(null, null);
    }

    public String getDuration() {
        Duration duration = this.getDurationObject();
        System.out.println("Set value = " + DurationExpressionUtil.getDurationExpression((Duration)duration));
        return DurationExpressionUtil.getDurationExpression((Duration)duration);
    }

    public Duration getDurationObject() {
        Duration duration = new Duration();
        duration.setHourOfDay((Integer)this.m_hourSpinner.getValue());
        duration.setMinute((Integer)this.m_minSpinner.getValue());
        duration.setDay((Integer)this.m_daySpinner.getValue());
        return duration;
    }

    public void setDuration(Duration pDuration) {
        this.m_hourSpinner.setValue(pDuration.getHour());
        this.m_minSpinner.setValue(pDuration.getMinute());
        this.m_daySpinner.setValue(pDuration.getDay());
    }

    public void setDuration(String pDurationAsString) {
        Duration d = DurationExpressionUtil.parseDurationExpression((String)pDurationAsString);
        this.setDuration(d);
    }

    public void loadControls() {
        String durationStr = "";
        if (durationStr != null && !durationStr.equals("")) {
            Duration dur = null;
            try {
                dur = DurationExpressionUtil.parseDurationExpression((String)durationStr);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (dur != null) {
                this.setIntModelValue(this.m_hourSpinner, dur.getHour());
                this.setIntModelValue(this.m_minSpinner, dur.getMinute());
                this.setIntModelValue(this.m_daySpinner, dur.getDay());
            }
        }
    }

    protected void createControls() {
        this.m_hourSpinner = this.createNumberSpinner(MAX_HOURS_ALLOWED, this.m_listener);
        this.m_minSpinner = this.createNumberSpinner(MAX_MINUTES_ALLOWED, this.m_listener);
        this.m_daySpinner = this.createNumberSpinner(MAX_DAYS_ALLOWED, this.m_listener);
    }

    protected void layoutControls() {
        this.setLayout(new GridBagLayout());
        JLabel lblDuration = new JLabel();
        ResourceUtils.resLabel((JLabel)lblDuration, null, (String)WorkflowResourceUtil.getString(this.m_labelKey));
        int row = 0;
        GraphUtils.addComponent((Container)this, (Component)lblDuration, (int)0, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        JPanel durationPanel = new JPanel(new GridBagLayout());
        JLabel lblDay = new JLabel();
        ResourceUtils.resLabel((JLabel)lblDay, (Component)this.getTextField(this.m_daySpinner), (String)"&Day");
        JLabel lblHour = new JLabel();
        ResourceUtils.resLabel((JLabel)lblHour, (Component)this.getTextField(this.m_hourSpinner), (String)"&Hour");
        JLabel lblMinutes = new JLabel();
        ResourceUtils.resLabel((JLabel)lblMinutes, (Component)this.getTextField(this.m_minSpinner), (String)"&Minutes");
        GraphUtils.addComponent((Container)this, (Component)lblDay, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_daySpinner, (int)1, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)lblHour, (int)2, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_hourSpinner, (int)3, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)lblMinutes, (int)4, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_minSpinner, (int)5, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        if (this.m_commentKey != null && !this.m_commentKey.trim().equals("")) {
            JLabel commentExp = new JLabel();
            ResourceUtils.resLabel((JLabel)commentExp, null, (String)WorkflowResourceUtil.getString(this.m_commentKey));
            GraphUtils.addComponent((Container)this, (Component)commentExp, (int)0, (int)row++, (int)0, (int)1, (int)17, (int)2, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
    }

    private void setIntModelValue(JSpinner spinner, Integer i) {
        if (i == null) {
            return;
        }
        spinner.getModel().setValue(i);
    }

    private JFormattedTextField getTextField(JSpinner spinner) {
        JComponent editor = spinner.getEditor();
        if (editor instanceof JSpinner.DefaultEditor) {
            return ((JSpinner.DefaultEditor)editor).getTextField();
        }
        return null;
    }

    private JSpinner createNumberSpinner(int max, FocusListener listener) {
        SpinnerNumberModel model = new SpinnerNumberModel(0, 0, max, 1);
        JSpinner spinner = new JSpinner(model);
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(spinner, "#");
        spinner.setEditor(editor);
        JFormattedTextField ftf = editor.getTextField();
        ftf.setHorizontalAlignment(4);
        ftf.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        ftf.addFocusListener(listener);
        return spinner;
    }
}

