/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.util.ResourceUtils;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors.ResourceDetailsData;

public class ResourceDetailsPanel
extends JPanel {
    private static final String RESOURCE_NAME = "Resource &Name";
    private static final String RESOURCE_LOCATION = "Resource &Location";
    private static final String HELP_MESSAGE = "Only required for certain resources, e.g., JAR files.";
    private JTextField mNameField = null;
    private JTextField mLocationField = null;
    private JButton mNamesearchButton = null;
    private List mLabelsList = new ArrayList();
    private List mFieldsList = new ArrayList();
    private ResourceDetailsData mData = null;

    public ResourceDetailsPanel() {
        this.initializeComponents();
        this.layoutComponents();
    }

    private void initializeComponents() {
        this.mNameField = new JTextField();
        this.mLocationField = new JTextField();
        this.mNamesearchButton = UIHelper.createBrowseButton((String)"browse");
    }

    private void layoutComponents() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel namePanel = this.prepareNamePanel();
        JPanel locationPanel = this.prepareLocationPanel();
        JPanel helpPanel = this.prepareHelpPanel();
        this.add(namePanel);
        this.add(locationPanel);
        this.add(helpPanel);
        namePanel.setMaximumSize(new Dimension(Short.MAX_VALUE, namePanel.getPreferredSize().height));
        locationPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, locationPanel.getPreferredSize().height));
        namePanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 5, 15));
        locationPanel.setBorder(BorderFactory.createEmptyBorder(5, 15, 5, 15));
        helpPanel.setBorder(BorderFactory.createEmptyBorder(5, 15, 5, 15));
        this.equateComponentWidths(this.mLabelsList);
        this.equateComponentWidths(this.mFieldsList);
    }

    private JPanel prepareNamePanel() {
        JPanel panel = new JPanel();
        BoxLayout bl = new BoxLayout(panel, 0);
        panel.setLayout(bl);
        JLabel label = new JLabel();
        panel.add(label);
        Component glue = Box.createGlue();
        panel.add(glue);
        Component strut = Box.createHorizontalStrut(12);
        panel.add(strut);
        panel.add(this.mNameField);
        panel.add(this.mNamesearchButton);
        ResourceUtils.resLabel((JLabel)label, (Component)this.mNameField, (String)RESOURCE_NAME);
        this.mLabelsList.add(label);
        this.mFieldsList.add(this.mNameField);
        return panel;
    }

    private JPanel prepareLocationPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        JLabel label = new JLabel();
        panel.add(label);
        Component glue = Box.createGlue();
        panel.add(glue);
        Component strut = Box.createHorizontalStrut(12);
        panel.add(strut);
        panel.add(this.mLocationField);
        Box endStrut = Box.createHorizontalBox();
        Dimension d = endStrut.getPreferredSize();
        d.width = this.mNamesearchButton.getPreferredSize().width;
        endStrut.setPreferredSize(d);
        panel.add(endStrut);
        ResourceUtils.resLabel((JLabel)label, (Component)this.mLocationField, (String)RESOURCE_LOCATION);
        this.mLabelsList.add(label);
        this.mFieldsList.add(this.mLocationField);
        return panel;
    }

    private JPanel prepareHelpPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        JLabel l = new JLabel();
        panel.add(l);
        Component strut = Box.createHorizontalStrut(20);
        panel.add(strut);
        JWrappedLabel label = new JWrappedLabel(HELP_MESSAGE);
        label.setEnabled(false);
        panel.add((Component)label);
        Box endStrut = Box.createHorizontalBox();
        Dimension d = endStrut.getPreferredSize();
        d.width = this.mNamesearchButton.getPreferredSize().width;
        endStrut.setPreferredSize(d);
        panel.add(endStrut);
        this.mLabelsList.add(l);
        this.mFieldsList.add(label);
        return panel;
    }

    private void equateComponentWidths(List pListOfComponents) {
        int width = -1;
        for (JComponent c : pListOfComponents) {
            if (c.getPreferredSize().width < width) continue;
            width = c.getPreferredSize().width;
        }
        for (JComponent c : pListOfComponents) {
            Dimension d = c.getPreferredSize();
            d.width = width;
            c.setPreferredSize(d);
        }
    }

    public static void main(String[] argv) {
        JFrame frame = new JFrame();
        ResourceDetailsPanel panel = new ResourceDetailsPanel();
        frame.getContentPane().add(panel);
        frame.setSize(500, 400);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    public void setData(ResourceDetailsData pData) {
        this.mData = pData;
        this.initializeData();
    }

    private void initializeData() {
        if (this.mData.getName() != null) {
            this.mNameField.setText(this.mData.getName());
        }
        if (this.mData.getLocation() != null) {
            this.mLocationField.setText(this.mData.getLocation());
        }
    }

    public ResourceDetailsData getData() {
        if (this.mData == null) {
            this.mData = new ResourceDetailsData();
        }
        return this.mData;
    }
}

