/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.util.ResourceUtils;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.config.MessageAttribute;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.config.Payload;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.config.UserTaskConfigFactory;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.config.UserTaskConfigModel;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.iface.UserTask;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.ui.DialogOKListener;
import oracle.tip.tools.ide.common.ui.GenericDialog;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.IHelpUtil;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors.PayloadData;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors.PayloadDataTreeNode;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors.PayloadDetailsPanel;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;
import oracle.tip.tools.ide.workflow.util.WorkFlowHelpUtil;

public class PayloadTaskEditor
extends BaseEditingPage
implements TreeSelectionListener,
ActionListener {
    private JTree mTree = null;
    private JButton mEditButton = null;
    private JButton mAddButton = null;
    private JButton mDeleteButton = null;
    private JCheckBox mEnableVersionTracking = null;
    private DefaultMutableTreeNode mRootNode = null;
    private List mPayloadList = new ArrayList();
    private BPELProject mProject = null;
    private UserTaskConfigModel mTaskModel = null;
    private static final String EDIT_STRING = "Edit";
    private static final String ADD_STRING = "Add";
    private static final String DELETE_STRING = "Delete";
    private static final String ENABLE_PAYLOAD_VERSION_TRACKING = "&Enable Payload Version Tracking";

    public PayloadTaskEditor(BPELGraphPane pane) {
        super(pane);
        this.mProject = pane.getBPELProject();
        this.init();
    }

    @Override
    public String getTitle() {
        return "Payload";
    }

    private void init() {
        this.initializeComponents();
        this.layoutComponents();
        this.initializeListeners();
    }

    private void addTestData() {
        DefaultTreeModel model = new DefaultTreeModel(this.mRootNode);
        PayloadData data1 = new PayloadData(this.mProject, "Reference ID", PayloadData.PayloadDataType.ELEMENT, "{http://xmlns.oracle.com/pcbpel/taskservice/task1}task1", "/task:task/task:taskId", true);
        PayloadDataTreeNode node1 = new PayloadDataTreeNode(data1);
        this.mRootNode.add(node1);
        PayloadData data2 = new PayloadData(this.mProject, "PayloadItem1", PayloadData.PayloadDataType.SIMPLETYPE, "{http://www.w3.org/2001/XMLSchema}string", "bpws:getVariableData", false);
        PayloadDataTreeNode node2 = new PayloadDataTreeNode(data2);
        this.mRootNode.add(node2);
        this.mTree.setModel(model);
        this.mTree.setRootVisible(false);
        this.mTree.setShowsRootHandles(true);
    }

    private void initializeComponents() {
        this.mEditButton = UIHelper.createModelerButton((String)BPELStringTranslator.getString("EDIT_BUTTON_TEXT"), (Icon)ImageCache.getIcon("edit16"));
        this.mAddButton = UIHelper.createModelerButton((String)BPELStringTranslator.getString("ADD_BUTTON_TEXT"), (Icon)ImageCache.getIcon("add16"));
        this.mDeleteButton = UIHelper.createModelerButton((String)BPELStringTranslator.getString("DEL_BUTTON_TEXT"), (Icon)ImageCache.getIcon("delete16"));
        this.mTree = new JTree();
        this.mEnableVersionTracking = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.mEnableVersionTracking, (String)ENABLE_PAYLOAD_VERSION_TRACKING);
        this.mRootNode = new DefaultMutableTreeNode();
    }

    private void initializeListeners() {
        this.mTree.addTreeSelectionListener(this);
        this.enableEditButton(false);
        this.enableDeleteButton(false);
        this.mEditButton.addActionListener(this);
        this.mDeleteButton.addActionListener(this);
        this.mAddButton.addActionListener(this);
        this.mTree.setCellRenderer(new LocalTreeCellRenderer());
    }

    private void layoutComponents() {
        BorderLayout bl = new BorderLayout();
        this.setLayout(bl);
        JPanel toolBar = this.createToolBar();
        this.add((Component)toolBar, "North");
        JScrollPane pane = new JScrollPane(this.mTree);
        this.add((Component)pane, "Center");
        this.add((Component)this.createBottomPanel(), "South");
        Component leftStrut = Box.createHorizontalStrut(10);
        this.add(leftStrut, "West");
        Component rightStrut = Box.createHorizontalStrut(10);
        this.add(rightStrut, "East");
    }

    private JPanel createBottomPanel() {
        GridBagLayout gl = new GridBagLayout();
        JPanel panel = new JPanel(gl);
        int x = 0;
        int y = 0;
        gl.setConstraints(this.mEnableVersionTracking, new GridBagConstraints(x, y, 0, 1, 1.0, 0.0, 21, 2, new Insets(2, 8, 2, 10), 0, 0));
        panel.add(this.mEnableVersionTracking);
        return panel;
    }

    private void equateComponentWidths(List pComponentList) {
        int width = -1;
        for (JComponent c : pComponentList) {
            if (c.getPreferredSize().width <= width) continue;
            width = c.getPreferredSize().width;
        }
        for (JComponent c : pComponentList) {
            Dimension d = c.getPreferredSize();
            d.width = width;
            c.setPreferredSize(d);
        }
    }

    private JPanel createToolBar() {
        ArrayList<JButton> componentList = new ArrayList<JButton>();
        GridBagLayout gl = new GridBagLayout();
        JPanel panel = new JPanel(gl);
        Insets insets = new Insets(2, 2, 2, 2);
        int x = 0;
        int y = 0;
        Component strut = Box.createHorizontalStrut(100);
        gl.setConstraints(strut, new GridBagConstraints(x, y, -1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        panel.add(strut);
        ++x;
        GridLayout g = new GridLayout(1, 3);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.mEditButton);
        buttonPanel.add(this.mAddButton);
        buttonPanel.add(this.mDeleteButton);
        componentList.add(this.mEditButton);
        componentList.add(this.mAddButton);
        componentList.add(this.mDeleteButton);
        gl.setConstraints(buttonPanel, new GridBagConstraints(x, y, 0, 1, 0.0, 0.0, 21, 0, new Insets(2, 2, 2, 8), 0, 0));
        panel.add(buttonPanel);
        this.equateComponentWidths(componentList);
        return panel;
    }

    private TreeNode getTopLevelPayloadNode(TreeNode node) {
        if (node == null) {
            return node;
        }
        if (node instanceof PayloadDataTreeNode) {
            return node;
        }
        return this.getTopLevelPayloadNode(node.getParent());
    }

    private PayloadData getCurrentPayloadData(TreeNode node) {
        PayloadData data = null;
        if (node == null) {
            return data;
        }
        node = this.getTopLevelPayloadNode(node);
        data = (PayloadData)((DefaultMutableTreeNode)node).getUserObject();
        return data;
    }

    @Override
    public void valueChanged(TreeSelectionEvent pEvent) {
        if (pEvent.isAddedPath()) {
            if (this.mTree.getSelectionCount() > 1) {
                this.enableEditButton(false);
            } else {
                this.enableEditButton(true);
            }
            this.enableDeleteButton(true);
        } else if (this.mTree.getSelectionCount() == 0) {
            this.enableDeleteButton(false);
            this.enableEditButton(false);
        } else {
            this.enableDeleteButton(true);
            this.enableEditButton(true);
        }
        if (this.mEditButton.isEnabled()) {
            // empty if block
        }
    }

    private void enableDeleteButton(boolean pValue) {
        this.mDeleteButton.setEnabled(pValue);
    }

    private void enableEditButton(boolean pValue) {
        this.mEditButton.setEnabled(pValue);
    }

    @Override
    public void actionPerformed(ActionEvent pEvent) {
        if (pEvent.getSource().equals(this.mEditButton)) {
            this.handleEdit();
        } else if (pEvent.getSource().equals(this.mDeleteButton)) {
            this.handleDelete();
        } else if (pEvent.getSource().equals(this.mAddButton)) {
            this.handleAdd();
        }
    }

    private void handleDelete() {
        TreePath[] paths = this.mTree.getSelectionPaths();
        if (paths == null) {
            return;
        }
        for (int i = 0; i < paths.length; ++i) {
            this.delete(paths[i]);
        }
    }

    private void delete(TreePath path) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getTopLevelPayloadNode((TreeNode)path.getLastPathComponent());
        PayloadData data = (PayloadData)node.getUserObject();
        this.mPayloadList.remove(data);
        this.mRootNode.remove(node);
        this.updateTree(node);
    }

    private void handleAdd() {
        PayloadData data = new PayloadData(this.mProject);
        PayloadDetailsPanel panel = new PayloadDetailsPanel(this.mProject);
        GenericDialog gd = this.createDialog(data, panel);
        gd.addOKListener((DialogOKListener)new AddOKListener((JDialog)gd, panel));
        UIHelper.centerInScreen((Component)gd);
        gd.setHelpProvider((IHelpUtil)WorkFlowHelpUtil.getInstance());
        gd.setVisible(true);
    }

    private GenericDialog createDialog(PayloadData pData, PayloadDetailsPanel panel) {
        GenericDialog gd = new GenericDialog((Frame)UIHelper.getFrame((Component)this));
        gd.setButtons(28);
        panel.setBorder(BorderFactory.createEtchedBorder());
        panel.setData(pData);
        gd.setContent((JComponent)panel);
        gd.setSize(400, 400);
        gd.setModal(true);
        UIHelper.centerInScreen((Component)gd);
        gd.setHelpProvider((IHelpUtil)WorkFlowHelpUtil.getInstance());
        return gd;
    }

    private void handleEdit() {
        TreePath path = this.mTree.getSelectionPath();
        TreeNode node = (TreeNode)path.getLastPathComponent();
        PayloadData data = this.getCurrentPayloadData(node);
        PayloadDetailsPanel panel = new PayloadDetailsPanel(this.mProject);
        GenericDialog gd = this.createDialog(data, panel);
        gd.addOKListener((DialogOKListener)new EditOKListener(data, (JDialog)gd, panel));
        gd.setHelpProvider((IHelpUtil)WorkFlowHelpUtil.getInstance());
        gd.setVisible(true);
    }

    private void fireValueUpdated(TreePath path, PayloadData previousData, PayloadData newData) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        node = (DefaultMutableTreeNode)this.getTopLevelPayloadNode(node);
        node.setUserObject(newData);
        this.updateTree(node);
        if (node.isNodeChild((DefaultMutableTreeNode)path.getLastPathComponent())) {
            this.mTree.setSelectionPath(path);
        } else {
            int index = node.getChildCount();
            TreeNode n = node.getChildAt(index - 1);
            TreePath p = path.getParentPath().pathByAddingChild(n);
            this.mTree.setSelectionPath(p);
        }
    }

    private void updateTree(TreeNode pNode) {
        ((DefaultTreeModel)this.mTree.getModel()).nodeStructureChanged(pNode);
    }

    private void fireDataAdded(PayloadData pData) {
        PayloadDataTreeNode node = new PayloadDataTreeNode(pData);
        this.mRootNode.add(node);
        this.updateTree(this.mRootNode);
        this.mPayloadList.add(pData);
    }

    @Override
    public void setUserObject(Object pObject) {
        super.setUserObject(pObject);
        UserTask t = (UserTask)pObject;
        this.mTaskModel = t.getUserTaskConfigModel(this.m_graphModel.getBPELProject());
        this.setDataIntoUI();
    }

    private void setDataIntoUI() {
        List l = this.convertPayloadToPayloadData(this.mTaskModel.getPayload());
        this.populateTree(l);
    }

    private void populateTree(List pList) {
        DefaultTreeModel model = new DefaultTreeModel(this.mRootNode);
        for (PayloadData d : pList) {
            PayloadDataTreeNode n = new PayloadDataTreeNode(d);
            this.mRootNode.add(n);
        }
        this.mTree.setModel(model);
        this.mTree.setRootVisible(false);
        this.mTree.setShowsRootHandles(true);
    }

    private List convertPayloadToPayloadData(Payload payload) {
        ArrayList<PayloadData> l = new ArrayList<PayloadData>();
        if (payload == null) {
            return l;
        }
        List messages = payload.getMessageAttribute();
        for (MessageAttribute m : messages) {
            PayloadData d = new PayloadData(this.mProject);
            d.setName(m.getName());
            d.setNamespace(m.getNamespace());
            d.setAllowModificationsViaWorkList(m.getUpdateable());
            String type = m.getAttributeType();
            if (type.equals("COMPLEX_TYPE")) {
                d.setDataType(PayloadData.PayloadDataType.COMPLEXTYPE);
            } else if (type.equals("SIMPLE_TYPE")) {
                d.setDataType(PayloadData.PayloadDataType.SIMPLETYPE);
            } else {
                d.setDataType(PayloadData.PayloadDataType.ELEMENT);
            }
            d.setTypeData(m.getType());
            d.setAllowModificationsViaWorkList(m.getUpdateable());
            l.add(d);
        }
        return l;
    }

    @Override
    public void saveChanges() {
        List l = this.getPayloadDataFromUI();
        this.mTaskModel.setPayload(this.convertPayloadDataToPayload(l));
    }

    private Payload convertPayloadDataToPayload(List pInput) {
        ArrayList<MessageAttribute> l = new ArrayList<MessageAttribute>();
        Payload p = UserTaskConfigFactory.getInstance().createPayload();
        for (PayloadData d : pInput) {
            l.add(this.convertPayloadToMessageAttribute(d));
        }
        p.setMessageAttribute(l);
        return p;
    }

    private MessageAttribute convertPayloadToMessageAttribute(PayloadData pData) {
        MessageAttribute m = UserTaskConfigFactory.getInstance().createMessageAttribute();
        if (pData.getDataType().equals(PayloadData.PayloadDataType.COMPLEXTYPE)) {
            m.setAttributeType("COMPLEX_TYPE");
        } else if (pData.getDataType().equals(PayloadData.PayloadDataType.SIMPLETYPE)) {
            m.setAttributeType("SIMPLE_TYPE");
        } else {
            m.setAttributeType("ELEMENT");
        }
        m.setName(pData.getName());
        m.setNamespace(pData.getNamespace());
        m.setType(pData.getTypeData());
        m.setUpdateable(pData.isModificationAllowedViaWorkList());
        return m;
    }

    private List getPayloadDataFromUI() {
        ArrayList<PayloadData> l = new ArrayList<PayloadData>();
        int numberofNodes = this.mRootNode.getChildCount();
        for (int i = 0; i < numberofNodes; ++i) {
            PayloadDataTreeNode n = (PayloadDataTreeNode)this.mRootNode.getChildAt(i);
            PayloadData d = (PayloadData)n.getUserObject();
            l.add(d);
        }
        return l;
    }

    class LocalTreeCellRenderer
    extends DefaultTreeCellRenderer {
        LocalTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.handleNode(value);
            return this;
        }

        private void handleNode(Object pValue) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)pValue;
            if (PayloadDataTreeNode.isModifiableAttribute(node)) {
                this.setIcon(ImageCache.getIcon("check16"));
            } else if (node instanceof PayloadDataTreeNode.TypeTreeNode) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)node.getParent();
                PayloadData data = (PayloadData)n.getUserObject();
                if (data.getDataType().equals(PayloadData.PayloadDataType.ELEMENT)) {
                    this.setIcon(ImageCache.getIcon("element_node"));
                } else {
                    this.setIcon(ImageCache.getIcon("message_part_node"));
                }
            } else {
                this.setIcon(null);
            }
        }
    }

    class EditOKListener
    implements DialogOKListener {
        PayloadDetailsPanel mPanel = null;
        JDialog mDialog = null;
        PayloadData mCurrentPayload = null;

        public EditOKListener(PayloadData pCurrentData, JDialog pDialog, PayloadDetailsPanel panel) {
            this.mCurrentPayload = pCurrentData;
            this.mPanel = panel;
            this.mDialog = pDialog;
        }

        public void OKOccured() {
            PayloadData data = this.mPanel.getData();
            if (!this.mCurrentPayload.equals(data)) {
                PayloadTaskEditor.this.fireValueUpdated(PayloadTaskEditor.this.mTree.getSelectionPath(), this.mCurrentPayload, data);
            }
            this.mDialog.dispose();
        }
    }

    class AddOKListener
    implements DialogOKListener {
        JDialog mDialog = null;
        PayloadDetailsPanel mPanel = null;

        public AddOKListener(JDialog pDialog, PayloadDetailsPanel panel) {
            this.mDialog = pDialog;
            this.mPanel = panel;
        }

        public void OKOccured() {
            PayloadTaskEditor.this.fireDataAdded(this.mPanel.getData());
            this.mDialog.dispose();
        }
    }
}

