/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import oracle.ide.util.ResourceUtils;
import oracle.tip.tools.ide.common.datasources.CompoundDataSource;
import oracle.tip.tools.ide.common.datasources.schema.ProjectSchemaDataSource;
import oracle.tip.tools.ide.common.datasources.schema.SchemaDataSource;
import oracle.tip.tools.ide.common.datasources.schema.SchemaTypesDataSource;
import oracle.tip.tools.ide.common.ide.IDEProject;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.resource.MessageBundleUtil;
import oracle.tip.tools.ide.common.typeexplorer.DefaultSchemaImportHandler;
import oracle.tip.tools.ide.common.typeexplorer.SchemaImportHandler;
import oracle.tip.tools.ide.common.typeexplorer.TypeChooser;
import oracle.tip.tools.ide.common.typeexplorer.TypeExplorer;
import oracle.tip.tools.ide.common.typeexplorer.TypeExplorerTreeNode;
import oracle.tip.tools.ide.common.typeexplorer.TypeObject;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.ValidatableTextField;
import oracle.tip.tools.ide.common.ui.treeexplorer.NodeText;
import oracle.tip.tools.ide.common.ui.treeexplorer.TextInfo;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorerCellRenderer;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorerDataSource;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorerTreeNode;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors.ImportHandler;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors.PayloadData;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class PayloadDetailsPanel
extends JPanel
implements ImportHandler {
    private PayloadData mData = null;
    private static final String NAME = "&Name: ";
    private static final String VALUE = "&Value: ";
    private static final String TYPE = "&Type: ";
    private static final String ELEMENT = "&Element: ";
    private static final String ALLOW_PARTICIPANTS = "&Allow Participants to Modify Via Worklist";
    private JRadioButton mTypeButton = null;
    private JRadioButton mElementButton = null;
    private ValidatableTextField mNameField = null;
    private ValidatableTextField mTypeField = null;
    private ValidatableTextField mElementField = null;
    private JTextField mValueField = null;
    private JCheckBox mModifyCheckBox = null;
    private JButton mTypeBrowseButton = null;
    private JButton mElementTypeBrowseButton = null;
    private URL mFileURL = null;
    private PayloadData.PayloadDataType mPayLoadType = null;
    private String mNamespace = null;
    private String mLocalPart = null;
    private List mInnerLabelList = new ArrayList();
    private List mOuterLabelList = new ArrayList();
    private List mIconList = new ArrayList();
    private BPELProject mProject = null;

    public void setData(PayloadData pData) {
        this.mData = new PayloadData(pData);
        this.populateData();
    }

    private void populateData() {
        this.mNameField.setText(this.mData.getName());
        this.mValueField.setText(this.mData.getValue());
        PayloadData.PayloadDataType d = this.mData.getDataType();
        String namespace = this.mData.getNamespace();
        String typeData = this.mData.getTypeData();
        String formattedString = "";
        if (namespace != null && typeData != null) {
            formattedString = "{" + namespace + "}" + typeData;
        }
        if (d.equals(PayloadData.PayloadDataType.ELEMENT)) {
            this.mElementButton.setSelected(true);
            this.mElementField.setText(formattedString);
        } else {
            this.mTypeButton.setSelected(true);
            this.mTypeField.setText(formattedString);
        }
        this.mModifyCheckBox.setSelected(this.mData.isModificationAllowedViaWorkList());
        this.mFileURL = this.mData.getFileURL();
        this.mPayLoadType = d;
        this.setNamespace(this.mData.getNamespace());
        this.setLocalPart(this.mData.getTypeData());
    }

    public PayloadData getData() {
        this.mData.setAllowModificationsViaWorkList(this.mModifyCheckBox.isSelected());
        this.mData.setName(this.mNameField.getText());
        this.mData.setValue(this.mValueField.getText());
        this.mData.setDataType(this.mPayLoadType);
        this.mData.setTypeData(this.mLocalPart);
        this.mData.setNamespace(this.mNamespace);
        this.mData.setFileURL(this.mFileURL);
        return this.mData;
    }

    public PayloadDetailsPanel(BPELProject project) {
        this.mProject = project;
        this.initializeComponents();
        this.layoutComponents();
        this.addListeners();
    }

    private void addListeners() {
        this.mTypeField.getTextField().getDocument().addDocumentListener(new RadioButtonTextFieldKeyListener(this.mTypeButton));
        this.mElementField.getTextField().getDocument().addDocumentListener(new RadioButtonTextFieldKeyListener(this.mElementButton));
        this.mTypeBrowseButton.addActionListener(new TypeButtonListener(this, this.mTypeField.getTextField(), this.mProject));
        this.mElementTypeBrowseButton.addActionListener(new ElementTypeButtonListener(this, this.mElementField.getTextField(), this.mProject));
    }

    @Override
    public void setFileURL(URL pURL) {
        this.mFileURL = pURL;
    }

    @Override
    public URL getFileURL() {
        return this.mFileURL;
    }

    @Override
    public void setDataType(int pInt) {
        if (pInt == 300) {
            this.mPayLoadType = PayloadData.PayloadDataType.COMPLEXTYPE;
        } else if (pInt == 200) {
            this.mPayLoadType = PayloadData.PayloadDataType.SIMPLETYPE;
        } else if (pInt == 100) {
            this.mPayLoadType = PayloadData.PayloadDataType.ELEMENT;
        }
    }

    @Override
    public void setNamespace(String pNamespace) {
        this.mNamespace = pNamespace;
    }

    @Override
    public String getNamespace() {
        return this.mNamespace;
    }

    @Override
    public void setLocalPart(String part) {
        this.mLocalPart = part;
    }

    private void initializeComponents() {
        this.mNameField = new ValidatableTextField();
        this.mTypeField = new ValidatableTextField();
        this.mElementField = new ValidatableTextField();
        this.mValueField = new JTextField();
        this.mModifyCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.mModifyCheckBox, (String)ALLOW_PARTICIPANTS);
        ButtonGroup group = new ButtonGroup();
        this.mTypeButton = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this.mTypeButton, (String)TYPE);
        this.mElementButton = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this.mElementButton, (String)ELEMENT);
        group.add(this.mTypeButton);
        group.add(this.mElementButton);
        this.mTypeBrowseButton = UIHelper.createBrowseButton((String)"browse for simple types");
        this.mElementTypeBrowseButton = UIHelper.createBrowseButton((String)"browse for complex types");
    }

    private void layoutComponents() {
        this.mInnerLabelList.clear();
        this.mOuterLabelList.clear();
        this.mIconList.clear();
        GridBagLayout gl = new GridBagLayout();
        this.setLayout(gl);
        int x = 0;
        int y = 0;
        Insets insets = new Insets(2, 10, 2, 10);
        Component topStrut = Box.createVerticalStrut(15);
        gl.setConstraints(topStrut, new GridBagConstraints(x, y, 0, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        this.add(topStrut);
        JPanel namePanel = this.createNamePanel();
        gl.setConstraints(namePanel, new GridBagConstraints(x, ++y, 0, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        this.add(namePanel);
        JPanel typePanel = this.createTypePanel();
        gl.setConstraints(typePanel, new GridBagConstraints(x, ++y, 0, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        this.add(typePanel);
        JPanel elementPanel = this.createElementPanel();
        gl.setConstraints(elementPanel, new GridBagConstraints(x, ++y, 0, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        this.add(elementPanel);
        JPanel valuePanel = this.createValuePanel();
        gl.setConstraints(valuePanel, new GridBagConstraints(x, ++y, 0, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        this.add(valuePanel);
        JPanel modificationsPanel = this.createAllowModificationsPanel();
        gl.setConstraints(modificationsPanel, new GridBagConstraints(x, ++y, 0, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        this.add(modificationsPanel);
        Box box = Box.createVerticalBox();
        gl.setConstraints(box, new GridBagConstraints(x, ++y, 0, 0, 1.0, 1.0, 21, 1, insets, 0, 0));
        this.add(box);
        this.equateWidths(this.mOuterLabelList);
        this.equateWidths(this.mInnerLabelList);
        this.equateWidths(this.mIconList);
    }

    private JPanel createNamePanel() {
        GridBagLayout gl = new GridBagLayout();
        JPanel panel = new JPanel(gl);
        int x = 0;
        int y = 0;
        Insets insets = new Insets(2, 2, 2, 5);
        JLabel label = new JLabel();
        gl.setConstraints(label, new GridBagConstraints(x, y, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        panel.add(label);
        ResourceUtils.resLabel((JLabel)label, (Component)this.mNameField, (String)NAME);
        gl.setConstraints((Component)this.mNameField, new GridBagConstraints(++x, y, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        panel.add((Component)this.mNameField);
        Component strut = Box.createHorizontalStrut(20);
        gl.setConstraints(strut, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        panel.add(strut);
        this.mOuterLabelList.add(label);
        return panel;
    }

    private JPanel createTypePanel() {
        GridBagLayout gl = new GridBagLayout();
        JPanel panel = new JPanel(gl);
        Insets insets = new Insets(2, 2, 2, 2);
        int x = 0;
        int y = 0;
        JLabel picLabel = new JLabel(ImageCache.getIcon("message_part_node"));
        gl.setConstraints(picLabel, new GridBagConstraints(x, y, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        panel.add(picLabel);
        this.mIconList.add(picLabel);
        Component s1 = Box.createHorizontalStrut(10);
        gl.setConstraints(s1, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        panel.add(s1);
        gl.setConstraints(this.mTypeButton, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        panel.add(this.mTypeButton);
        gl.setConstraints((Component)this.mTypeField, new GridBagConstraints(++x, y, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        panel.add((Component)this.mTypeField);
        gl.setConstraints(this.mTypeBrowseButton, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        panel.add(this.mTypeBrowseButton);
        this.mInnerLabelList.add(this.mTypeButton);
        return panel;
    }

    private JPanel createElementPanel() {
        GridBagLayout gl = new GridBagLayout();
        JPanel panel = new JPanel(gl);
        Insets insets = new Insets(2, 2, 2, 2);
        int x = 0;
        int y = 0;
        JLabel picLabel = new JLabel(ImageCache.getIcon("element_node"));
        gl.setConstraints(picLabel, new GridBagConstraints(x, y, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        panel.add(picLabel);
        this.mIconList.add(picLabel);
        Component s1 = Box.createHorizontalStrut(10);
        gl.setConstraints(s1, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        panel.add(s1);
        gl.setConstraints(this.mElementButton, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        panel.add(this.mElementButton);
        gl.setConstraints((Component)this.mElementField, new GridBagConstraints(++x, y, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        panel.add((Component)this.mElementField);
        gl.setConstraints(this.mElementTypeBrowseButton, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        panel.add(this.mElementTypeBrowseButton);
        this.mInnerLabelList.add(this.mElementButton);
        return panel;
    }

    private JPanel createValuePanel() {
        GridBagLayout gl = new GridBagLayout();
        JPanel panel = new JPanel(gl);
        int x = 0;
        int y = 0;
        Insets insets = new Insets(2, 2, 2, 2);
        JLabel label = new JLabel();
        ResourceUtils.resLabel((JLabel)label, (Component)this.mValueField, (String)VALUE);
        gl.setConstraints(label, new GridBagConstraints(x, y, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        panel.add(label);
        gl.setConstraints(this.mValueField, new GridBagConstraints(++x, y, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        panel.add(this.mValueField);
        JButton browseButton = UIHelper.createBrowseButton((String)"browse");
        gl.setConstraints(browseButton, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        panel.add(browseButton);
        this.mOuterLabelList.add(label);
        return panel;
    }

    private JPanel createAllowModificationsPanel() {
        GridBagLayout gl = new GridBagLayout();
        JPanel panel = new JPanel(gl);
        int x = 0;
        int y = 0;
        Insets insets = new Insets(2, 2, 2, 2);
        Component strut = Box.createHorizontalGlue();
        gl.setConstraints(strut, new GridBagConstraints(x, y, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        panel.add(strut);
        gl.setConstraints(this.mModifyCheckBox, new GridBagConstraints(++x, y, 1, 1, 1.0, 0.0, 21, 0, insets, 0, 0));
        panel.add(this.mModifyCheckBox);
        this.mOuterLabelList.add(strut);
        return panel;
    }

    private void equateWidths(List pList) {
        Dimension d;
        int width = -1;
        for (JComponent c : pList) {
            d = c.getPreferredSize();
            if (width >= d.width) continue;
            width = d.width;
        }
        for (JComponent c : pList) {
            d = c.getPreferredSize();
            d.width = width;
            c.setPreferredSize(d);
        }
    }

    class ImportedSchemasDataSource
    implements TreeExplorerDataSource {
        protected Icon FOLDER_ICON = TreeExplorerCellRenderer.DEFAULT_ICON;
        TypeExplorerTreeNode m_root;
        SchemaDataSource m_ds;
        TypeExplorer m_explorer;

        public ImportedSchemasDataSource(TypeExplorer explorer, SchemaDataSource ds) {
            this.m_explorer = explorer;
            this.m_ds = ds;
        }

        public TreeExplorerTreeNode[] getRoots() {
            TextInfo t1 = new TextInfo();
            t1.setText(MessageBundleUtil.getCommonString((String)"TE_IMPORT_SCHEMAS", (String)"Imported Schemas"));
            t1.setFont(TextInfo.PLAIN_FONT);
            t1.setColor(Color.black);
            NodeText nodeTxt = new NodeText(new TextInfo[]{t1}, new TextInfo[]{t1});
            this.m_root = new TypeExplorerTreeNode(new Icon[]{this.FOLDER_ICON}, nodeTxt, (Object)"", null);
            TreeExplorerTreeNode[] roots = this.m_ds.getRoots();
            for (int i = 0; i < roots.length; ++i) {
                TreeExplorerTreeNode root = roots[i];
                this.m_root.add((MutableTreeNode)root);
            }
            return new TreeExplorerTreeNode[]{this.m_root};
        }

        public void addDataSource(SchemaDataSource ds) {
            DefaultTreeModel model = (DefaultTreeModel)this.m_explorer.getTree().getModel();
            TreeExplorerTreeNode[] roots = ds.getRoots();
            for (int i = 0; i < roots.length; ++i) {
                TreeExplorerTreeNode root = roots[i];
                model.insertNodeInto((MutableTreeNode)root, (MutableTreeNode)this.m_root, this.m_root.getChildCount());
            }
        }
    }

    class XSDFileFilter
    implements FileFilter {
        XSDFileFilter() {
        }

        @Override
        public boolean accept(File pFile) {
            return pFile.getName().endsWith(".xsd") && !pFile.getName().equals("WorkflowTask.xsd");
        }
    }

    class XSDFileChooserFilter
    extends javax.swing.filechooser.FileFilter {
        XSDFileChooserFilter() {
        }

        @Override
        public boolean accept(File pFile) {
            if (pFile != null) {
                return pFile.getName().endsWith(".xsd");
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "XML Schema Files  - *.xsd";
        }
    }

    class ElementTypeButtonListener
    implements ActionListener {
        JTextField mField = null;
        BPELProject mProject = null;
        private URL mLastURL = null;
        private FileFilter mXSDFilter = new XSDFileFilter();
        private javax.swing.filechooser.FileFilter mUIFileFilter = new XSDFileChooserFilter();
        private ImportHandler mHandler = null;

        public ElementTypeButtonListener(ImportHandler pHandler, JTextField pField, BPELProject project) {
            this.mField = pField;
            this.mProject = project;
            this.mHandler = pHandler;
        }

        @Override
        public void actionPerformed(ActionEvent pEvent) {
            TypeChooser chooser = new TypeChooser(UIHelper.getFrame((Component)this.mField));
            TypeExplorer explorer = chooser.getTypeExplorer();
            explorer.setSchemaImportHandler((oracle.tip.tools.ide.common.typeexplorer.SchemaImportHandler)new SchemaImportHandler());
            URL url = this.handleBrowse();
            SchemaDataSource ds2 = explorer.getSchemaImportHandler().getSchemaDataSource(url);
            ImportedSchemasDataSource ds = new ImportedSchemasDataSource(explorer, ds2);
            CompoundDataSource inputElementDS = new CompoundDataSource();
            inputElementDS.addDataSource((TreeExplorerDataSource)ds);
            if (chooser.display((TreeExplorerDataSource)inputElementDS) == 0) {
                TypeObject to = chooser.getTypeObject();
                this.mField.setText(to.getQName().toString());
                if (this.mHandler != null) {
                    this.mHandler.setFileURL(chooser.getTypeExplorer().getURLForSelectedNode());
                    this.mHandler.setDataType(100);
                    this.mHandler.setNamespace(to.getQName().getNamespaceURI());
                    this.mHandler.setLocalPart(to.getQName().getLocalPart());
                }
            }
        }

        private URL loadFile() {
            return null;
        }

        private URL handleBrowse() {
            if (this.mLastURL != null) {
                return this.mLastURL;
            }
            this.mLastURL = this.mProject.getBPELDirectoryURL();
            File f = new File(this.mLastURL.getFile());
            File[] files = f.listFiles(this.mXSDFilter);
            if (files != null && files.length > 0) {
                try {
                    this.mLastURL = files[0].toURL();
                }
                catch (MalformedURLException e) {}
            } else {
                JFileChooser fc = new JFileChooser(this.mProject.getBPELDirectoryURL().getFile());
                fc.setFileFilter(this.mUIFileFilter);
                fc.showOpenDialog(UIHelper.getFrame((Component)this.mField));
                File fsel = fc.getSelectedFile();
                if (fsel != null) {
                    File newFile = new File(this.mProject.getBPELDirectoryURL().getFile(), fsel.getName());
                    try {
                        if (newFile.createNewFile()) {
                            this.copy(fsel, newFile);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        this.mLastURL = fsel.toURL();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            return this.mLastURL;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void copy(File pSource, File pDestination) throws Exception {
            FileChannel in = null;
            AbstractInterruptibleChannel out = null;
            try {
                in = new FileInputStream(pSource).getChannel();
                out = new FileOutputStream(pDestination).getChannel();
                in.transferTo(0L, in.size(), (WritableByteChannel)((Object)out));
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {}
                }
            }
        }

        class SchemaImportHandler
        extends DefaultSchemaImportHandler {
            public SchemaImportHandler() {
                super((IDEProject)ElementTypeButtonListener.this.mProject);
            }

            public SchemaDataSource getSchemaDataSource(URL url) {
                return new SchemaDataSource(url, false, true, 6);
            }
        }
    }

    class TypeButtonListener
    implements ActionListener {
        JTextField mField = null;
        BPELProject mProject = null;
        ImportHandler mHandler = null;

        public TypeButtonListener(ImportHandler pHandler, JTextField pField, BPELProject project) {
            this.mField = pField;
            this.mProject = project;
            this.mHandler = pHandler;
        }

        @Override
        public void actionPerformed(ActionEvent pEvent) {
            TypeChooser chooser = new TypeChooser(UIHelper.getFrame((Component)this.mField));
            TypeExplorer explorer = chooser.getTypeExplorer();
            explorer.setSchemaImportHandler((oracle.tip.tools.ide.common.typeexplorer.SchemaImportHandler)new SchemaImportHandler());
            URL url = this.handleBrowse();
            ProjectSchemaDataSource ds = new ProjectSchemaDataSource((IDEProject)this.mProject, true, false);
            CompoundDataSource inputElementDS = new CompoundDataSource();
            SchemaTypesDataSource stds = new SchemaTypesDataSource();
            inputElementDS.addDataSource((TreeExplorerDataSource)stds);
            inputElementDS.addDataSource((TreeExplorerDataSource)ds);
            if (chooser.display((TreeExplorerDataSource)inputElementDS) == 0) {
                TypeObject to = chooser.getTypeObject();
                this.mField.setText(to.getQName().toString());
                URL fileURL = chooser.getTypeExplorer().getURLForSelectedNode();
                if (this.mHandler != null) {
                    this.mHandler.setFileURL(fileURL);
                    if (fileURL != null) {
                        this.mHandler.setDataType(300);
                    } else {
                        this.mHandler.setDataType(200);
                    }
                    this.mHandler.setNamespace(to.getQName().getNamespaceURI());
                    this.mHandler.setLocalPart(to.getQName().getLocalPart());
                }
            }
        }

        private URL handleBrowse() {
            return this.mProject.getBPELDirectoryURL();
        }

        class SchemaImportHandler
        extends DefaultSchemaImportHandler {
            public SchemaImportHandler() {
                super((IDEProject)TypeButtonListener.this.mProject);
            }

            public SchemaDataSource getSchemaDataSource(URL url) {
                return new SchemaDataSource(url, true, false, 6);
            }
        }
    }

    class RadioButtonTextFieldKeyListener
    implements DocumentListener {
        private JRadioButton mButton;

        public RadioButtonTextFieldKeyListener(JRadioButton pButton) {
            this.mButton = pButton;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.handleEvent(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
        }

        private void handleEvent(DocumentEvent e) {
            this.mButton.setSelected(true);
        }
    }
}

