/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors;

import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors.PayloadData;

public class PayloadDataTreeNode
extends DefaultMutableTreeNode {
    MutableTreeNode valueNode = null;
    MutableTreeNode typeNode = null;
    MutableTreeNode allowedNode = null;

    public PayloadDataTreeNode(PayloadData pData) {
        super(pData, true);
        this.setUserObject(pData);
    }

    @Override
    public void setUserObject(Object pData) {
        super.setUserObject(pData);
        this.updateNodes((PayloadData)pData);
    }

    private void updateNodes(PayloadData pData) {
        if (this.valueNode == null || this.typeNode == null || this.allowedNode == null) {
            this.createNodes();
            return;
        }
        this.valueNode.setUserObject(pData.getValue());
        this.typeNode.setUserObject(new DataTypeObject(pData));
        if (pData.isModificationAllowedViaWorkList()) {
            this.add(this.allowedNode);
        } else if (this.isNodeChild(this.allowedNode)) {
            this.remove(this.allowedNode);
        }
    }

    private void createNodes() {
        PayloadData data = (PayloadData)this.getUserObject();
        this.valueNode = new DefaultMutableTreeNode(data.getValue(), false);
        this.add(this.valueNode);
        this.typeNode = new TypeTreeNode(new DataTypeObject(data));
        this.add(this.typeNode);
        this.allowedNode = new ModifiableTreeNode("Modiable via worklist");
        if (data.isModificationAllowedViaWorkList()) {
            this.add(this.allowedNode);
        }
    }

    public static boolean isModifiableAttribute(TreeNode pNode) {
        return pNode instanceof ModifiableTreeNode;
    }

    @Override
    public String toString() {
        PayloadData data = (PayloadData)this.getUserObject();
        return data.getName();
    }

    class DataTypeObject {
        private PayloadData mData = null;

        public DataTypeObject(PayloadData pData) {
            this.mData = pData;
        }

        public String toString() {
            String name = "";
            if (this.mData.getDataType().equals(PayloadData.PayloadDataType.ELEMENT)) {
                name = "Element - ";
            }
            name = name + this.mData.getTypeData();
            return name;
        }
    }

    public static class TypeTreeNode
    extends DefaultMutableTreeNode {
        public TypeTreeNode(Object pObject) {
            super(pObject, false);
        }
    }

    static class ModifiableTreeNode
    extends DefaultMutableTreeNode {
        public ModifiableTreeNode(Object pData) {
            super(pData, false);
        }
    }
}

