/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors;

import java.net.URL;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;

public class PayloadData {
    private String mName = null;
    private PayloadDataType mType = PayloadDataType.ELEMENT;
    private String mValue = null;
    private boolean mAllowModificationsViaWorklist = false;
    private String mTypeData = null;
    private BPELProject project = null;
    private URL mFileURL = null;
    private String mNamespace = null;

    public PayloadData(BPELProject project, String pName, PayloadDataType pType, String pTypeData, String pValue, boolean pAllowModificationsViaWorkList) {
        this.project = project;
        this.mName = pName;
        this.mValue = pValue;
        this.mTypeData = pTypeData;
        this.mType = pType;
        this.mAllowModificationsViaWorklist = pAllowModificationsViaWorkList;
    }

    private PayloadData() {
        this.mType = PayloadDataType.ELEMENT;
    }

    public PayloadData(BPELProject project) {
        this();
        this.project = project;
    }

    public void setName(String pName) {
        this.mName = pName;
    }

    public String getName() {
        return this.mName;
    }

    public void setValue(String pValue) {
        this.mValue = pValue;
    }

    public String getValue() {
        return this.mValue;
    }

    public void setDataType(PayloadDataType pType) {
        if (pType == null) {
            throw new IllegalArgumentException("Data type must be one of the enumerated types");
        }
        this.mType = pType;
    }

    public PayloadDataType getDataType() {
        return this.mType;
    }

    public void setTypeData(String pTypeData) {
        this.mTypeData = pTypeData;
    }

    public String getTypeData() {
        return this.mTypeData;
    }

    public void setAllowModificationsViaWorkList(boolean pShouldAllow) {
        this.mAllowModificationsViaWorklist = pShouldAllow;
    }

    public boolean isModificationAllowedViaWorkList() {
        return this.mAllowModificationsViaWorklist;
    }

    private boolean testEquality(Object a, Object b) {
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public boolean equals(Object pObject) {
        if (pObject instanceof PayloadData) {
            PayloadData d = (PayloadData)pObject;
            return d.mAllowModificationsViaWorklist == this.mAllowModificationsViaWorklist && this.testEquality(d.mName, this.mName) && this.testEquality(d.mType, this.mType) && this.testEquality(d.mTypeData, this.mTypeData) && this.testEquality(d.mValue, this.mValue) && this.testEquality(d.project, this.project) && this.testEquality(d.mFileURL, this.mFileURL) && this.testEquality(d.mNamespace, this.mNamespace);
        }
        return false;
    }

    public void setProject(BPELProject project) {
        this.project = project;
    }

    public BPELProject getProject() {
        return this.project;
    }

    public void setFileURL(URL pFileURL) {
        this.mFileURL = pFileURL;
    }

    public URL getFileURL() {
        return this.mFileURL;
    }

    public PayloadData(PayloadData pTemplate) {
        this.mName = pTemplate.mName;
        this.mAllowModificationsViaWorklist = pTemplate.mAllowModificationsViaWorklist;
        this.mType = pTemplate.mType;
        this.mTypeData = pTemplate.mTypeData;
        this.mValue = pTemplate.mValue;
        this.project = pTemplate.project;
        this.mFileURL = pTemplate.mFileURL;
        this.mNamespace = pTemplate.mNamespace;
    }

    public void setNamespace(String pNamespace) {
        this.mNamespace = pNamespace;
    }

    public String getNamespace() {
        return this.mNamespace;
    }

    static class PayloadDataType {
        private final int mType;
        public static final PayloadDataType SIMPLETYPE = new PayloadDataType(100);
        public static final PayloadDataType ELEMENT = new PayloadDataType(200);
        public static final PayloadDataType COMPLEXTYPE = new PayloadDataType(300);

        private PayloadDataType(int pType) {
            this.mType = pType;
        }

        public boolean equals(Object pObject) {
            if (pObject instanceof PayloadDataType) {
                return ((PayloadDataType)pObject).mType == this.mType;
            }
            return false;
        }
    }
}

