/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.util.ResourceUtils;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.routingslip.participants.Participant;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.modules.help.HelpSystem;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors.WFDurationPanel;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors.XPathEditorPanel;
import oracle.tip.tools.ide.pm.modules.workflow.resource.WorkflowResourceUtil;

public class ParticipantSimpleEditPageAdv
extends BaseEditingPage {
    protected Participant m_participant;
    private WFDurationPanel m_durationPanel;
    private XPathEditorPanel m_conditionExpressionPanel;
    private JLabel m_durationLabel;

    public ParticipantSimpleEditPageAdv(BPELGraphPane pane) {
        super(pane);
        this.createControls();
        this.layoutControls();
    }

    protected void createControls() {
        this.m_durationLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this.m_durationLabel, null, (String)WorkflowResourceUtil.getString("PARTICIPANT_TIME_LIMIT"));
        this.m_durationPanel = new WFDurationPanel("", "PARTICIPANT_TIME_LIMIT_EXPLAIN");
        this.m_conditionExpressionPanel = new XPathEditorPanel(this.m_graphPane, "OVERRIDE_CONDITION", "OVERRIDE_CONDITIONS_EXPLAIN");
    }

    protected void layoutControls() {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)this, (Component)this.m_durationLabel, (int)0, (int)row++, (int)0, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_durationPanel, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_conditionExpressionPanel, (int)0, (int)row++, (int)0, (int)0, (int)18, (int)2, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    @Override
    public void setUserObject(Object model) {
        this.m_participant = (Participant)model;
        this.loadControls();
    }

    protected void loadControls() {
        this.m_durationPanel.loadControls();
        String condition = this.m_participant.getCondition();
        this.m_conditionExpressionPanel.loadControls(condition);
        String duration = this.m_participant.getExpirationDuration();
        if (duration != null && !duration.trim().equals("")) {
            this.m_durationPanel.setDuration(duration);
        }
    }

    @Override
    public boolean validateEditorChanges() {
        return true;
    }

    @Override
    public void saveChanges() {
        String duration = this.m_durationPanel.getDuration();
        String expression = this.m_conditionExpressionPanel.getExpression();
        this.m_participant.setExpirationDuration(duration);
        this.m_participant.setCondition(expression);
    }

    @Override
    public String getTitle() {
        return WorkflowResourceUtil.getString("ADVANCED");
    }

    protected String getHelpTopicId() {
        String _name = "ParticipantSimple";
        return HelpSystem.getHelpTopicId(this.getClass().getName() + "." + _name);
    }
}

