/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.routingslip.participants.Participant;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.routingslip.participants.impl.ResourceImpl;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.TextFieldListener;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.modules.help.HelpSystem;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors.IdentityEditorPanel;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors.XPathEditorPanel;
import oracle.tip.tools.ide.pm.modules.workflow.resource.WorkflowResourceUtil;

public class ParticipantSimpleEditPage
extends BaseEditingPage {
    protected Participant m_participant;
    private JPanel m_GeneralPanel;
    private JTextField m_name;
    private JPanel m_IdentityPanel;
    private JLabel m_identityExplain;
    private IdentityEditorPanel m_UserIdentityPanel;
    private XPathEditorPanel m_UserIdentityExpressionPanel;
    private IdentityEditorPanel m_GroupIdentityPanel;
    private XPathEditorPanel m_GroupIdentityExpressionPanel;
    private TitledBorder m_ApproverIdBorder;

    public ParticipantSimpleEditPage(BPELGraphPane pane) {
        super(pane);
        this.createControls();
        this.layoutControls();
    }

    protected void createControls() {
        this.m_GeneralPanel = new JPanel();
        this.m_name = new JTextField();
        this.m_name.getDocument().addDocumentListener(new TextFieldListener(this));
        this.m_ApproverIdBorder = new TitledBorder(" " + WorkflowResourceUtil.getString("IDENTITY") + " ");
        this.m_identityExplain = new JLabel(WorkflowResourceUtil.getString("IDENTITY_EXPLAIN"));
        this.m_IdentityPanel = new JPanel(new GridBagLayout());
        this.m_UserIdentityPanel = new IdentityEditorPanel(this.m_graphPane, "USER", "", true);
        this.m_UserIdentityExpressionPanel = new XPathEditorPanel(this.m_graphPane, "USER_XPATH", "");
        this.m_GroupIdentityPanel = new IdentityEditorPanel(this.m_graphPane, "GROUP", "", false);
        this.m_GroupIdentityExpressionPanel = new XPathEditorPanel(this.m_graphPane, "GROUP_XPATH", "");
    }

    protected void layoutControls() {
        this.setLayout(new GridBagLayout());
        this.setSize(400, 480);
        int row = 0;
        JLabel lblName = new JLabel(WorkflowResourceUtil.getString("NAME"));
        this.m_GeneralPanel.setLayout(new GridBagLayout());
        JPanel namePanel = new JPanel(new GridBagLayout());
        int genRow = 0;
        GraphUtils.addComponent((Container)namePanel, (Component)lblName, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)namePanel, (Component)this.m_name, (int)1, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.5, (double)0.0);
        GraphUtils.addComponent((Container)this.m_GeneralPanel, (Component)namePanel, (int)0, (int)genRow++, (int)1, (int)1, (int)18, (int)1, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_GeneralPanel, (int)0, (int)row++, (int)1, (int)1, (int)18, (int)1, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        this.m_IdentityPanel.setLayout(new GridBagLayout());
        this.m_IdentityPanel.setBorder(this.m_ApproverIdBorder);
        int idRow = 0;
        GraphUtils.addComponent((Container)this.m_IdentityPanel, (Component)this.m_identityExplain, (int)0, (int)idRow++, (int)1, (int)1, (int)18, (int)1, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)this.m_IdentityPanel, (Component)this.m_UserIdentityPanel, (int)0, (int)idRow++, (int)1, (int)1, (int)18, (int)1, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)this.m_IdentityPanel, (Component)this.m_UserIdentityExpressionPanel, (int)0, (int)idRow++, (int)1, (int)1, (int)18, (int)1, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)this.m_IdentityPanel, (Component)this.m_GroupIdentityPanel, (int)0, (int)idRow++, (int)1, (int)1, (int)18, (int)1, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)this.m_IdentityPanel, (Component)this.m_GroupIdentityExpressionPanel, (int)0, (int)idRow++, (int)1, (int)1, (int)18, (int)1, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_IdentityPanel, (int)0, (int)row++, (int)1, (int)1, (int)18, (int)1, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    @Override
    public void setUserObject(Object model) {
        super.setUserObject(model);
        this.m_participant = (Participant)model;
        this.loadControls();
    }

    protected void loadControls() {
        this.m_name.setText(this.m_participant.getName());
        String user = "";
        String group = "";
        String userXpath = "";
        String groupXpath = "";
        for (ResourceImpl res : this.m_participant.getResource()) {
            if (!res.isIsGroup() && res.getType().equals("STATIC")) {
                user = res.getValue();
                continue;
            }
            if (res.isIsGroup() && res.getType().equals("STATIC")) {
                group = res.getValue();
                continue;
            }
            if (!res.isIsGroup() && res.getType().equals("XPATH")) {
                userXpath = res.getValue();
                continue;
            }
            if (!res.isIsGroup() || !res.getType().equals("XPATH")) continue;
            groupXpath = res.getValue();
        }
        this.m_UserIdentityPanel.loadControls(user);
        this.m_UserIdentityExpressionPanel.loadControls(userXpath);
        this.m_GroupIdentityPanel.loadControls(group);
        this.m_GroupIdentityExpressionPanel.loadControls(groupXpath);
    }

    @Override
    public boolean validateEditorChanges() {
        return true;
    }

    @Override
    public void saveChanges() {
        String name = this.m_name.getText();
        String users = this.m_UserIdentityPanel.getIdentity();
        String usersExp = this.m_UserIdentityExpressionPanel.getExpression();
        String groups = this.m_GroupIdentityPanel.getIdentity();
        String groupsExp = this.m_GroupIdentityExpressionPanel.getExpression();
        this.m_participant.setName(name);
        ArrayList<ResourceImpl> resList = new ArrayList<ResourceImpl>();
        if (users != null && !users.trim().equals("")) {
            ResourceImpl resUser = new ResourceImpl();
            resUser.setIsGroup(false);
            resUser.setValue(users);
            resUser.setType("STATIC");
            resList.add(resUser);
        }
        if (groups != null && !groups.equals("")) {
            ResourceImpl resGroup = new ResourceImpl();
            resGroup.setIsGroup(true);
            resGroup.setValue(groups);
            resGroup.setType("STATIC");
            resList.add(resGroup);
        }
        if (usersExp != null && !usersExp.trim().equals("")) {
            ResourceImpl resUserExp = new ResourceImpl();
            resUserExp.setIsGroup(false);
            resUserExp.setValue(usersExp);
            resUserExp.setType("XPATH");
            resList.add(resUserExp);
        }
        if (groupsExp != null && !groupsExp.equals("")) {
            ResourceImpl resGroupExp = new ResourceImpl();
            resGroupExp.setIsGroup(true);
            resGroupExp.setValue(groupsExp);
            resGroupExp.setType("XPATH");
            resList.add(resGroupExp);
        }
        this.m_participant.setResource(resList);
    }

    @Override
    public String getTitle() {
        return WorkflowResourceUtil.getString("GENERAL_EDITOR_TITLE");
    }

    protected String getHelpTopicId() {
        String _name = "ParticipantSimple";
        return HelpSystem.getHelpTopicId(this.getClass().getName() + "." + _name);
    }
}

