/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.routingslip.participants.Resource;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.routingslip.participants.SequentialParticipant;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.routingslip.participants.impl.ResourceImpl;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.bpelgraph.editors.StandardAttributeGenEditPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.TextFieldListener;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.modules.help.HelpSystem;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors.XPathEditorPanel;
import oracle.tip.tools.ide.pm.modules.workflow.resource.WorkflowResourceUtil;

public class ParticipantSequentialEditPage
extends StandardAttributeGenEditPage {
    protected SequentialParticipant m_participant;
    private JPanel m_GeneralPanel;
    private JTextField m_name;
    private JPanel m_IdentityPanel;
    private JLabel m_identityExplain;
    private XPathEditorPanel m_UserIdentityExpressionPanel;
    private TitledBorder m_ApproverIdBorder;
    private JRadioButton m_userRadio;
    private JRadioButton m_groupRadio;
    private ButtonGroup m_buttonGroup;

    public ParticipantSequentialEditPage(BPELGraphPane pane) {
        super(pane);
        this.createControls();
        this.layoutControls();
    }

    @Override
    protected void createControls() {
        this.m_GeneralPanel = new JPanel();
        this.m_name = new JTextField();
        this.m_name.getDocument().addDocumentListener(new TextFieldListener(this));
        this.m_ApproverIdBorder = new TitledBorder(" " + WorkflowResourceUtil.getString("IDENTITY") + " ");
        this.m_identityExplain = new JLabel(WorkflowResourceUtil.getString("IDENTITY_EXPLAIN"));
        this.m_IdentityPanel = new JPanel(new GridBagLayout());
        this.m_userRadio = new JRadioButton(WorkflowResourceUtil.getString("USER"));
        this.m_groupRadio = new JRadioButton(WorkflowResourceUtil.getString("GROUP"));
        this.m_buttonGroup = new ButtonGroup();
        this.m_buttonGroup.add(this.m_userRadio);
        this.m_buttonGroup.add(this.m_groupRadio);
        this.m_UserIdentityExpressionPanel = new XPathEditorPanel(this.m_graphPane, "XPATH", "");
    }

    @Override
    protected void layoutControls() {
        this.setLayout(new GridBagLayout());
        this.setSize(400, 480);
        int row = 0;
        JLabel lblName = new JLabel(WorkflowResourceUtil.getString("NAME"));
        this.m_GeneralPanel.setLayout(new GridBagLayout());
        JPanel namePanel = new JPanel(new GridBagLayout());
        int genRow = 0;
        GraphUtils.addComponent((Container)namePanel, (Component)lblName, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)namePanel, (Component)this.m_name, (int)1, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.5, (double)0.0);
        GraphUtils.addComponent((Container)this.m_GeneralPanel, (Component)namePanel, (int)0, (int)genRow++, (int)1, (int)1, (int)18, (int)1, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_GeneralPanel, (int)0, (int)row++, (int)1, (int)1, (int)18, (int)1, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        this.m_IdentityPanel.setLayout(new GridBagLayout());
        this.m_IdentityPanel.setBorder(this.m_ApproverIdBorder);
        int idRow = 0;
        GraphUtils.addComponent((Container)this.m_IdentityPanel, (Component)this.m_identityExplain, (int)0, (int)idRow++, (int)1, (int)1, (int)18, (int)1, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)this.m_IdentityPanel, (Component)this.m_userRadio, (int)0, (int)idRow++, (int)1, (int)1, (int)18, (int)1, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)this.m_IdentityPanel, (Component)this.m_groupRadio, (int)0, (int)idRow++, (int)1, (int)1, (int)18, (int)1, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)this.m_IdentityPanel, (Component)this.m_UserIdentityExpressionPanel, (int)0, (int)idRow++, (int)1, (int)1, (int)18, (int)1, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_IdentityPanel, (int)0, (int)row++, (int)1, (int)1, (int)18, (int)1, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    @Override
    public void setUserObject(Object model) {
        super.setUserObject(model);
        this.m_participant = (SequentialParticipant)model;
        this.loadControls();
    }

    protected void loadControls() {
        this.m_name.setText(this.m_participant.getName());
        String xpath = "";
        ResourceImpl res = (ResourceImpl)this.m_participant.getResource();
        if (res != null) {
            if (!res.isIsGroup() && res.getType().equals("XPATH")) {
                this.m_userRadio.setSelected(true);
            } else if (res.isIsGroup() && res.getType().equals("XPATH")) {
                this.m_groupRadio.setSelected(true);
            }
            xpath = res.getValue();
            this.m_UserIdentityExpressionPanel.loadControls(xpath);
        }
    }

    @Override
    public boolean validateEditorChanges() {
        return true;
    }

    @Override
    public void saveChanges() {
        String name = this.m_name.getText();
        String usersExp = "";
        String groupsExp = "";
        if (this.m_userRadio.isSelected()) {
            usersExp = this.m_UserIdentityExpressionPanel.getExpression();
        } else if (this.m_groupRadio.isSelected()) {
            groupsExp = this.m_UserIdentityExpressionPanel.getExpression();
        }
        this.m_participant.setName(name);
        if (usersExp != null && !usersExp.trim().equals("")) {
            ResourceImpl resUserExp = new ResourceImpl();
            resUserExp.setIsGroup(false);
            resUserExp.setValue(usersExp);
            resUserExp.setType("XPATH");
            this.m_participant.setResource((Resource)resUserExp);
        } else if (groupsExp != null && !groupsExp.equals("")) {
            ResourceImpl resGroupExp = new ResourceImpl();
            resGroupExp.setIsGroup(true);
            resGroupExp.setValue(groupsExp);
            resGroupExp.setType("XPATH");
            this.m_participant.setResource((Resource)resGroupExp);
        }
    }

    @Override
    public String getTitle() {
        return WorkflowResourceUtil.getString("GENERAL_EDITOR_TITLE");
    }

    protected String getHelpTopicId() {
        String _name = "ParticipantSimple";
        return HelpSystem.getHelpTopicId(this.getClass().getName() + "." + _name);
    }
}

