/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.WorkflowManager;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.notifications.Recipient;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.notifications.TaskStatus;
import oracle.tip.tools.ide.common.ui.GenericDialog;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.IHelpUtil;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors.NotificationDetailsPanel;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors.NotificationsEditorData;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors.statusrecipient.StatusRecipientData;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors.statusrecipient.StatusRecipientModel;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;
import oracle.tip.tools.ide.workflow.util.WorkFlowHelpUtil;

public class NotificationsEditor
extends JPanel
implements ActionListener,
ListSelectionListener {
    private JButton mAddButton = null;
    private JButton mDeleteButton = null;
    private JButton mConfigureButton = null;
    private JTable mTable = null;
    private static final String CONFIGURE_NOTIFICATION = "Configure Notification";
    private NotificationsEditorData mData = null;
    private List mTaskStatusList = new ArrayList();
    private List mRecipientList = new ArrayList();

    public NotificationsEditor(Collection pTaskStatusCollection, Collection pRecipientCollection) {
        this.createComponents();
        this.layoutComponents();
        this.setListeners();
        this.setData(new NotificationsEditorData());
        this.prepareTaskStatusList(pTaskStatusCollection);
        this.prepareRecipientList(pRecipientCollection);
    }

    private void prepareTaskStatusList(Collection pTaskStatusCollection) {
        Iterator iter = pTaskStatusCollection.iterator();
        while (iter.hasNext()) {
            this.mTaskStatusList.add(iter.next());
        }
    }

    private void prepareRecipientList(Collection pRecipientCollection) {
        Iterator iter = pRecipientCollection.iterator();
        while (iter.hasNext()) {
            this.mRecipientList.add(iter.next());
        }
    }

    private void createComponents() {
        this.mAddButton = UIHelper.createModelerButton((String)BPELStringTranslator.getString("ADD_BUTTON_TEXT"), (Icon)ImageCache.getIcon("add16"));
        this.mDeleteButton = UIHelper.createModelerButton((String)BPELStringTranslator.getString("DEL_BUTTON_TEXT"), (Icon)ImageCache.getIcon("delete16"));
        this.mConfigureButton = new JButton(CONFIGURE_NOTIFICATION);
    }

    private void setListeners() {
        this.mConfigureButton.addActionListener(this);
        this.mAddButton.addActionListener(this);
        this.mDeleteButton.addActionListener(this);
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        JPanel topPanel = this.prepareTopPanel();
        JPanel bottomPanel = this.prepareBottomPanel();
        JPanel centerPanel = this.prepareCenterPanel();
        this.add((Component)topPanel, "North");
        this.add((Component)bottomPanel, "South");
        this.add((Component)centerPanel, "Center");
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    private JPanel prepareCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.mTable = new JTable(this.prepareTableModel());
        TableColumn statusColumn = this.mTable.getColumnModel().getColumn(0);
        statusColumn.setCellEditor(new DefaultCellEditor(this.getStatusCellEditor()));
        statusColumn.setCellRenderer(new LocalCellRenderer());
        TableColumn recipientColumn = this.mTable.getColumnModel().getColumn(1);
        recipientColumn.setCellEditor(new DefaultCellEditor(this.getRecipientCellEditor()));
        recipientColumn.setCellRenderer(new LocalCellRenderer());
        panel.add(new JScrollPane(this.mTable));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 2, 5, 2));
        return panel;
    }

    private JPanel prepareBottomPanel() {
        GridBagLayout gl = new GridBagLayout();
        JPanel panel = new JPanel(gl);
        int x = 0;
        int y = 0;
        Insets insets = new Insets(2, 5, 5, 2);
        Box box = Box.createHorizontalBox();
        gl.setConstraints(box, new GridBagConstraints(x, y, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        panel.add(box);
        gl.setConstraints(this.mConfigureButton, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        panel.add(this.mConfigureButton);
        return panel;
    }

    private JPanel prepareTopPanel() {
        ArrayList<JButton> list = new ArrayList<JButton>();
        GridBagLayout gl = new GridBagLayout();
        JPanel panel = new JPanel(gl);
        Insets insets = new Insets(2, 5, 2, 2);
        int x = 0;
        int y = 0;
        Component box = Box.createHorizontalGlue();
        gl.setConstraints(box, new GridBagConstraints(x, y, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        panel.add(box);
        gl.setConstraints(this.mAddButton, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        panel.add(this.mAddButton);
        list.add(this.mAddButton);
        gl.setConstraints(this.mDeleteButton, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        panel.add(this.mDeleteButton);
        list.add(this.mDeleteButton);
        this.equateWidths(list);
        return panel;
    }

    private void equateWidths(List pComponents) {
        Dimension d;
        int width = -1;
        for (JComponent c : pComponents) {
            d = c.getPreferredSize();
            if (width >= d.width) continue;
            width = d.width;
        }
        for (JComponent c : pComponents) {
            d = c.getPreferredSize();
            d.width = width;
            c.setPreferredSize(d);
        }
    }

    private static List prepareStatusRecipientList() {
        ArrayList<StatusRecipientData> l = new ArrayList<StatusRecipientData>();
        l.add(new StatusRecipientData("Assigned", "Assignee"));
        l.add(new StatusRecipientData("Completed", "Creator"));
        l.add(new StatusRecipientData("Errored", "Error Assignee"));
        return l;
    }

    private TableModel prepareTableModel() {
        ArrayList l = new ArrayList();
        StatusRecipientModel model = new StatusRecipientModel(l);
        return model;
    }

    public static void main(String[] argv) {
        WorkflowManager wfm = WorkflowManager.getInstance();
        NotificationsEditor e = new NotificationsEditor(wfm.getTaskStatusActions(), wfm.getRecipientActions());
        JFrame frame = new JFrame();
        frame.getContentPane().add(e);
        frame.setDefaultCloseOperation(3);
        frame.setSize(400, 400);
        e.setData(new NotificationsEditorData(NotificationsEditor.prepareStatusRecipientList()));
        frame.setVisible(true);
    }

    private JComboBox getStatusCellEditor() {
        String[] status = new String[]{"Assigned", "Completed", "Errored"};
        JComboBox<String> c = new JComboBox<String>();
        for (int i = 0; i < status.length; ++i) {
            c.addItem(status[i]);
        }
        return c;
    }

    private JComboBox getRecipientCellEditor() {
        String[] status = new String[]{"Assignee", "Creator", "Error Assignee"};
        JComboBox<String> c = new JComboBox<String>();
        for (int i = 0; i < status.length; ++i) {
            c.addItem(status[i]);
        }
        return c;
    }

    @Override
    public void actionPerformed(ActionEvent pEvent) {
        if (pEvent.getSource().equals(this.mConfigureButton)) {
            this.handleConfigure(pEvent);
        } else if (pEvent.getSource().equals(this.mDeleteButton)) {
            this.handleDelete(pEvent);
        } else if (pEvent.getSource().equals(this.mAddButton)) {
            this.handleAdd(pEvent);
        }
    }

    private void handleConfigure(ActionEvent pEvent) {
        GenericDialog dialog = new GenericDialog((Frame)UIHelper.getFrame((Component)((Component)pEvent.getSource())));
        NotificationDetailsPanel panel = new NotificationDetailsPanel();
        panel.setBorder(BorderFactory.createEtchedBorder());
        dialog.setContent((JComponent)panel);
        dialog.setModal(true);
        dialog.setButtons(28);
        UIHelper.centerInScreen((Component)dialog);
        dialog.setSize(500, 400);
        dialog.setHelpProvider((IHelpUtil)WorkFlowHelpUtil.getInstance());
        dialog.setVisible(true);
    }

    private void handleDelete(ActionEvent pEvent) {
        ListSelectionModel lsm = this.mTable.getSelectionModel();
        int start = lsm.getMinSelectionIndex();
        int end = lsm.getMaxSelectionIndex();
        StatusRecipientModel model = (StatusRecipientModel)this.mTable.getModel();
        for (int i = start; i <= end; ++i) {
            if (!this.mTable.isRowSelected(i)) continue;
            model.removeDataAt(i);
        }
    }

    private void handleAdd(ActionEvent pEvent) {
        String taskStatus = ((TaskStatus)this.mTaskStatusList.get(0)).getName();
        String recipient = ((Recipient)this.mRecipientList.get(0)).getName();
        StatusRecipientData d = new StatusRecipientData(taskStatus, recipient);
        StatusRecipientModel model = (StatusRecipientModel)this.mTable.getModel();
        model.addData(d);
    }

    public NotificationsEditorData getData() {
        return this.mData;
    }

    public void setData(NotificationsEditorData pData) {
        this.mData = pData;
        this.updateData();
    }

    private void updateData() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                NotificationsEditor.this.updateDataInAUIThread();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    private void updateDataInAUIThread() {
        StatusRecipientModel model = (StatusRecipientModel)this.mTable.getModel();
        model.setData(this.mData.getList());
        model.fireTableDataChanged();
    }

    @Override
    public void valueChanged(ListSelectionEvent pEvent) {
        if (pEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel lsm = (ListSelectionModel)pEvent.getSource();
        if (lsm.isSelectionEmpty()) {
            this.mDeleteButton.setEnabled(false);
        } else {
            this.mDeleteButton.setEnabled(true);
        }
    }

    class LocalCellRenderer
    extends DefaultTableCellRenderer {
        LocalCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable pTable, Object pData, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setHorizontalTextPosition(0);
            this.setToolTipText((String)pData);
            return super.getTableCellRendererComponent(pTable, pData, isSelected, hasFocus, row, column);
        }
    }
}

