/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.ide.controls.JMultiLineLabel;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors.WFDurationPanel;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

class NotificationDetailsPanel
extends JPanel {
    private static final String NOTIFICATION_MESSAGE = "Notification Message:";
    private static final String NOTIFICATON_HELP = "Applies to Voice, SMS, Pager, Email, and Fax. Email and Fax message will also include the worklist task detail";
    private static final String FREQUENCY = "Frequency";
    private static final String REMIND_EACH = "Remind Each:";
    private static final String AFTER_ASSIGNMENT = "After Assignment";
    private static final String BEFORE_EXPIRATION = "Before Expiration";
    private static final String MAKE_NOTIFICATONS_SECURE = "Make all notifications secure";
    private static final String MAKE_EMAIL_MESSAGES_ACTIONABLE = "Make email messages actionable";
    private JButton mNotificationMessageButton = null;
    private JTextArea mNotificationMessage = null;
    private JRadioButton mAfterAssignmentButton = null;
    private JRadioButton mBeforeExpirationButton = null;
    private JCheckBox mSecureBox = null;
    private JCheckBox mActionableBox = null;
    private List mWidthsList = new ArrayList();

    public NotificationDetailsPanel() {
        this.createComponents();
        this.layoutComponents();
    }

    private void createComponents() {
        this.mNotificationMessageButton = UIHelper.createModelerButton((Icon)ImageCache.getIcon("expressionbuilder"));
        this.mNotificationMessage = new JTextArea();
        this.mAfterAssignmentButton = new JRadioButton(AFTER_ASSIGNMENT);
        this.mBeforeExpirationButton = new JRadioButton(BEFORE_EXPIRATION);
        ButtonGroup group = new ButtonGroup();
        group.add(this.mAfterAssignmentButton);
        group.add(this.mBeforeExpirationButton);
        this.mSecureBox = new JCheckBox(MAKE_NOTIFICATONS_SECURE);
        this.mActionableBox = new JCheckBox(MAKE_EMAIL_MESSAGES_ACTIONABLE);
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        JPanel centerPanel = this.prepareCenterPanel();
        JPanel bottomPanel = this.prepareBottomPanel();
        bottomPanel.setBorder(BorderFactory.createEmptyBorder(5, 12, 5, 12));
        centerPanel.setBorder(BorderFactory.createEmptyBorder(5, 12, 5, 12));
        this.add((Component)centerPanel, "Center");
        this.add((Component)bottomPanel, "South");
        this.equateComponents(this.mWidthsList);
    }

    private JPanel prepareCenterPanel() {
        GridBagLayout gl = new GridBagLayout();
        JPanel panel = new JPanel(gl);
        JPanel labelPanel = this.prepareNotificationMessagePanel();
        Insets insets = new Insets(2, 2, 2, 2);
        int x = 0;
        int y = 0;
        gl.setConstraints(labelPanel, new GridBagConstraints(x, y, 0, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        panel.add(labelPanel);
        JPanel messageDataPanel = this.prepareMessageDataPanel();
        gl.setConstraints(messageDataPanel, new GridBagConstraints(x, ++y, 0, 1, 1.0, 1.0, 21, 1, insets, 0, 0));
        panel.add(messageDataPanel);
        JPanel messageHelpPanel = this.prepareMessageNoticePanel();
        gl.setConstraints(messageHelpPanel, new GridBagConstraints(x, ++y, 0, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        panel.add(messageHelpPanel);
        JPanel frequencyPanel = this.prepareFrequencyPanel();
        frequencyPanel.setBorder(BorderFactory.createTitledBorder(FREQUENCY));
        gl.setConstraints(frequencyPanel, new GridBagConstraints(x, ++y, 0, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        panel.add(frequencyPanel);
        return panel;
    }

    private JPanel prepareNotificationMessagePanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        JLabel label = new JLabel(NOTIFICATION_MESSAGE);
        panel.add(label);
        return panel;
    }

    private JPanel prepareMessageNoticePanel() {
        GridBagLayout gl = new GridBagLayout();
        JPanel panel = new JPanel(gl);
        JMultiLineLabel label = new JMultiLineLabel(NOTIFICATON_HELP);
        label.setEnabled(false);
        int x = 0;
        int y = 0;
        Insets insets = new Insets(2, 2, 2, 2);
        gl.setConstraints((Component)label, new GridBagConstraints(x, y, -1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        panel.add((Component)label);
        this.mWidthsList.add(label);
        Component glue = Box.createGlue();
        gl.setConstraints(glue, new GridBagConstraints(++x, y, 0, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        panel.add(glue);
        return panel;
    }

    private JPanel prepareFrequencyPanel() {
        JPanel panel = new JPanel(new GridLayout(2, 1));
        WFDurationPanel durationPanel = new WFDurationPanel(REMIND_EACH, null);
        JPanel lowerPanel = new JPanel();
        lowerPanel.setLayout(new BoxLayout(lowerPanel, 0));
        Component lStrip = Box.createHorizontalGlue();
        Component rStrip = Box.createHorizontalGlue();
        lowerPanel.add(lStrip);
        lowerPanel.add(this.mAfterAssignmentButton);
        lowerPanel.add(this.mBeforeExpirationButton);
        lowerPanel.add(rStrip);
        panel.add(durationPanel);
        panel.add(lowerPanel);
        return panel;
    }

    private JPanel prepareMessageDataPanel() {
        GridBagLayout gl = new GridBagLayout();
        JPanel panel = new JPanel(gl);
        int x = 0;
        int y = 0;
        Insets insets = new Insets(2, 2, 2, 2);
        JScrollPane c = new JScrollPane(this.mNotificationMessage);
        gl.setConstraints(c, new GridBagConstraints(x, y, 1, 0, 1.0, 0.0, 21, 1, insets, 0, 0));
        panel.add(c);
        this.mWidthsList.add(c);
        gl.setConstraints(this.mNotificationMessageButton, new GridBagConstraints(++x, y, 0, -1, 0.0, 0.0, 21, 0, insets, 0, 0));
        panel.add(this.mNotificationMessageButton);
        Component strut = Box.createVerticalStrut(50);
        gl.setConstraints(strut, new GridBagConstraints(x, ++y, 0, 0, 0.0, 1.0, 21, 1, insets, 0, 0));
        panel.add(strut);
        return panel;
    }

    private JPanel prepareBottomPanel() {
        GridBagLayout gl = new GridBagLayout();
        JPanel panel = new JPanel(gl);
        Insets insets = new Insets(2, 2, 2, 2);
        int x = 0;
        int y = 0;
        gl.setConstraints(this.mSecureBox, new GridBagConstraints(x, y, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        panel.add(this.mSecureBox);
        Component box = Box.createHorizontalGlue();
        gl.setConstraints(box, new GridBagConstraints(++x, y, 1, 1, 1.0, 0.0, 21, 1, insets, 0, 0));
        panel.add(box);
        gl.setConstraints(this.mActionableBox, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        panel.add(this.mActionableBox);
        return panel;
    }

    public static void main(String[] argv) {
        JFrame frame = new JFrame();
        frame.setSize(500, 500);
        NotificationDetailsPanel panel = new NotificationDetailsPanel();
        frame.setContentPane(panel);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    private void equateComponents(List pComponentList) {
        Dimension d;
        int width = -1;
        for (JComponent c : pComponentList) {
            d = c.getPreferredSize();
            if (d.width <= width) continue;
            width = d.width;
        }
        for (JComponent c : pComponentList) {
            d = c.getPreferredSize();
            d.width = width;
            c.setPreferredSize(d);
        }
    }
}

