/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import oracle.ide.util.ResourceUtils;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.BpelNSResolver;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.expressionbuilder.ExpressionBuilder;
import oracle.tip.tools.ide.common.expressionbuilder.ExpressionBuilderPicker;
import oracle.tip.tools.ide.common.expressionbuilders.FunctionsExpressionBuilderPicker;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.NamespaceResolver;
import oracle.tip.tools.ide.common.xpath.editor.XPathEditorPane;
import oracle.tip.tools.ide.common.xpath.editor.util.VariableDataCallBack;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableDataCallBackImpl;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableExpressionBuilderPicker;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariablePickerPanel;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.lookup.LookupDialog;

public class IdentityEditorPanel
extends JPanel
implements ActionListener {
    protected JTextField m_IdentityText;
    private JButton m_IdentityBtn;
    private String m_labelKey;
    private String m_commentKey;
    private boolean m_bUser;
    protected BPELGraphPane m_graph;
    protected Activity m_activity;

    public IdentityEditorPanel(BPELGraphPane graph, String labelKey, String commentKey, boolean bUser) {
        this.m_graph = graph;
        this.m_labelKey = labelKey;
        this.m_commentKey = commentKey;
        this.m_bUser = bUser;
        this.createControls();
        this.layoutControls();
    }

    public String getIdentity() {
        return this.m_IdentityText.getText();
    }

    public void loadControls(String value) {
        BPELXmlModel mainModel = this.m_graph.getBPELXmlModel();
        VariableDataCallBackImpl expDataCallBack = new VariableDataCallBackImpl(mainModel, this.m_activity);
        this.m_IdentityText.setText(value);
    }

    protected void createControls() {
        this.m_IdentityText = new JTextField();
        this.m_IdentityText.setEditable(true);
        this.m_IdentityBtn = UIHelper.createBrowseButton((String)BPELStringTranslator.getString("BROWSE_OID_USERS"));
        this.m_IdentityBtn.setToolTipText(BPELStringTranslator.getString("BROWSE_OID_USERS"));
        this.m_IdentityBtn.addActionListener(this);
    }

    protected void layoutControls() {
        ToolBar tb = new ToolBar();
        tb.add((Component)this.m_IdentityBtn);
        JLabel lblExp = new JLabel();
        ResourceUtils.resLabel((JLabel)lblExp, (Component)this.m_IdentityText, (String)BPELStringTranslator.getString(this.m_labelKey));
        this.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)this, (Component)lblExp, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_IdentityText, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.5, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)tb, (int)2, (int)row++, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        if (this.m_commentKey != null && !this.m_commentKey.trim().equals("")) {
            JLabel commentExp = new JLabel();
            ResourceUtils.resLabel((JLabel)commentExp, (Component)this.m_IdentityText, (String)BPELStringTranslator.getString(this.m_commentKey));
            GraphUtils.addComponent((Container)this, (Component)commentExp, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LookupDialog dialog;
        boolean success;
        Object src = e.getSource();
        if (src == this.m_IdentityBtn && (success = (dialog = this.m_bUser ? new LookupDialog(0, this) : new LookupDialog(1, this)).showDialog())) {
            this.m_IdentityText.setText(dialog.getSelectedPrinciple());
        }
    }

    protected final NamespaceResolver getNSResolver(Activity activity) {
        BpelNSResolver nsResolver = new BpelNSResolver(((BPELGraphModel)this.m_graph.getModel()).getProcess());
        Map map = ((BPELGraphModel)this.m_graph.getModel()).getProcess().getNamespaceAliases();
        Object[] values = map.keySet().toArray();
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                nsResolver.addNSEntry((String)values[i], (String)map.get(values[i]));
            }
        }
        for (Activity curAct = activity; curAct != null && !(curAct instanceof Process); curAct = curAct.getParentActivity()) {
            Map attrMap;
            if (!(curAct instanceof Activity) || (attrMap = curAct.getAttributesMap()) == null) continue;
            for (String attName : attrMap.keySet()) {
                String prefix;
                if (!attName.startsWith("xmlns:") || (prefix = attName.substring(6, attName.length())).equals("")) continue;
                nsResolver.addNSEntry(prefix, (String)attrMap.get(attName));
            }
        }
        return nsResolver;
    }

    protected void invokeGraphicalXPathBuilder(XPathEditorPane editorPane, Activity activity) {
        BPELXmlModel mainModel = this.m_graph.getBPELXmlModel();
        VariableDataCallBackImpl dataCallBack = new VariableDataCallBackImpl(mainModel, activity);
        VariablePickerPanel p = new VariablePickerPanel(this.m_graph, dataCallBack, this.getNSResolver(activity));
        VariableExpressionBuilderPicker picker = new VariableExpressionBuilderPicker(p, activity);
        ExpressionBuilderPicker[] pickers = new ExpressionBuilderPicker[]{picker, new FunctionsExpressionBuilderPicker(this.getNSResolver(activity))};
        XPathEditorPane pane = new XPathEditorPane();
        pane.initializeDocument();
        pane.initializeEditorPane((VariableDataCallBack)dataCallBack, editorPane.getText(), this.getNSResolver(activity), false);
        ExpressionBuilder dlg = new ExpressionBuilder(GraphUtils.getFrame((Component)((Object)this.m_graph)), (JTextComponent)pane, pickers);
        if (dlg.display() == 0) {
            editorPane.setText(dlg.getExpressionText());
        }
    }
}

