/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.util.ResourceUtils;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.BpelNSResolver;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.config.Outcome;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.config.Outcomes;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.config.UserTaskConfigModel;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.config.impl.OutcomeImpl;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.config.impl.UserTaskConfigModelImpl;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.iface.UserTask;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.routingslip.EscalationPolicy;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.routingslip.Parameter;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.routingslip.RenewalPolicy;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.routingslip.RoutingSlipFactory;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.routingslip.UserTaskRoutingSlipModel;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Assign;
import oracle.tip.tools.ide.common.bpelparser.iface.Copy;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Sequence;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.bpelparser.iface.Variables;
import oracle.tip.tools.ide.common.expressionbuilder.ExpressionBuilder;
import oracle.tip.tools.ide.common.expressionbuilder.ExpressionBuilderPicker;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.ValidatableTextField;
import oracle.tip.tools.ide.common.utils.NamespaceResolver;
import oracle.tip.tools.ide.common.xpath.editor.XPathEditorPane;
import oracle.tip.tools.ide.common.xpath.editor.util.VariableDataCallBack;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableExpressionBuilderPicker;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariablePickerPanel;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors.DurationData;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors.DurationDetailsPanel;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors.WFDurationPanel;
import oracle.tip.tools.ide.pm.modules.workflow.util.UserTaskCallBack;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class GeneralTaskEditor
extends BaseEditingPage
implements ActionListener {
    private static final String OUTCOME_SEPARATOR = ",";
    private ValidatableTextField mWorkFlowName = null;
    private JComboBox mPriority = null;
    private ValidatableTextField mTaskTitle = null;
    private JButton mTaskTitleSearch = null;
    private ValidatableTextField mOutComes = null;
    private JButton mOutComesSearch = null;
    private JPanel mCreatorPanel = null;
    private WFDurationPanel mDurationPanel = null;
    private JButton mDurationEditButton = null;
    private JCheckBox mAppendToExistingWorkflow = null;
    private JComboBox mRequestOptions = null;
    private UserTask mData = null;
    List widthCollection = new ArrayList();
    private DurationData mDurationData = new DurationData();
    private List mOutComesList = new ArrayList();
    private Process mProcess = null;
    private static final String WORKFLOW_NAME = "Workflow Name:";
    private static final String TASK_TITLE = "Task Title";
    private static final String OUTCOMES = "Outcomes:";
    private static final String OUTCOMES_HELP = "Enter comma separated values or add existing outcomes.";
    private static final String PRIORITY = "&Priority";
    private static final String DURATION_MESSAGE = "Expire task after Duration";
    private static final String EDIT_DURATION_MESSAGE = "Edit...";
    private static final String DURATION = "Duration";
    private static final String CREATOR = "&Creator:";
    private static final String APPEND_TO_EXISTING_WF = "Append to existing workflow";

    public GeneralTaskEditor(BPELGraphPane pane) {
        super(pane);
        this.init();
        this.layoutComponents();
        this.mProcess = ((BPELGraphModel)pane.getModel()).getProcess();
    }

    @Override
    public String getTitle() {
        return "General";
    }

    @Override
    public void setUserObject(Object model) {
        super.setUserObject(model);
        this.mData = (UserTask)model;
        this.loadControls();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.mDurationEditButton)) {
            if (this.mDurationData == null) {
                String[] pNames = new String[]{"Some guy", "Another guy", "Yet another", "B"};
                ArrayList list = new ArrayList(pNames.length);
                this.mDurationData = new DurationData(2, "B", list);
            }
            DurationDetailsPanel panel = new DurationDetailsPanel(this.mDurationData);
            JEWTDialog dialog = JEWTDialog.createDialog((Component)this, (String)"DurationDetails - Expense Request", (int)7);
            dialog.setContent((Component)panel);
            dialog.setPreferredSize(500, 400);
            dialog.setResizable(true);
            dialog.pack();
            if (dialog.runDialog()) {
                this.mDurationData = panel.getData();
            }
        }
    }

    private void init() {
        this.mWorkFlowName = new ValidatableTextField(40);
        this.mPriority = new JComboBox();
        this.mTaskTitle = new ValidatableTextField();
        this.mTaskTitleSearch = UIHelper.createModelerButton((Icon)ImageCache.getIcon("expressionbuilder"));
        this.mOutComes = new ValidatableTextField();
        this.mOutComesSearch = UIHelper.createBrowseButton((String)"Outcomes browser");
        this.mAppendToExistingWorkflow = new JCheckBox();
        this.mRequestOptions = new JComboBox();
        this.mDurationEditButton = new JButton();
        this.mDurationEditButton.addActionListener(this);
    }

    private void equateWidths(List components) {
        int width = -100000;
        for (JComponent c : components) {
            if (width >= c.getPreferredSize().width) continue;
            width = c.getPreferredSize().width;
        }
        for (JComponent c : components) {
            Dimension d = c.getPreferredSize();
            d.width = width;
            c.setPreferredSize(d);
        }
    }

    private void layoutComponents() {
        GridBagLayout gl = new GridBagLayout();
        this.setLayout(gl);
        int X = 0;
        int Y = 0;
        int x = 0;
        int y = 0;
        int width = 1;
        Insets insets = new Insets(2, 2, 2, 2);
        GridBagLayout ga = new GridBagLayout();
        JPanel lworkFlowPanel = new JPanel(ga);
        Component vStrut = Box.createVerticalStrut(10);
        ga.setConstraints(vStrut, new GridBagConstraints(x, y, 0, 1, 1.0, 0.0, 17, 0, new Insets(5, 2, 2, 2), 0, 0));
        lworkFlowPanel.add(vStrut);
        x = 0;
        JLabel workFlowNameLabel = new JLabel();
        ga.setConstraints(workFlowNameLabel, new GridBagConstraints(x, ++y, width, 1, 0.0, 0.0, 17, 0, new Insets(5, 2, 2, 2), 0, 0));
        lworkFlowPanel.add(workFlowNameLabel);
        this.widthCollection.add(workFlowNameLabel);
        x += width;
        width = 4;
        ga.setConstraints((Component)this.mWorkFlowName, new GridBagConstraints(x, y, width, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        lworkFlowPanel.add((Component)this.mWorkFlowName);
        ResourceUtils.resLabel((JLabel)workFlowNameLabel, (Component)this.mWorkFlowName, (String)WORKFLOW_NAME);
        x += width;
        width = 1;
        Component strut = Box.createHorizontalStrut(2);
        ga.setConstraints(strut, new GridBagConstraints(x, y, width, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        lworkFlowPanel.add(strut);
        x += width;
        width = 1;
        JLabel priorityLabel = new JLabel();
        ga.setConstraints(priorityLabel, new GridBagConstraints(x, y, width, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        lworkFlowPanel.add(priorityLabel);
        ga.setConstraints(this.mPriority, new GridBagConstraints(x += width, y, width, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        lworkFlowPanel.add(this.mPriority);
        ResourceUtils.resLabel((JLabel)priorityLabel, (Component)this.mPriority, (String)PRIORITY);
        Component c1 = Box.createHorizontalStrut(12);
        ga.setConstraints(c1, new GridBagConstraints(x += width, y, width, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        lworkFlowPanel.add(c1);
        gl.setConstraints(lworkFlowPanel, new GridBagConstraints(X, Y, 0, 1, 1.0, 0.0, 21, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.add(lworkFlowPanel);
        ++Y;
        x = 0;
        width = 1;
        GridBagLayout gb = new GridBagLayout();
        JPanel taskPanel = new JPanel(gb);
        JLabel taskTitleLabel = new JLabel();
        gb.setConstraints(taskTitleLabel, new GridBagConstraints(x, y, width, 1, 0.0, 0.0, 17, 2, insets, 0, 0));
        taskPanel.add(taskTitleLabel);
        this.widthCollection.add(taskTitleLabel);
        x += width;
        width = 6;
        gb.setConstraints((Component)this.mTaskTitle, new GridBagConstraints(x, y, width, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        taskPanel.add((Component)this.mTaskTitle);
        ResourceUtils.resLabel((JLabel)taskTitleLabel, (Component)this.mTaskTitle, (String)TASK_TITLE);
        x += width;
        width = 1;
        gb.setConstraints(this.mTaskTitleSearch, new GridBagConstraints(x, y, width, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        taskPanel.add(this.mTaskTitleSearch);
        gl.setConstraints(taskPanel, new GridBagConstraints(X, Y, 0, 1, 1.0, 0.0, 21, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.add(taskPanel);
        ++Y;
        x = 0;
        width = 1;
        GridBagLayout gc = new GridBagLayout();
        JPanel outComePanel = new JPanel(gc);
        JLabel outComeLabel = new JLabel();
        gc.setConstraints(outComeLabel, new GridBagConstraints(x, y, width, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        outComePanel.add(outComeLabel);
        this.widthCollection.add(outComeLabel);
        x += width;
        width = 6;
        gc.setConstraints((Component)this.mOutComes, new GridBagConstraints(x, y, width, 1, 3.0, 0.0, 21, 2, insets, 0, 0));
        outComePanel.add((Component)this.mOutComes);
        ResourceUtils.resLabel((JLabel)outComeLabel, (Component)this.mOutComes, (String)OUTCOMES);
        x += width;
        width = 1;
        gc.setConstraints(this.mOutComesSearch, new GridBagConstraints(x, y, width, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        outComePanel.add(this.mOutComesSearch);
        gl.setConstraints(outComePanel, new GridBagConstraints(X, Y, 0, 1, 1.0, 0.0, 21, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.add(outComePanel);
        ++Y;
        x = 0;
        Insets helpInsets = new Insets(0, 2, 2, 2);
        width = 1;
        GridBagLayout gd = new GridBagLayout();
        JPanel outComeHelpPanel = new JPanel(gd);
        Component emptyBox = Box.createHorizontalStrut(50);
        gd.setConstraints(emptyBox, new GridBagConstraints(x, y, -1, 1, 0.0, 0.0, 21, 2, helpInsets, 0, 0));
        outComeHelpPanel.add(emptyBox);
        this.widthCollection.add(emptyBox);
        x += width;
        width = 6;
        JMultiLineLabel outComesHelp = new JMultiLineLabel(OUTCOMES_HELP);
        gd.setConstraints((Component)outComesHelp, new GridBagConstraints(x, y, 0, 1, 1.0, 0.0, 21, 2, helpInsets, 0, 0));
        outComeHelpPanel.add((Component)outComesHelp);
        outComesHelp.setEnabled(false);
        gl.setConstraints(outComeHelpPanel, new GridBagConstraints(X, Y, 0, 1, 1.0, 0.0, 21, 2, helpInsets, 0, 0));
        this.add(outComeHelpPanel);
        this.createCreatorPanel(gl, ++Y);
        x = 0;
        width = 8;
        JPanel lDurationComponent = this.createDurationPanel();
        lDurationComponent.setBorder(BorderFactory.createTitledBorder(DURATION));
        gl.setConstraints(lDurationComponent, new GridBagConstraints(X, ++Y, width, 1, 1.0, 0.0, 21, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.add(lDurationComponent);
        ++Y;
        x = 0;
        width = 1;
        x = 0;
        GridBagLayout ge = new GridBagLayout();
        JPanel appendPanel = new JPanel(ge);
        ge.setConstraints(this.mAppendToExistingWorkflow, new GridBagConstraints(x, y, width, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        appendPanel.add(this.mAppendToExistingWorkflow);
        x += width;
        width = 1;
        ge.setConstraints(this.mRequestOptions, new GridBagConstraints(x, y, width, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        appendPanel.add(this.mRequestOptions);
        ResourceUtils.resButton((AbstractButton)this.mAppendToExistingWorkflow, (String)APPEND_TO_EXISTING_WF);
        gl.setConstraints(appendPanel, new GridBagConstraints(X, Y, 0, 1, 1.0, 0.0, 21, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.add(appendPanel);
        x = 0;
        Box box = Box.createVerticalBox();
        gl.setConstraints(box, new GridBagConstraints(X, ++Y, 1, 1, 1.0, 1.0, 21, 1, insets, 0, 0));
        this.add(box);
        this.equateWidths(this.widthCollection);
    }

    private JPanel createDurationPanel() {
        GridBagLayout gl = new GridBagLayout();
        JPanel lPanel = new JPanel(gl);
        int x = 0;
        int y = 0;
        int width = 1;
        this.mDurationPanel = new WFDurationPanel();
        gl.setConstraints(this.mDurationPanel, new GridBagConstraints(x, y, 0, 1, 1.0, 0.0, 21, 2, new Insets(2, 2, 2, 2), 0, 0));
        lPanel.add(this.mDurationPanel);
        x = 0;
        width = 2;
        Component hStrut = Box.createHorizontalStrut(48);
        gl.setConstraints(hStrut, new GridBagConstraints(x, ++y, width, 1, 0.0, 0.0, 21, 2, new Insets(2, 2, 2, 2), 0, 0));
        lPanel.add(hStrut);
        this.widthCollection.add(hStrut);
        x += width;
        width = 4;
        JLabel lDurationLabel = new JLabel();
        gl.setConstraints(lDurationLabel, new GridBagConstraints(x, y, 1, 1, 1.0, 0.0, 21, 2, new Insets(2, 2, 2, 2), 0, 0));
        lPanel.add(lDurationLabel);
        lDurationLabel.setText(DURATION_MESSAGE);
        x += width;
        width = 1;
        gl.setConstraints(this.mDurationEditButton, new GridBagConstraints(x, y, width, 1, 1.0, 0.0, 21, 0, new Insets(2, 2, 2, 2), 0, 0));
        lPanel.add(this.mDurationEditButton);
        ResourceUtils.resButton((AbstractButton)this.mDurationEditButton, (String)EDIT_DURATION_MESSAGE);
        Component endBox = Box.createHorizontalStrut(15);
        width = 1;
        gl.setConstraints(endBox, new GridBagConstraints(x, y, width, 1, 1.0, 0.0, 21, 0, new Insets(2, 2, 2, 2), 0, 0));
        lPanel.add(endBox);
        return lPanel;
    }

    private void createCreatorPanel(GridBagLayout gl, int y) {
        JLabel creatorLabel = new JLabel();
        JTextField field = new JTextField();
        JButton fullBlownExplorerButton = UIHelper.createModelerButton((Icon)ImageCache.getIcon("expressionbuilder"));
        GridBagLayout ga = new GridBagLayout();
        JPanel creatorPanel = new JPanel(ga);
        ResourceUtils.resLabel((JLabel)creatorLabel, (Component)field, (String)CREATOR);
        int x = 0;
        int width = 1;
        ga.setConstraints(creatorLabel, new GridBagConstraints(x, 0, width, 1, 0.0, 0.0, 21, 0, new Insets(2, 2, 2, 2), 0, 0));
        creatorPanel.add(creatorLabel);
        this.widthCollection.add(creatorLabel);
        x += width;
        width = 5;
        ga.setConstraints(field, new GridBagConstraints(x, 0, width, 1, 4.0, 0.0, 21, 2, new Insets(2, 2, 2, 2), 0, 0));
        creatorPanel.add(field);
        x += width;
        width = 1;
        ga.setConstraints(fullBlownExplorerButton, new GridBagConstraints(x, 0, 0, 1, 0.0, 0.0, 21, 0, new Insets(2, 2, 2, 2), 0, 0));
        creatorPanel.add(fullBlownExplorerButton);
        gl.setConstraints(creatorPanel, new GridBagConstraints(0, y, 0, 1, 1.0, 0.0, 21, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.add(creatorPanel);
    }

    private void loadControls() {
        this.loadDataIntoControls(this.mData, this.m_graphPane.getBPELProject());
        TaskTitleHandler h = new TaskTitleHandler(this.m_graphPane, this.m_graphPane.getBPELProject(), this.mData, this.mProcess);
        this.mTaskTitleSearch.addActionListener(h);
    }

    private List getOutComes() {
        ArrayList<String> l = new ArrayList<String>();
        String data = this.mOutComes.getText();
        String[] choices = data.split(OUTCOME_SEPARATOR);
        for (int i = 0; i < choices.length; ++i) {
            l.add(choices[i]);
        }
        return l;
    }

    private void setOutComes(Outcomes pOutComes) {
        if (pOutComes == null) {
            return;
        }
        this.mOutComesList.clear();
        List list = pOutComes.getOutcome();
        this.mOutComesList.addAll(list);
        StringBuffer buffer = new StringBuffer();
        Iterator iter = this.mOutComesList.iterator();
        while (iter.hasNext()) {
            buffer.append((String)iter.next());
            buffer.append(OUTCOME_SEPARATOR);
        }
        this.mOutComes.setText(buffer.toString());
    }

    private void loadDataIntoControls(UserTask pUT, BPELProject project) {
        if (pUT == null) {
            return;
        }
        UserTaskConfigModel configModel = pUT.getUserTaskConfigModel(project);
        UserTaskRoutingSlipModel routingSlipModel = pUT.getUserTaskRoutingSlipModel(project);
        if (configModel != null) {
            String name = configModel.getName();
            this.mWorkFlowName.setText(name);
            this.loadOutcomes(configModel);
        }
        this.loadDurationData(pUT, project);
        this.loadTitle();
    }

    private void loadTitle() {
        Iterator list = this.mData.getActivities();
        if (list.hasNext()) {
            Sequence seq = (Sequence)list.next();
            Iterator it = seq.getActivities();
            while (it.hasNext()) {
                Activity activity = (Activity)it.next();
                if (!(activity instanceof Assign)) continue;
                boolean bExistingRule = false;
                List copyRules = ((Assign)activity).getCopyRules();
                for (Copy copy : copyRules) {
                    if (!copy.getTo().getQuery().trim().equalsIgnoreCase("/task:task/task:title")) continue;
                    this.mTaskTitle.setText(copy.getFrom().getExpression());
                }
            }
        }
    }

    private void loadDurationData(RenewalPolicy policy) {
        DurationData data = null;
        try {
            int renewalCount = Integer.parseInt(policy.getNumberOfTimesRenewed().getValue());
            this.mDurationData = data = new DurationData(renewalCount);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void loadDurationData(EscalationPolicy policy) {
        DurationData data = null;
        ArrayList<String> l = new ArrayList<String>();
        l.add("SuperMan");
        l.add("Batman");
        l.add("Dilbert");
        try {
            int escNum = Integer.parseInt(policy.getNumberOfTimesEscalated().getValue());
            this.mDurationData = data = new DurationData(escNum, policy.getTitleOfLastUser().getValue(), l);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
    }

    private void loadDurationData(UserTask pUT, BPELProject project) {
        if (pUT == null) {
            return;
        }
        try {
            UserTaskConfigModel configModel = pUT.getUserTaskConfigModel(project);
            UserTaskRoutingSlipModel routingSlipModel = pUT.getUserTaskRoutingSlipModel(project);
            if (routingSlipModel != null) {
                RenewalPolicy renewalPolicy = routingSlipModel.getRenewalPolicy();
                EscalationPolicy escalationPolicy = routingSlipModel.getEscalationPolicy();
                if (renewalPolicy != null) {
                    this.loadDurationData(renewalPolicy);
                    this.mDurationPanel.setDuration(renewalPolicy.getRenewalDuration());
                } else if (escalationPolicy != null) {
                    this.loadDurationData(escalationPolicy);
                    this.mDurationPanel.setDuration(escalationPolicy.getRenewalDuration());
                } else {
                    this.mDurationData = new DurationData();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadOutcomes(UserTaskConfigModel configModel) {
        if (configModel == null) {
            return;
        }
        Outcomes outcomes = configModel.getOutcomes();
        if (outcomes == null) {
            return;
        }
        List l = outcomes.getOutcome();
        if (l == null) {
            return;
        }
        this.mOutComesList.clear();
        this.mOutComesList.addAll(l);
        this.loadOutComesIntoControl(this.mOutComesList);
    }

    private void loadOutComesIntoControl(List pOutcomes) {
        if (pOutcomes == null) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        Iterator iter = pOutcomes.iterator();
        while (iter.hasNext()) {
            Outcome o = (Outcome)iter.next();
            buffer.append(o.getValue());
            if (!iter.hasNext()) continue;
            buffer.append(OUTCOME_SEPARATOR);
        }
        this.mOutComes.setText(buffer.toString());
    }

    public void saveChanges(BPELProject project) {
        this.saveName(project);
        this.saveTitle();
        this.saveOutcomes(project);
        this.saveDurationData(project);
    }

    private void saveName(BPELProject project) {
        this.mData.getUserTaskConfigModel(project).setName(this.mWorkFlowName.getText());
    }

    private void saveTitle() {
    }

    private void saveOutcomes(BPELProject project) {
        String outcomesText = this.mOutComes.getText();
        String[] outcomes = outcomesText.split(OUTCOME_SEPARATOR);
        if (outcomes == null) {
            return;
        }
        UserTaskConfigModel model = this.mData.getUserTaskConfigModel(project);
        if (model == null) {
            model = new UserTaskConfigModelImpl();
        }
        this.mOutComesList.clear();
        for (int i = 0; i < outcomes.length; ++i) {
            OutcomeImpl o = new OutcomeImpl();
            o.setValue(outcomes[i]);
            this.mOutComesList.add(o);
        }
        Outcomes outcomesObj = model.getOutcomes();
        outcomesObj.setOutcome(this.mOutComesList);
    }

    private void saveDurationData(BPELProject project) {
        UserTaskRoutingSlipModel model = this.mData.getUserTaskRoutingSlipModel(project);
        if (model == null) {
            return;
        }
        String d = this.mDurationPanel.getDuration();
        if (this.mDurationData == null) {
            model.setEscalationPolicy(null);
            model.setRenewalPolicy(null);
        } else {
            DurationData.ActionAfterDuration a = this.mDurationData.getActionAfterDuration();
            model.setEscalationPolicy(null);
            model.setRenewalPolicy(null);
            if (a instanceof DurationData.ExpirationTaskAction) {
                DurationData.ExpirationTaskAction e = (DurationData.ExpirationTaskAction)a;
            } else if (a instanceof DurationData.EscalateTaskAction) {
                DurationData.EscalateTaskAction e = (DurationData.EscalateTaskAction)a;
                EscalationPolicy esc = RoutingSlipFactory.getInstance().createEscalationPolicy();
                Parameter p1 = RoutingSlipFactory.getInstance().createIntegerParameter(e.getMaximumEscalationLevels());
                esc.setNumberOfTimesEscalated(p1);
                Parameter p2 = RoutingSlipFactory.getInstance().createStringParameter(e.getHighestApproverTitle());
                esc.setTitleOfLastUser(p2);
                esc.setRenewalDuration(d);
                model.setEscalationPolicy(esc);
            } else if (a instanceof DurationData.RenewTaskAction) {
                DurationData.RenewTaskAction e = (DurationData.RenewTaskAction)a;
                RenewalPolicy r = RoutingSlipFactory.getInstance().createRenewalPoicy();
                Parameter p1 = RoutingSlipFactory.getInstance().createIntegerParameter(e.getMaximumRenewals());
                r.setNumberOfTimesRenewed(p1);
                r.setRenewalDuration(d);
                model.setRenewalPolicy(r);
            }
        }
    }

    class TaskTitleHandler
    implements ActionListener {
        private BPELGraphPane mPane = null;
        private String mName = null;
        private BPELProject mProject = null;
        private Process mProcess = null;
        private UserTask mUserTask = null;
        private XPathEditorPane pane = new XPathEditorPane();

        public TaskTitleHandler(BPELGraphPane pGraphPane, BPELProject project, UserTask pUT, Process process) {
            this.mPane = pGraphPane;
            this.mProject = project;
            this.mProcess = process;
            this.mUserTask = pUT;
        }

        private Variable getVariable() {
            Variable v = null;
            Variables variables = this.mProcess.getVariables();
            List l = variables.getVariables();
            for (Variable _v : l) {
                if (!_v.getName().equals(this.mUserTask.getVariableName())) continue;
                v = _v;
                break;
            }
            return v;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Variable v = this.getVariable();
            if (v == null) {
                return;
            }
            BPELXmlModel mainModel = this.mPane.getBPELXmlModel();
            UserTaskCallBack u = new UserTaskCallBack(mainModel, (Activity)this.mUserTask, v);
            this.pane.initializeEditorPane((VariableDataCallBack)u, "", (NamespaceResolver)new BpelNSResolver(this.mProcess));
            this.pane.setEnabled(true);
            VariablePickerPanel p = new VariablePickerPanel(this.mPane, u, (NamespaceResolver)new BpelNSResolver(this.mProcess));
            VariableExpressionBuilderPicker picker = new VariableExpressionBuilderPicker(p, (Activity)this.mUserTask);
            ExpressionBuilderPicker[] pickers = new ExpressionBuilderPicker[]{picker};
            XPathEditorPane pane = new XPathEditorPane();
            pane.initializeDocument();
            pane.initializeEditorPane((VariableDataCallBack)u, "", (NamespaceResolver)new BpelNSResolver(this.mProcess), false);
            ExpressionBuilder dlg = new ExpressionBuilder(GraphUtils.getFrame((Component)((Object)this.mPane)), (JTextComponent)pane, pickers);
            dlg.display();
        }

        public String getName() {
            return this.mName;
        }
    }
}

