/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.util.ResourceUtils;
import oracle.tip.tools.ide.common.ui.JNumericField;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors.DurationData;

public class DurationDetailsPanel
extends JPanel {
    private static final String EXPIRE_TASK = "Expire Task";
    private static final String RENEW_TASK_FOR_CURRENT_APPROVER = "Renew task for Current Approver";
    private static final String MAXIMUM_RENEWALS = "Maximum Renewals";
    private static final String ESCALATE_TASK_TO_NEXT_APPROVER = "Escalate Task to Next Approver";
    private static final String MAXIMUM_ESCALATION_LEVELS = "Maximum Escalation Levels";
    private static final String HIGHEST_APPROVER_TITLE = "Highest Approver Title:";
    private static final String ACTION_AFTER_DURATION = "Action After Duration";
    private static final String EXPIRE_TASK_COMMAND = "Expire Task";
    private static final String RENEW_TASK_COMMAND = "Renew Task";
    private static final String ESCALATE_TASK_COMMAND = "Escalate Task";
    private JRadioButton mExpireTaskButton = null;
    private JRadioButton mRenewTaskButton = null;
    private JRadioButton mEscalateTaskButton = null;
    private JNumericField mRenewalField = null;
    private JNumericField mEscalationLevels = null;
    private JComboBox mApproverTitle = null;
    private JPanel mExpireTaskPanel = null;
    private JPanel mRenewTaskPanel = null;
    private JPanel mEscalateTaskPanel = null;
    private DurationData mData = null;
    private Insets insets = new Insets(2, 2, 2, 2);
    private List mComponentCollection = new ArrayList();
    private TaskDataHandler mCurrentTaskDataHandler = null;
    private SelectAction mSelectAction = null;
    private ButtonGroup mButtonGroup = new ButtonGroup();

    public DurationDetailsPanel() {
        this.initializeComponents();
        this.layoutComponents();
    }

    public DurationDetailsPanel(DurationData pData) {
        this();
        this.setData(pData);
    }

    public DurationData getData() {
        this.mData.setActionAfterDuration(this.mCurrentTaskDataHandler.getTaskData());
        return this.mData;
    }

    private void initializeComponents() {
        this.mComponentCollection.clear();
        this.mExpireTaskButton = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this.mExpireTaskButton, (String)"Expire Task");
        this.mRenewTaskButton = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this.mRenewTaskButton, (String)RENEW_TASK_FOR_CURRENT_APPROVER);
        this.mEscalateTaskButton = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this.mEscalateTaskButton, (String)ESCALATE_TASK_TO_NEXT_APPROVER);
        this.mButtonGroup.add(this.mExpireTaskButton);
        this.mButtonGroup.add(this.mRenewTaskButton);
        this.mButtonGroup.add(this.mEscalateTaskButton);
        this.mRenewalField = new JNumericField(5);
        this.mEscalationLevels = new JNumericField(5);
        this.mApproverTitle = new JComboBox();
        this.mApproverTitle.setEditable(true);
        this.mExpireTaskPanel = new ExpirationDataHandler();
        this.mRenewTaskPanel = new RenewTaskDataHandler();
        this.mEscalateTaskPanel = new EscalateTaskDataHandler();
        this.mExpireTaskButton.setActionCommand("Expire Task");
        this.mRenewTaskButton.setActionCommand(RENEW_TASK_COMMAND);
        this.mEscalateTaskButton.setActionCommand(ESCALATE_TASK_COMMAND);
        this.initializeSelections();
    }

    private void initializeSelections() {
        this.mSelectAction = new SelectAction();
        this.mSelectAction.addSelectionListener((SelectionListener)((Object)this.mExpireTaskPanel), "Expire Task");
        this.mSelectAction.addSelectionListener((SelectionListener)((Object)this.mRenewTaskPanel), RENEW_TASK_COMMAND);
        this.mSelectAction.addSelectionListener((SelectionListener)((Object)this.mEscalateTaskPanel), ESCALATE_TASK_COMMAND);
        this.mExpireTaskButton.addActionListener(this.mSelectAction);
        this.mRenewTaskButton.addActionListener(this.mSelectAction);
        this.mEscalateTaskButton.addActionListener(this.mSelectAction);
        Iterator iter = this.mSelectAction.getSelectionListeners().iterator();
        while (iter.hasNext()) {
            ((SelectionListener)iter.next()).handleSelection(false);
        }
    }

    private void layoutComponents() {
        GridBagLayout gl = new GridBagLayout();
        this.setLayout(gl);
        int x = 0;
        int y = 0;
        Component topStrut = Box.createVerticalStrut(25);
        gl.setConstraints(topStrut, new GridBagConstraints(x, y, 0, 1, 0.0, 0.0, 21, 0, this.insets, 0, 0));
        this.add(topStrut);
        x = 0;
        JMultiLineLabel label = new JMultiLineLabel(ACTION_AFTER_DURATION);
        gl.setConstraints((Component)label, new GridBagConstraints(x, ++y, 0, 1, 1.0, 0.0, 21, 2, new Insets(2, 15, 2, 15), 0, 0));
        this.add((Component)label);
        x = 0;
        Component secondStrut = Box.createVerticalStrut(16);
        gl.setConstraints(secondStrut, new GridBagConstraints(x, ++y, 0, 1, 1.0, 0.0, 21, 2, this.insets, 0, 0));
        this.add(secondStrut);
        x = 0;
        gl.setConstraints(this.mExpireTaskPanel, new GridBagConstraints(x, ++y, 0, 1, 1.0, 0.0, 21, 2, new Insets(2, 15, 2, 15), 0, 0));
        this.add(this.mExpireTaskPanel);
        x = 0;
        gl.setConstraints(this.mRenewTaskPanel, new GridBagConstraints(x, ++y, 0, 1, 1.0, 0.0, 21, 2, new Insets(2, 15, 2, 15), 0, 0));
        this.add(this.mRenewTaskPanel);
        gl.setConstraints(this.mEscalateTaskPanel, new GridBagConstraints(x, ++y, 0, -1, 1.0, 0.0, 21, 2, new Insets(2, 15, 2, 15), 0, 0));
        this.add(this.mEscalateTaskPanel);
        x = 0;
        Component bottomStrut = Box.createVerticalStrut(10);
        gl.setConstraints(bottomStrut, new GridBagConstraints(x, ++y, 0, 0, 1.0, 0.1, 21, 1, this.insets, 0, 0));
        this.add(bottomStrut);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.equateWidths(this.mComponentCollection);
    }

    public void setData(final DurationData pData) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                DurationDetailsPanel.this.mData = pData;
                DurationDetailsPanel.this.initComponentsWithData();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    private void initComponentsWithData() {
        DurationData.ActionAfterDuration a = this.mData.getActionAfterDuration();
        SelectionListener l = null;
        if (a == null || a instanceof DurationData.ExpirationTaskAction) {
            this.mExpireTaskButton.setSelected(true);
            l = (SelectionListener)((Object)this.mExpireTaskPanel);
        } else if (a instanceof DurationData.RenewTaskAction) {
            this.mRenewTaskButton.setSelected(true);
            l = (SelectionListener)((Object)this.mRenewTaskPanel);
        } else if (a instanceof DurationData.EscalateTaskAction) {
            this.mEscalateTaskButton.setSelected(true);
            l = (SelectionListener)((Object)this.mEscalateTaskPanel);
        }
        if (l != null) {
            this.mSelectAction.select(l);
            ((TaskDataHandler)((Object)l)).setTaskData(a);
        }
    }

    public static void main(String[] argv) {
        String[] pNames = new String[]{"Some guy", "Another guy", "Yet another", "B"};
        JFrame dialog = new JFrame();
        dialog.setDefaultCloseOperation(3);
        List<Object> list = new ArrayList(pNames.length);
        list = Arrays.asList(pNames);
        DurationData d = new DurationData(2, "B", list);
        DurationDetailsPanel panel = new DurationDetailsPanel();
        dialog.setContentPane(panel);
        panel.setData(d);
        dialog.setSize(400, 400);
        dialog.setVisible(true);
    }

    private void equateWidths(List componentList) {
        int width = -1;
        for (JComponent component : componentList) {
            if (width >= component.getPreferredSize().width) continue;
            width = component.getPreferredSize().width;
        }
        for (JComponent component : componentList) {
            Dimension d = component.getPreferredSize();
            d.width = width;
            component.setPreferredSize(d);
        }
    }

    public class EscalateTaskDataHandler
    extends JPanel
    implements TaskDataHandler,
    SelectionListener {
        private DurationData.EscalateTaskAction mData = null;
        private JLabel label1 = null;
        private JLabel label2 = null;

        public EscalateTaskDataHandler() {
            this.layoutComponents();
            this.mData = new DurationData.EscalateTaskAction();
        }

        @Override
        public void handleSelection(boolean pIsSelected) {
            this.label1.setEnabled(pIsSelected);
            this.label2.setEnabled(pIsSelected);
            DurationDetailsPanel.this.mEscalationLevels.setEnabled(pIsSelected);
            DurationDetailsPanel.this.mApproverTitle.setEnabled(pIsSelected);
        }

        private void layoutComponents() {
            GridBagLayout gl = new GridBagLayout();
            this.setLayout(gl);
            int x = 0;
            int y = 0;
            gl.setConstraints(DurationDetailsPanel.this.mEscalateTaskButton, new GridBagConstraints(x, y, 0, 1, 1.0, 0.0, 21, 2, DurationDetailsPanel.this.insets, 0, 0));
            this.add(DurationDetailsPanel.this.mEscalateTaskButton);
            x = 0;
            Component strut = Box.createHorizontalStrut(16);
            gl.setConstraints(strut, new GridBagConstraints(x, ++y, 1, 1, 0.0, 0.0, 21, 0, DurationDetailsPanel.this.insets, 0, 0));
            this.add(strut);
            this.label1 = new JLabel();
            gl.setConstraints(this.label1, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 21, 0, DurationDetailsPanel.this.insets, 0, 0));
            this.add(this.label1);
            ResourceUtils.resLabel((JLabel)this.label1, (Component)DurationDetailsPanel.this.mEscalationLevels, (String)DurationDetailsPanel.MAXIMUM_ESCALATION_LEVELS);
            if (!DurationDetailsPanel.this.mComponentCollection.contains(this.label1)) {
                DurationDetailsPanel.this.mComponentCollection.add(this.label1);
            }
            gl.setConstraints((Component)DurationDetailsPanel.this.mEscalationLevels, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 21, 0, DurationDetailsPanel.this.insets, 0, 0));
            this.add((Component)DurationDetailsPanel.this.mEscalationLevels);
            x = 0;
            Component strut1 = Box.createHorizontalStrut(16);
            gl.setConstraints(strut1, new GridBagConstraints(x, ++y, 1, 1, 0.0, 0.0, 21, 0, DurationDetailsPanel.this.insets, 0, 0));
            this.add(strut1);
            this.label2 = new JLabel();
            gl.setConstraints(this.label2, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 21, 0, DurationDetailsPanel.this.insets, 0, 0));
            this.add(this.label2);
            ResourceUtils.resLabel((JLabel)this.label2, (Component)DurationDetailsPanel.this.mApproverTitle, (String)DurationDetailsPanel.HIGHEST_APPROVER_TITLE);
            if (!DurationDetailsPanel.this.mComponentCollection.contains(this.label2)) {
                DurationDetailsPanel.this.mComponentCollection.add(this.label2);
            }
            gl.setConstraints(DurationDetailsPanel.this.mApproverTitle, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 21, 0, DurationDetailsPanel.this.insets, 0, 0));
            this.add(DurationDetailsPanel.this.mApproverTitle);
        }

        @Override
        public void setTaskData(DurationData.ActionAfterDuration pData) {
            if (pData instanceof DurationData.EscalateTaskAction) {
                this.mData = (DurationData.EscalateTaskAction)pData;
                DurationDetailsPanel.this.mEscalationLevels.setInt(this.mData.getMaximumEscalationLevels());
                int size = this.mData.getListOfApprovers().size();
                DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(this.mData.getListOfApprovers().toArray(new String[size]));
                DurationDetailsPanel.this.mApproverTitle.setModel(model);
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        DurationDetailsPanel.this.mEscalateTaskButton.setSelected(true);
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    r.run();
                } else {
                    SwingUtilities.invokeLater(r);
                }
            }
        }

        @Override
        public DurationData.ActionAfterDuration getTaskData() {
            this.mData.setMaximumEscalationLevels(DurationDetailsPanel.this.mEscalationLevels.getInt());
            this.mData.setHighestApproverTitle((String)DurationDetailsPanel.this.mApproverTitle.getSelectedItem());
            return this.mData;
        }
    }

    public class RenewTaskDataHandler
    extends JPanel
    implements TaskDataHandler,
    SelectionListener {
        DurationData.RenewTaskAction mData = null;
        private JLabel mLabel = null;

        public RenewTaskDataHandler() {
            this.layoutComponents();
            this.mData = new DurationData.RenewTaskAction();
        }

        @Override
        public void handleSelection(boolean pIsSelected) {
            this.mLabel.setEnabled(pIsSelected);
            DurationDetailsPanel.this.mRenewalField.setEnabled(pIsSelected);
        }

        private void layoutComponents() {
            GridBagLayout gl = new GridBagLayout();
            this.setLayout(gl);
            int x = 0;
            int y = 0;
            gl.setConstraints(DurationDetailsPanel.this.mRenewTaskButton, new GridBagConstraints(x, y, 0, 1, 1.0, 0.0, 21, 2, DurationDetailsPanel.this.insets, 0, 0));
            this.add(DurationDetailsPanel.this.mRenewTaskButton);
            x = 0;
            Component strut = Box.createHorizontalStrut(16);
            gl.setConstraints(strut, new GridBagConstraints(x, ++y, 1, 1, 0.0, 0.0, 21, 0, DurationDetailsPanel.this.insets, 0, 0));
            this.add(strut);
            this.mLabel = new JLabel();
            gl.setConstraints(this.mLabel, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 21, 0, DurationDetailsPanel.this.insets, 0, 0));
            this.add(this.mLabel);
            ResourceUtils.resLabel((JLabel)this.mLabel, (Component)DurationDetailsPanel.this.mRenewalField, (String)DurationDetailsPanel.MAXIMUM_RENEWALS);
            if (!DurationDetailsPanel.this.mComponentCollection.contains(this.mLabel)) {
                DurationDetailsPanel.this.mComponentCollection.add(this.mLabel);
            }
            gl.setConstraints((Component)DurationDetailsPanel.this.mRenewalField, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 21, 0, DurationDetailsPanel.this.insets, 0, 0));
            this.add((Component)DurationDetailsPanel.this.mRenewalField);
        }

        @Override
        public void setTaskData(DurationData.ActionAfterDuration pData) {
            if (pData instanceof DurationData.RenewTaskAction) {
                this.mData = (DurationData.RenewTaskAction)pData;
                DurationDetailsPanel.this.mRenewalField.setText(new Integer(this.mData.getMaximumRenewals()).toString());
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        DurationDetailsPanel.this.mRenewTaskButton.setSelected(true);
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    r.run();
                } else {
                    SwingUtilities.invokeLater(r);
                }
            }
        }

        @Override
        public DurationData.ActionAfterDuration getTaskData() {
            this.mData.setMaximumRenewals(DurationDetailsPanel.this.mRenewalField.getInt());
            return this.mData;
        }
    }

    public class ExpirationDataHandler
    extends JPanel
    implements TaskDataHandler,
    SelectionListener {
        private DurationData.ExpirationTaskAction mData = null;

        public ExpirationDataHandler() {
            this.layoutComponents();
            this.mData = new DurationData.ExpirationTaskAction();
        }

        @Override
        public void handleSelection(boolean pIsSelected) {
        }

        private void layoutComponents() {
            GridBagLayout gl = new GridBagLayout();
            this.setLayout(gl);
            int x = 0;
            int y = 0;
            gl.setConstraints(DurationDetailsPanel.this.mExpireTaskButton, new GridBagConstraints(x, y, 0, 1, 1.0, 0.0, 21, 2, DurationDetailsPanel.this.insets, 0, 0));
            this.add(DurationDetailsPanel.this.mExpireTaskButton);
        }

        @Override
        public void setTaskData(DurationData.ActionAfterDuration pData) {
            if (pData instanceof DurationData.ExpirationTaskAction) {
                this.mData = (DurationData.ExpirationTaskAction)pData;
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        DurationDetailsPanel.this.mExpireTaskButton.setSelected(true);
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    r.run();
                } else {
                    SwingUtilities.invokeLater(r);
                }
            }
        }

        @Override
        public DurationData.ActionAfterDuration getTaskData() {
            return this.mData;
        }
    }

    static interface SelectionListener {
        public void handleSelection(boolean var1);
    }

    static interface TaskDataHandler {
        public void setTaskData(DurationData.ActionAfterDuration var1);

        public DurationData.ActionAfterDuration getTaskData();
    }

    class SelectAction
    extends AbstractAction {
        Map map = new HashMap();

        SelectAction() {
        }

        public void addSelectionListener(SelectionListener pListener, String pCommand) {
            this.map.put(pCommand, pListener);
        }

        public void removeSelectionListener(SelectionListener pListener) {
            Set keys = this.map.keySet();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                String command = (String)iter.next();
                SelectionListener listener = (SelectionListener)this.map.get(command);
                if (!pListener.equals(listener)) continue;
                iter.remove();
                break;
            }
        }

        public Collection getSelectionListeners() {
            return this.map.values();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            SelectionListener l = (SelectionListener)this.map.get(command);
            this.select(l);
        }

        public void select(SelectionListener pListener) {
            if (pListener == null) {
                return;
            }
            for (SelectionListener s : this.map.values()) {
                s.handleSelection(s.equals(pListener));
            }
            TaskDataHandler t = (TaskDataHandler)((Object)pListener);
            DurationDetailsPanel.this.mCurrentTaskDataHandler = t;
        }
    }
}

