/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.ide.util.ResourceUtils;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors.CompletionDetailsData;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class CompletionDetailsPanel
extends JPanel {
    private static final String OUTCOMES = "&Outcomes:";
    private static final String ROUTING_CONDITION = "&Routing Condition:";
    private static final String DIRECTIONS = "Specify outcomes or conditions that will result in the task completing early.";
    private static final String PROTOTYPE = "ABCDEDFGHAAAAAAAAAAAAAAAAAAA";
    private JList mOutcomes = null;
    private JButton mRoutingLookupButton = null;
    private JTextArea mRoutingArea = null;
    private List mLengthsList = new ArrayList();
    private CompletionDetailsData mData = null;

    public CompletionDetailsPanel() {
        this.initializeComponents();
        this.layoutComponents();
    }

    private void initializeComponents() {
        this.mOutcomes = new JList(new DefaultListModel());
        for (int i = 0; i < 5; ++i) {
            ((DefaultListModel)this.mOutcomes.getModel()).addElement(i + "");
        }
        this.mRoutingLookupButton = UIHelper.createModelerButton((Icon)ImageCache.getIcon("expressionbuilder"));
        this.mRoutingArea = new JTextArea();
        this.mRoutingArea.setRows(5);
        ListSelectionModel lsm = this.mOutcomes.getSelectionModel();
        lsm.setSelectionMode(2);
    }

    private void layoutComponents() {
        BoxLayout bl = new BoxLayout(this, 1);
        this.setLayout(bl);
        JPanel directionsPanel = this.createDirectionsPanel();
        directionsPanel.setBorder(BorderFactory.createEmptyBorder(15, 10, 10, 10));
        this.add(directionsPanel);
        this.fixSize(directionsPanel);
        JPanel outcomesPanel = this.createOutcomesPanel();
        outcomesPanel.setBorder(BorderFactory.createEmptyBorder(15, 10, 10, 10));
        this.add(outcomesPanel);
        this.fixSize(outcomesPanel);
        JPanel routingPanel = this.createRoutingPanel();
        routingPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add(routingPanel);
        this.fixSize(routingPanel);
        this.equateComponentWidths(this.mLengthsList);
    }

    private void fixSize(JComponent pComponent) {
        pComponent.setMaximumSize(new Dimension(Short.MAX_VALUE, pComponent.getPreferredSize().height));
    }

    private JPanel createOutcomesPanel() {
        GridBagLayout gl = new GridBagLayout();
        JPanel panel = new JPanel(gl);
        int x = 0;
        int y = 0;
        JLabel label = new JLabel();
        gl.setConstraints(label, new GridBagConstraints(x, y, 2, 1, 1.0, 0.0, 21, 0, new Insets(1, 1, 1, 1), 0, 0));
        panel.add(label);
        JScrollPane sp = new JScrollPane(this.mOutcomes);
        gl.setConstraints(sp, new GridBagConstraints(x, ++y, 1, 0, 1.0, 1.0, 21, 0, new Insets(1, 1, 1, 1), 0, 0));
        panel.add(sp);
        this.mOutcomes.setVisibleRowCount(5);
        this.mOutcomes.setPrototypeCellValue(PROTOTYPE);
        JPanel p = new JPanel();
        gl.setConstraints(p, new GridBagConstraints(++x, y, 1, 0, 1.0, 1.0, 21, 1, new Insets(1, 1, 1, 1), 0, 0));
        panel.add(p);
        ResourceUtils.resLabel((JLabel)label, (Component)this.mOutcomes, (String)OUTCOMES);
        return panel;
    }

    private JPanel createRoutingPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JLabel label = new JLabel();
        panel.add((Component)label, "North");
        JPanel innerPanel = new JPanel();
        BoxLayout bl = new BoxLayout(innerPanel, 0);
        innerPanel.setLayout(bl);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        buttonPanel.add(this.mRoutingLookupButton);
        buttonPanel.add(Box.createVerticalGlue());
        innerPanel.add(new JScrollPane(this.mRoutingArea));
        innerPanel.add(Box.createHorizontalStrut(5));
        innerPanel.add(buttonPanel);
        panel.add((Component)innerPanel, "Center");
        ResourceUtils.resLabel((JLabel)label, (Component)this.mRoutingArea, (String)ROUTING_CONDITION);
        this.mLengthsList.add(this.mRoutingArea);
        return panel;
    }

    private JPanel createDirectionsPanel() {
        JPanel panel = new JPanel();
        BoxLayout bl = new BoxLayout(panel, 0);
        panel.setLayout(bl);
        MultiLineLabel label = new MultiLineLabel(DIRECTIONS);
        this.mLengthsList.add(label);
        panel.add((Component)label);
        return panel;
    }

    private void equateComponentWidths(List pListOfComponents) {
        int width = -1;
        for (JComponent c : pListOfComponents) {
            if (c.getPreferredSize().width < width) continue;
            width = c.getPreferredSize().width;
        }
        for (JComponent c : pListOfComponents) {
            Dimension d = c.getPreferredSize();
            d.width = width;
            c.setPreferredSize(d);
        }
    }

    public static void main(String[] argv) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        CompletionDetailsPanel panel = new CompletionDetailsPanel();
        frame.getContentPane().add(panel);
        frame.setSize(500, 400);
        frame.setVisible(true);
    }

    public void setData(CompletionDetailsData pData) {
        this.mData = pData;
        this.updateData();
    }

    private void updateData() {
        if (this.mData == null) {
            return;
        }
        DefaultListModel model = (DefaultListModel)this.mOutcomes.getModel();
        model.clear();
        if (this.mData.getCompleteList() != null) {
            for (Object obj : this.mData.getCompleteList()) {
                model.addElement(obj);
            }
        }
        int[] selections = new int[this.mData.getOutcomes().size()];
        if (this.mData.getOutcomes() != null) {
            for (int i = 0; i < this.mData.getOutcomes().size(); ++i) {
                Object obj = this.mData.getOutcomes().get(i);
                selections[i] = this.mData.getCompleteList().indexOf(obj);
            }
        }
        this.mOutcomes.setSelectedIndices(selections);
        if (this.mData.getRoutingCondition() != null) {
            this.mRoutingArea.setText(this.mData.getRoutingCondition());
        }
    }

    public CompletionDetailsData getData() {
        Object[] objs = this.mOutcomes.getSelectedValues();
        ArrayList<Object> l = new ArrayList<Object>();
        if (objs != null) {
            for (int i = 0; i < objs.length; ++i) {
                l.add(objs[i]);
            }
        }
        this.mData.setOutcomes(l);
        this.mData.setRoutingCondition(this.mRoutingArea.getText());
        return this.mData;
    }
}

