/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import oracle.ide.util.ResourceUtils;
import oracle.tip.tools.ide.common.ui.GenericDialog;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.IHelpUtil;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors.CompletionDetailsData;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors.CompletionDetailsPanel;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors.ResourceDetailsData;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors.ResourceDetailsPanel;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;
import oracle.tip.tools.ide.workflow.util.WorkFlowHelpUtil;

public class AdvancedGeneralEditor
extends JPanel {
    private static final String OWNER = "Owner:";
    private static final String SPECIFY_RESOURCE_LOCATION = "Specify workflow resource name and &location.";
    private static final String SPECIFY_EARLY_TASK_COMPLETION = "Specify early task &completion conditions.";
    private static final String SPECIFY_SIGNATURE_POLICY = "Specify workflow signature &policy.";
    private static final String SPECIFY_SYSTEM_ACTIONS = "Specify workflow system &actions.";
    private static final String SPECIFY_ERROR_ASSIGNMENT = "Specify workflow &error assignment.";
    private static final String SPECIFY_CALLBACKS = "Specify &workflow callbacks.";
    private static final String CONFIGURE_RESOURCE = "Configure Resource...";
    private static final String CONFIGURE_COMPLETION = "Configure Completion...";
    private static final String CONFIGURE_POLICY = "Configure Policy...";
    private static final String CONFIGURE_ACTIONS = "Configure Actions...";
    private static final String CONFIGURE_ASSIGNMENT = "Configure Assignment...";
    private static final String CONFIGURE_CALLBACKS = "Configure Callbacks...";
    private static final String RESOURCE_DETAILS = "Resource Details";
    private static final String COMPLETION_DETAILS = "Early Completion Details";
    private JTextField mOwnerField = null;
    private JButton mResourceButton = null;
    private JButton mCompletionButton = null;
    private JButton mPolicyButton = null;
    private JButton mActionsButton = null;
    private JButton mAssignmentButton = null;
    private JButton mCallbacksButton = null;
    private JButton mTorchLightButton = null;
    private JButton mLookupButton = null;
    private ResourceAction mResourceAction = new ResourceAction();
    private CompletionAction mCompletionAction = new CompletionAction();
    private PolicyAction mPolicyAction = new PolicyAction();
    private ActionsAction mActionsAction = new ActionsAction();
    private AssignmentsAction mAssignmentsAction = new AssignmentsAction();
    private CallbacksAction mCallbacksAction = new CallbacksAction();
    private List mLabelsList = new ArrayList();
    private List mButtonsList = new ArrayList();
    private List mPanelsList = new ArrayList();

    public AdvancedGeneralEditor() {
        this.initializeComponents();
        this.layoutComponents();
    }

    private void initializeComponents() {
        this.mOwnerField = new JTextField();
        this.mResourceButton = new JButton(this.mResourceAction);
        this.mResourceButton.setHorizontalAlignment(10);
        this.mCompletionButton = new JButton(this.mCompletionAction);
        this.mCompletionButton.setHorizontalAlignment(10);
        this.mPolicyButton = new JButton(this.mPolicyAction);
        this.mPolicyButton.setHorizontalAlignment(10);
        this.mActionsButton = new JButton(this.mActionsAction);
        this.mActionsButton.setHorizontalAlignment(10);
        this.mAssignmentButton = new JButton(this.mAssignmentsAction);
        this.mAssignmentButton.setHorizontalAlignment(10);
        this.mCallbacksButton = new JButton(this.mCallbacksAction);
        this.mCallbacksButton.setHorizontalAlignment(10);
        this.mTorchLightButton = UIHelper.createBrowseButton((String)"browse");
        this.mLookupButton = UIHelper.createModelerButton((Icon)ImageCache.getIcon("expressionbuilder"));
    }

    private void layoutComponents() {
        this.prepareMeat(this);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    private void prepareMeat(JPanel panel) {
        BoxLayout bl = new BoxLayout(panel, 1);
        panel.setLayout(bl);
        Border emptyBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        JPanel ownerPanel = this.prepareOwnerPanel();
        panel.add(ownerPanel);
        ownerPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 15, 5));
        ownerPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, ownerPanel.getPreferredSize().height));
        JPanel locationPanel = this.prepareLocationPanel();
        locationPanel.setBorder(emptyBorder);
        panel.add(locationPanel);
        JPanel completionPanel = this.prepareCompletionPanel();
        completionPanel.setBorder(emptyBorder);
        panel.add(completionPanel);
        JPanel policyPanel = this.preparePolicyPanel();
        policyPanel.setBorder(emptyBorder);
        panel.add(policyPanel);
        JPanel actionsPanel = this.prepareSystemActionsPanel();
        actionsPanel.setBorder(emptyBorder);
        panel.add(actionsPanel);
        JPanel assignmentPanel = this.prepareAssignmentPanel();
        assignmentPanel.setBorder(emptyBorder);
        panel.add(assignmentPanel);
        JPanel callbacksPanel = this.prepareCallbacksPanel();
        callbacksPanel.setBorder(emptyBorder);
        panel.add(callbacksPanel);
        this.equateComponentWidths(this.mLabelsList);
        this.equateComponentWidths(this.mButtonsList);
        this.mPanelsList.add(ownerPanel);
        this.mPanelsList.add(locationPanel);
        this.mPanelsList.add(completionPanel);
        this.mPanelsList.add(policyPanel);
        this.mPanelsList.add(actionsPanel);
        this.mPanelsList.add(assignmentPanel);
        this.mPanelsList.add(callbacksPanel);
        this.equateComponentHeight(this.mPanelsList);
    }

    private static JPanel prepareGeneralPanel(String pLabelName, String pButtonName, JButton pButton, List pLabelsList, List pButtonsList) {
        JPanel panel = new JPanel();
        BoxLayout bl = new BoxLayout(panel, 0);
        panel.setLayout(bl);
        JLabel label = new JLabel();
        panel.add(label);
        Component glue = Box.createHorizontalGlue();
        panel.add(glue);
        panel.add(pButton);
        ResourceUtils.resLabel((JLabel)label, (Component)pButton, (String)pLabelName);
        ResourceUtils.resButton((AbstractButton)pButton, (String)pButtonName);
        pLabelsList.add(label);
        pButtonsList.add(pButton);
        return panel;
    }

    private JPanel prepareCallbacksPanel() {
        return AdvancedGeneralEditor.prepareGeneralPanel(SPECIFY_CALLBACKS, CONFIGURE_CALLBACKS, this.mCallbacksButton, this.mLabelsList, this.mButtonsList);
    }

    private JPanel prepareAssignmentPanel() {
        return AdvancedGeneralEditor.prepareGeneralPanel(SPECIFY_ERROR_ASSIGNMENT, CONFIGURE_ASSIGNMENT, this.mAssignmentButton, this.mLabelsList, this.mButtonsList);
    }

    private JPanel prepareSystemActionsPanel() {
        return AdvancedGeneralEditor.prepareGeneralPanel(SPECIFY_SYSTEM_ACTIONS, CONFIGURE_ACTIONS, this.mActionsButton, this.mLabelsList, this.mButtonsList);
    }

    private JPanel prepareCompletionPanel() {
        return AdvancedGeneralEditor.prepareGeneralPanel(SPECIFY_EARLY_TASK_COMPLETION, CONFIGURE_COMPLETION, this.mCompletionButton, this.mLabelsList, this.mButtonsList);
    }

    private JPanel preparePolicyPanel() {
        return AdvancedGeneralEditor.prepareGeneralPanel(SPECIFY_SIGNATURE_POLICY, CONFIGURE_POLICY, this.mPolicyButton, this.mLabelsList, this.mButtonsList);
    }

    private JPanel prepareLocationPanel() {
        return AdvancedGeneralEditor.prepareGeneralPanel(SPECIFY_RESOURCE_LOCATION, CONFIGURE_RESOURCE, this.mResourceButton, this.mLabelsList, this.mButtonsList);
    }

    private JPanel prepareOwnerPanel() {
        GridBagLayout gl = new GridBagLayout();
        JPanel panel = new JPanel(gl);
        Insets insets = new Insets(1, 1, 1, 1);
        int x = 0;
        int y = 0;
        JLabel label = new JLabel();
        gl.setConstraints(label, new GridBagConstraints(x, y, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        panel.add(label);
        gl.setConstraints(this.mOwnerField, new GridBagConstraints(++x, y, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        panel.add(this.mOwnerField);
        gl.setConstraints(this.mTorchLightButton, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        panel.add(this.mTorchLightButton);
        gl.setConstraints(this.mLookupButton, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        panel.add(this.mLookupButton);
        ResourceUtils.resLabel((JLabel)label, (Component)this.mOwnerField, (String)OWNER);
        return panel;
    }

    private void equateComponentWidths(List pListOfComponents) {
        int width = -1;
        for (JComponent c : pListOfComponents) {
            if (c.getPreferredSize().width < width) continue;
            width = c.getPreferredSize().width;
        }
        for (JComponent c : pListOfComponents) {
            Dimension d = c.getPreferredSize();
            d.width = width;
            c.setPreferredSize(d);
        }
    }

    private void equateComponentHeight(List pListOfComponents) {
        int height = -1;
        for (JComponent c : pListOfComponents) {
            if (c.getPreferredSize().height < height) continue;
            height = c.getPreferredSize().height;
        }
        for (JComponent c : pListOfComponents) {
            Dimension d = c.getPreferredSize();
            d.height = height;
            c.setPreferredSize(d);
        }
    }

    public static void main(String[] argv) {
        JFrame frame = new JFrame();
        AdvancedGeneralEditor editor = new AdvancedGeneralEditor();
        frame.getContentPane().add(editor);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }

    private class ResourceAction
    extends AbstractAction {
        private ResourceDetailsData mData = null;

        private ResourceAction() {
        }

        public void setData(ResourceDetailsData pData) {
            this.mData = pData;
        }

        public ResourceDetailsData getData() {
            return this.mData;
        }

        @Override
        public void actionPerformed(ActionEvent pEvent) {
            GenericDialog dialog = new GenericDialog((Frame)UIHelper.getFrame((Component)((Component)pEvent.getSource())));
            ResourceDetailsPanel panel = new ResourceDetailsPanel();
            panel.setBorder(BorderFactory.createEtchedBorder());
            dialog.setContent((JComponent)panel);
            dialog.setModal(true);
            dialog.setTitle(AdvancedGeneralEditor.RESOURCE_DETAILS);
            dialog.setSize(500, 400);
            UIHelper.centerInScreen((Component)dialog);
            dialog.setButtons(28);
            dialog.setHelpProvider((IHelpUtil)WorkFlowHelpUtil.getInstance());
            dialog.setVisible(true);
        }
    }

    private class CompletionAction
    extends AbstractAction {
        CompletionDetailsData mData = new CompletionDetailsData();

        public CompletionAction() {
            ArrayList<String> l = new ArrayList<String>();
            ArrayList<String> lo = new ArrayList<String>();
            String[] strs = new String[]{"None", "ACCEPT", "REJECT", "DEFER", "SOMETHING", "ELSE"};
            for (int i = 0; i < strs.length; ++i) {
                l.add(strs[i]);
                if (i % 2 != 0) continue;
                lo.add(strs[i]);
            }
            this.mData.setCompleteList(l);
            this.mData.setOutcomes(lo);
        }

        public void setData(CompletionDetailsData pData) {
            this.mData = pData;
        }

        public CompletionDetailsData getData() {
            return this.mData;
        }

        @Override
        public void actionPerformed(ActionEvent pEvent) {
            GenericDialog dialog = new GenericDialog((Frame)UIHelper.getFrame((Component)((Component)pEvent.getSource())));
            CompletionDetailsPanel panel = new CompletionDetailsPanel();
            panel.setBorder(BorderFactory.createEtchedBorder());
            panel.setData(this.mData);
            dialog.setContent((JComponent)panel);
            dialog.setModal(true);
            dialog.setTitle(AdvancedGeneralEditor.COMPLETION_DETAILS);
            dialog.setSize(500, 400);
            UIHelper.centerInScreen((Component)dialog);
            dialog.setButtons(28);
            dialog.setHelpProvider((IHelpUtil)WorkFlowHelpUtil.getInstance());
            dialog.setVisible(true);
        }
    }

    private class PolicyAction
    extends AbstractAction {
        private PolicyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent pEvent) {
        }
    }

    private class ActionsAction
    extends AbstractAction {
        private ActionsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent pEvent) {
        }
    }

    private class AssignmentsAction
    extends AbstractAction {
        private AssignmentsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent pEvent) {
        }
    }

    private class CallbacksAction
    extends AbstractAction {
        private CallbacksAction() {
        }

        @Override
        public void actionPerformed(ActionEvent pEvent) {
        }
    }
}

