/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.expressionbuilder.ExpressionBuilder;
import oracle.tip.tools.ide.common.expressionbuilder.ExpressionBuilderPicker;
import oracle.tip.tools.ide.common.expressionbuilders.FunctionsExpressionBuilderPicker;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.utils.NamespaceResolver;
import oracle.tip.tools.ide.common.xpath.editor.XPathEditorPane;
import oracle.tip.tools.ide.common.xpath.editor.util.VariableDataCallBack;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableDataCallBackImpl;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableExpressionBuilderPicker;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariablePickerPanel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.WorkflowEditorContext;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class XPathAction
extends AbstractAction {
    private JTextComponent mComponent = null;
    private WorkflowEditorContext mContext = null;
    private boolean mExclusiveMode = false;

    public XPathAction(JTextComponent pTextComponent, WorkflowEditorContext context) {
        this(pTextComponent, context, false);
    }

    public XPathAction(JTextComponent pTextComponent, WorkflowEditorContext context, boolean pMutuallyExclusiveMode) {
        this.mExclusiveMode = pMutuallyExclusiveMode;
        this.mComponent = pTextComponent;
        this.mContext = context;
        this.putValue("SmallIcon", ImageCache.getIcon("expressionbuilder"));
        this.putValue("ShortDescription", BPELStringTranslator.getString("XPATH_EXPRESSSION_BUILDER", "XPath Expression Builder"));
    }

    @Override
    public void actionPerformed(ActionEvent pEvent) {
        this.handleXPath();
    }

    public void handleXPath() {
        this.handleGraphicBuilderForTextField(this.mComponent, this.mContext.getActivity());
    }

    protected void invokeGraphicalXPathBuilder(XPathEditorPane editorPane, Activity activity) {
        if (this.mComponent == null || this.mContext == null) {
            return;
        }
        NamespaceResolver nsr = this.mContext.getNSResolver();
        if (nsr == null) {
            return;
        }
        BPELGraphPane pane = this.mContext.getGraphPane();
        BPELXmlModel mainModel = pane.getBPELXmlModel();
        VariableDataCallBackImpl dataCallBack = new VariableDataCallBackImpl(mainModel, activity);
        VariablePickerPanel p = new VariablePickerPanel(pane, dataCallBack, nsr);
        VariableExpressionBuilderPicker picker = new VariableExpressionBuilderPicker(p, activity);
        ExpressionBuilderPicker[] pickers = new ExpressionBuilderPicker[]{picker, new FunctionsExpressionBuilderPicker(nsr)};
        XPathEditorPane xpane = new XPathEditorPane();
        xpane.initializeDocument();
        xpane.initializeEditorPane((VariableDataCallBack)dataCallBack, editorPane.getText(), nsr, false);
        ExpressionBuilder dlg = new ExpressionBuilder(GraphUtils.getFrame((Component)((Object)pane)), (JTextComponent)xpane, pickers);
        if (dlg.display() == 0) {
            editorPane.setText(dlg.getExpressionText());
        }
    }

    protected void handleGraphicBuilderForTextField(JTextComponent textField, Activity activity) {
        XPathEditorPane x = new XPathEditorPane();
        String inStr = this.getDelimiterString(textField);
        x.setText(inStr);
        this.invokeGraphicalXPathBuilder(x, activity);
        String s = x.getText();
        if (Helper.hasValue((String)s)) {
            if (!this.mExclusiveMode) {
                textField.setText(this.getText(textField, inStr, "<%" + s + "%>"));
            } else {
                textField.setText(s);
            }
        }
    }

    protected String getDelimiterString(JTextComponent textField) {
        if (this.mExclusiveMode) {
            return textField.getText();
        }
        int caretPos = textField.getCaretPosition();
        String retStr = null;
        try {
            String text = textField.getText();
            int indexOfStartingDelimiter = text.lastIndexOf("<%", caretPos);
            int indexOfPrecedingEndingDelimiter = text.lastIndexOf("%>", caretPos - 1);
            int indexOfFollowingEndingDelimiter = text.indexOf("%>", caretPos);
            if (indexOfStartingDelimiter != -1 && indexOfStartingDelimiter > indexOfPrecedingEndingDelimiter) {
                retStr = indexOfFollowingEndingDelimiter == -1 ? text.substring(indexOfStartingDelimiter + 2) : text.substring(indexOfStartingDelimiter + 2, indexOfFollowingEndingDelimiter);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return retStr;
    }

    protected String getText(JTextComponent textField, String initStr, String targetText) {
        String text;
        block7: {
            text = textField.getText();
            int textLength = textField.getDocument().getLength();
            if (text != null) {
                int caretPos = textField.getCaretPosition();
                if (caretPos > 0 && caretPos < textLength) {
                    try {
                        if (initStr != null) {
                            String subStr = textField.getDocument().getText(0, caretPos + 2);
                            int startIndex = subStr.lastIndexOf("<%");
                            int endIndex = text.indexOf("%>", caretPos);
                            text = startIndex == -1 || endIndex == -1 ? text + targetText : text.substring(0, startIndex) + targetText + text.substring(endIndex + 2, textLength);
                            break block7;
                        }
                        String startText = textField.getDocument().getText(0, caretPos);
                        int length = textLength - caretPos;
                        String endText = textField.getDocument().getText(caretPos, length);
                        text = startText + targetText + endText;
                    }
                    catch (BadLocationException bae) {
                        text = text + targetText;
                    }
                } else {
                    text = caretPos == 0 ? targetText + text : text + targetText;
                }
            } else {
                text = targetText;
            }
        }
        return text;
    }
}

