/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.util.ResourceUtils;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.BpelNSResolver;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.iface.UserTask;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.ide.workflow.WorkflowProject;
import oracle.tip.tools.ide.common.ui.statusglasspane.StatusGlassPane;
import oracle.tip.tools.ide.common.utils.NamespaceResolver;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.ApplyCancelPanel;
import oracle.tip.tools.ide.pm.gui.generalpurpose.BPELBaseDialog;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.collaxalaf.popupeditor.UserTaskEditorData;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.AdvancedTaskEditPage;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.GeneralTaskData;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.GeneralTaskIOHandler;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.NewWorkflowComponent;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.WorkflowEditorContext;

public class WorkflowDialog
extends BPELBaseDialog
implements ActionListener,
ChangeListener {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    protected JTabbedPane m_tab;
    protected JButton m_helpBtn;
    protected JButton m_okBtn;
    protected JButton m_cancelBtn;
    protected int m_retVal = 1;
    protected NewWorkflowComponent m_genPage;
    protected AdvancedTaskEditPage m_advPage;
    protected BPELGraphPane m_graph;
    protected Process m_process;
    protected Node m_node;
    protected int m_selIndex = -1;
    private UserTaskEditorData mEditorData = null;
    private WorkflowEditorContext mContext;
    private StatusGlassPane mGlassPane = null;

    public WorkflowDialog(JFrame f, BPELGraphPane graph, Node node, List usList, UserTaskEditorData pData) {
        super(f, BPELStringTranslator.getString("CREATE_WORKFLOW"), true);
        this.mEditorData = pData;
        this.mEditorData.setUserTaskList(usList);
        this.m_graph = graph;
        this.m_node = node;
        if (graph != null) {
            BPELGraphModel model = (BPELGraphModel)graph.getModel();
            this.m_process = model.getProcess();
        }
        this.mContext = new WorkflowEditorContext();
        this.mContext.setGraphPane(this.m_graph);
        this.mContext.setActivity((Activity)this.getUserTask());
        this.mContext.setProcess(this.m_process);
        this.mContext.setNSResolver(WorkflowDialog.getNSResolver((Activity)this.getUserTask(), this.m_process));
        this.createControls();
        this.layoutControls();
        this.mGlassPane = new StatusGlassPane((Component)((Object)graph));
    }

    public int create() {
        this.loadControls();
        this.setVisible(true);
        return this.m_retVal;
    }

    public UserTaskEditorData getUserTaskEditorData() {
        return this.mEditorData;
    }

    public UserTask getUserTask() {
        return (UserTask)this.m_node.getUserObject();
    }

    protected void loadControls() {
        this.m_advPage.loadData();
    }

    protected void createControls() {
        this.m_tab = new JTabbedPane(ApplyCancelPanel.TAB_PLACEMENT);
        this.m_genPage = new NewWorkflowComponent(this.mEditorData, this.mContext);
        this.m_genPage.addPropertyChangeListener("WF added", new LocalWorkflowCreationListener());
        this.m_tab.add(this.m_genPage.getTitle(), this.m_genPage);
        this.m_advPage = new AdvancedTaskEditPage(this.m_graph, this.mEditorData);
        this.m_tab.add(this.m_advPage.getTitle(), this.m_advPage);
        this.m_tab.addChangeListener(this);
        this.m_advPage.setUserObject(this.m_node.getUserObject());
        this.m_okBtn = new JButton(BPELStringTranslator.getString("OK_BUTTON_TEXT"));
        ResourceUtils.resButton((AbstractButton)this.m_okBtn, (String)BPELStringTranslator.getString("OK_BUTTON_TEXT_RES"));
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn = new JButton(BPELStringTranslator.getString("CANCEL_BUTTON_TEXT"));
        ResourceUtils.resButton((AbstractButton)this.m_cancelBtn, (String)BPELStringTranslator.getString("CANCEL_BUTTON_TEXT_RES"));
        this.m_cancelBtn.addActionListener(this);
        this.m_helpBtn = new JButton(BPELStringTranslator.getString("HELP_BUTTON_TEXT"));
        ResourceUtils.resButton((AbstractButton)this.m_helpBtn, (String)BPELStringTranslator.getString("HELP_BUTTON_TEXT_RES"));
        this.m_helpBtn.addActionListener(this);
        this.registerF1Listener();
    }

    protected void layoutControls() {
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        GraphUtils.addComponent((Container)c, (Component)this.m_tab, (int)0, (int)0, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(10, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)c, (Component)this.m_helpBtn, (int)0, (int)1, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 10, 10, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)btnPnl, (int)1, (int)1, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 0, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setSize(450, 450);
        GraphUtils.centerInScreen((Component)((Object)this));
    }

    protected boolean isValidData() {
        boolean bRet = this.m_genPage.checkForValidity();
        if (bRet) {
            bRet = this.m_advPage.checkForValidity();
        }
        return bRet;
    }

    protected void save() {
        this.saveChanges();
        this.m_advPage.saveChanges();
    }

    private void saveChanges() {
        GeneralTaskIOHandler handler = new GeneralTaskIOHandler((Component)((Object)this), this.mEditorData, (UserTask)this.m_node.getUserObject(), this.m_graph.getBPELProject(), this.m_graph, this.m_process);
        GeneralTaskData data = this.m_genPage.getData();
        handler.saveChanges(data);
    }

    protected void handleCancel() {
        this.m_retVal = 1;
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_okBtn) {
            if (!this.isValidData()) {
                return;
            }
            this.save();
            this.m_retVal = 0;
            this.dispose();
        } else if (src == this.m_cancelBtn) {
            this.handleCancel();
        } else if (src == this.m_helpBtn) {
            this.handleHelp(this.m_tab.getSelectedComponent());
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object src = e.getSource();
        if (src == this.m_tab) {
            if (this.m_selIndex != -1 && this.m_selIndex != 0) {
                this.m_advPage.onDeselection();
            }
            this.m_selIndex = this.m_tab.getSelectedIndex();
            if (this.m_selIndex != 0) {
                this.m_advPage.onSelection();
            }
        }
    }

    public static final NamespaceResolver getNSResolver(Activity activity, Process process) {
        BpelNSResolver nsResolver = new BpelNSResolver(process);
        Map map = process.getNamespaceAliases();
        Object[] values = map.keySet().toArray();
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                nsResolver.addNSEntry((String)values[i], (String)map.get(values[i]));
            }
        }
        for (Activity curAct = activity; curAct != null && !(curAct instanceof Process); curAct = curAct.getParentActivity()) {
            Map attrMap;
            if (!(curAct instanceof Activity) || (attrMap = curAct.getAttributesMap()) == null) continue;
            for (String attName : attrMap.keySet()) {
                String prefix;
                if (!attName.startsWith("xmlns:") || (prefix = attName.substring(6, attName.length())).equals("")) continue;
                nsResolver.addNSEntry(prefix, (String)attrMap.get(attName));
            }
        }
        return nsResolver;
    }

    private void handleWorkflowCreation(WorkflowProject project) {
        this.enableUserInput(false);
        this.setVisible(false);
        this.m_retVal = 0;
        this.dispose();
        this.save();
        final URL url = project.getRoutingSlipURL();
        if (url != null) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    EditorManager.getEditorManager().openDefaultEditorInFrame(url);
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    protected void registerF1Listener() {
        AbstractAction f1Action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent pEvent) {
                WorkflowDialog.this.handleHelp(WorkflowDialog.this.m_tab.getSelectedComponent());
            }
        };
        JRootPane rootPane = this.getRootPane();
        KeyStroke f1 = KeyStroke.getKeyStroke(112, 0, false);
        rootPane.getInputMap(2).put(f1, "F1_KEY");
        rootPane.getActionMap().put("F1_KEY", f1Action);
    }

    private class LocalWorkflowCreationListener
    implements PropertyChangeListener {
        private LocalWorkflowCreationListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pEvent) {
            if (pEvent.getPropertyName().equals("WF added")) {
                WorkflowDialog.this.handleWorkflowCreation((WorkflowProject)pEvent.getNewValue());
            }
        }
    }
}

