/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.tip.tools.ide.common.bpelparser.iface.From;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.pm.modules.patterns.PatternFragmentUtil;
import org.apache.commons.lang.StringEscapeUtils;
import org.w3c.dom.Node;

public class WFBPELCodeGen {
    public static final String WF_TEMPLATE_BASIC = "WFBasic";
    public static final String WF_TEMPLATE_BASIC_CALLBACK = "WFBasicCallBack";
    public static final String WF_TEMPLATE_REINIT = "WFReinitiate";
    public static final String WF_TEMPLATE_REINIT_CALLBACK = "WFReinitiateCallBack";
    public static final String WF_BASIC_VAR_NAME = "initiateTaskInput";
    public static final String WF_REINIT_VAR_NAME = "reinitiateTaskInput";
    public static final String WF_BASIC_MSG_NAME = "initiateTask";
    public static final String WF_REINIT_MSG_NAME = "reinitiateTask";
    protected static final String USER_CP_RULES_VAR_NAME = "${userCPRules}";
    protected static final String PAYLOAD_CP_RULES_VAR_NAME = "${payloadCPRules}";
    protected static final String SCOPE_VAR_NAME = "${scopeName}";
    protected static final String WF_VAR_NAME = "${variableName}";
    protected static final String PL_VAR_NAME = "${partnerLinkName}";
    protected static final String PL_TYPE_PREFIX_VAR_NAME = "${partnerLinkTypePrefix}";
    protected static final String TASK_SVC_PREFIX = "${taskSvcPrefix}";
    protected static final String TASK_PREFIX = "${taskPrefix}";
    protected static final String WF_COMMON_PREFIX = "${wfCommonPrefix}";
    protected static final String PARTNERLINK_NAME = "${partnerLink}";
    protected static final String WF_TASKDEFURI_CP_RULE_1 = "<copy>\n\t<from expression=\"concat(ora:getProcessURL(), string(''{0}''))\"/>\n\t<to variable=\"{1}\" part=\"payload\" query=\"/{2}:{3}/{4}:task/{4}:taskDefinitionURI\"/>\n</copy>\n";
    protected static final String WF_PAYLOAD_INITIALIZE = "<copy>\n\t<from>\n\t<payload xmlns=\"http://xmlns.oracle.com/bpel/workflow/task\">\n{0}</payload>\n</from>\n\t<to variable=\"{1}\" part=\"payload\" query=\"/{2}:{3}/{4}:task/{4}:payload\"/>\n</copy>\n";
    protected static final String WF_TITLE_CP_RULE = "<copy>\n\t<from expression=\"{0}\"/>\n\t<to variable=\"{1}\" part=\"payload\" query=\"/{2}:{3}/{4}:task/{4}:title\"/>\n</copy>\n";
    protected static final String WF_TITLE_CP_RULE_QUERY = "/{0}:{1}/{2}:task/{2}:title";
    protected static final String WF_IDENTIFICATIONKEY_CP_RULE = "<copy>\n\t<from expression=\"{0}\"/>\n\t<to variable=\"{1}\" part=\"payload\" query=\"/{2}:{3}/{4}:task/{4}:identificationKey\"/>\n</copy>\n";
    protected static final String WF_IDENTIFICATIONKEY_CP_RULE_QUERY = "/{0}:{1}/{2}:task/{2}:identificationKey";
    protected static final String WF_IDENTITY_CONTEXT = "<copy>\n\t<from expression=\"{0}\"/>\n\t<to variable=\"{1}\" part=\"payload\" query=\"/{2}:{3}/{4}:task/{4}:identityContext\"/>\n</copy>\n";
    protected static final String WF_IDENTITY_CONTEXT_CP_RULE_QUERY = "/{0}:{1}/{2}:task/{2}:identityContext";
    protected static final String WF_APPLICATION_CONTEXT = "<copy>\n\t<from expression=\"{0}\"/>\n\t<to variable=\"{1}\" part=\"payload\" query=\"/{2}:{3}/{4}:task/{4}:applicationContextContext\"/>\n</copy>\n";
    protected static final String WF_APPLICATION_CONTEXT_CP_RULE_QUERY = "/{0}:{1}/{2}:task/{2}:applicationContext";
    protected static final String WF_CREATOR_CP_RULE = "<copy>\n\t<from expression=\"{0}\"/>\n\t<to variable=\"{1}\" part=\"payload\" query=\"/{2}:{3}/{4}:task/{4}:creator\"/>\n</copy>\n";
    protected static final String WF_CREATOR_CP_RULE_QUERY = "/{0}:{1}/{2}:task/{2}:creator";
    protected static final String WF_OWNER_CP_RULE = "<copy>\n\t<from expression=\"{0}\"/>\n\t<to variable=\"{1}\" part=\"payload\" query=\"/{2}:{3}/{4}:task/{4}:ownerUser\"/>\n</copy>\n";
    protected static final String WF_OWNER_CP_RULE_QUERY = "/{0}:{1}/{2}:task/{2}:ownerUser";
    protected static final String WF_PRIORITY_CP_RULE = "<copy>\n\t<from expression=\"number({0})\"/>\n\t<to variable=\"{1}\" part=\"payload\" query=\"/{2}:{3}/{4}:task/{4}:priority\"/>\n</copy>\n";
    protected static final String WF_PRIORITY_CP_RULE_QUERY = "/{0}:{1}/{2}:task/{2}:priority";
    protected static final String WF_GENERATE_EMPTY_ELEM_QUERY = "/{0}:{1}/{2}:task/{2}:payload";
    protected static final String WF_PAYLOAD_CP_RULE_1 = "<copy>\n\t<from {0}/>\n\t<to variable=\"{1}\" part=\"payload\" query=\"/{2}:{3}/{4}:task/{4}:payload/{4}:{5}\"/>\n</copy>\n";
    protected static final String WF_PAYLOAD_CP_RULE_2 = "<copy>\n\t<from>\t{0}\n\t</from>\n\t<to variable=\"{1}\" part=\"payload\" query=\"//{2}:{3}/{4}:task/{4}:payload/{4}:{5}\"/>\n</copy>\n";
    protected static final String WF_PAYLOAD_CP_RULE_QUERY = "/{0}:{1}/{2}:task/{2}:payload/{2}:{3}";
    protected static final String WF_PAYLOAD_CP_RULE_QUERY_ELEM = "/{0}:{1}/{2}:task/{2}:payload/{3}:{4}";
    protected static final String WF_PAYLOAD_CP_RULE_1_ELEM = "<copy>\n\t<from {0}/>\n\t<to variable=\"{1}\" part=\"payload\" query=\"/{2}:{3}/{4}:task/{4}:payload/{5}:{6}\"/>\n</copy>\n";
    protected static final String WF_PAYLOAD_CP_RULE_2_ELEM = "<copy>\n\t<from>\t{0}\n\t</from>\n\t<to variable=\"{1}\" part=\"payload\" query=\"//{2}:{3}/{4}:task/{4}:payload/{5}:{6}\"/>\n</copy>\n";
    protected static final String WF_PAYLOAD_APPEND_RULE_1 = "<copy xmlns:bpelx=\"http://schemas.oracle.com/bpel/extension\">\n\t<from {0}/>\n\t<to variable=\"{1}\" part=\"payload\" query=\"/{2}:{3}/{4}:task/{4}:payload\"/>\n</copy>\n";
    protected static final String WF_PAYLOAD_APPEND_QUERY = "/{0}:{1}/{2}:task/{2}:payload";
    protected static final String WF_REINIT_RULE = "<copy>\n\t<from variable=\"{0}\" part=\"payload\" query=\"/{1}:task\"/>\n\t<to variable=\"{2}\" part=\"payload\" query=\"/{3}:reinitiateTask/{1}:task\"/>\n</copy>\n";
    protected static final String WF_SWITCHCASE_CONDITION = "bpws:getVariableData(''{0}'', ''payload'', ''/{1}:task/{1}:systemAttributes/{1}:state'') = ''COMPLETED'' and bpws:getVariableData(''{0}'', ''payload'', ''/{1}:task/{1}:systemAttributes/{1}:outcome'') = ''{2}''";
    protected List<String> m_sysCPList = new ArrayList<String>();
    protected List<String> m_userCPList = new ArrayList<String>();
    protected List<String> m_payloadCPList = new ArrayList<String>();
    protected String m_scopeName;
    protected String m_plName;
    protected String m_pltypePrefix;
    protected String m_taskPrefix;
    protected String m_taskSvcPrefix;
    protected String m_wfCommonPrefix;
    protected String m_varName;

    public String genTitleCPRule(String exp, String taskVarName, String taskSvcPrefix, String msgName, String taskPrefix) {
        exp = StringEscapeUtils.escapeXml((String)exp);
        Object[] objs = new Object[]{exp, taskVarName, taskSvcPrefix, msgName, taskPrefix};
        return MessageFormat.format(WF_TITLE_CP_RULE, objs);
    }

    public String genPayloadInitCPRule(String exp, String taskVarName, String taskSvcPrefix, String msgName, String taskPrefix) {
        Object[] objs = new Object[]{exp, taskVarName, taskSvcPrefix, msgName, taskPrefix};
        return MessageFormat.format(WF_PAYLOAD_INITIALIZE, objs);
    }

    public String genIdentificationKeyCPRule(String exp, String taskVarName, String taskSvcPrefix, String idKey, String taskPrefix) {
        Object[] objs = new Object[]{exp, taskVarName, taskSvcPrefix, idKey, taskPrefix};
        return MessageFormat.format(WF_IDENTIFICATIONKEY_CP_RULE, objs);
    }

    public String genIdentityContextCPRule(String exp, String taskVarName, String taskSvcPrefix, String idKey, String taskPrefix) {
        Object[] objs = new Object[]{exp, taskVarName, taskSvcPrefix, idKey, taskPrefix};
        return MessageFormat.format(WF_IDENTITY_CONTEXT, objs);
    }

    public String genApplicationContextCPRule(String exp, String taskVarName, String taskSvcPrefix, String idKey, String taskPrefix) {
        Object[] objs = new Object[]{exp, taskVarName, taskSvcPrefix, idKey, taskPrefix};
        return MessageFormat.format(WF_APPLICATION_CONTEXT, objs);
    }

    public String genCreatorCPRule(String exp, String taskVarName, String taskSvcPrefix, String msgName, String taskPrefix) {
        Object[] objs = new Object[]{exp, taskVarName, taskSvcPrefix, msgName, taskPrefix};
        return MessageFormat.format(WF_CREATOR_CP_RULE, objs);
    }

    public String genOwnerCPRule(String exp, String taskVarName, String taskSvcPrefix, String msgName, String taskPrefix) {
        Object[] objs = new Object[]{exp, taskVarName, taskSvcPrefix, msgName, taskPrefix};
        return MessageFormat.format(WF_OWNER_CP_RULE, objs);
    }

    public String genPriorityCPRule(String priority, String taskVarName, String taskSvcPrefix, String msgName, String taskPrefix) {
        Object[] objs = new Object[]{priority, taskVarName, taskSvcPrefix, msgName, taskPrefix};
        return MessageFormat.format(WF_PRIORITY_CP_RULE, objs);
    }

    public String genPayloadCPRule(From from, String taskVarName, String taskSvcPrefix, String msgName, String taskPrefix, String localPart) {
        String fromStr = "";
        String cpRuleName = WF_PAYLOAD_CP_RULE_1;
        if (from.getLiteral() != null) {
            cpRuleName = WF_PAYLOAD_CP_RULE_2;
        }
        fromStr = this.inferFrom(from);
        Object[] objs = new Object[]{fromStr, taskVarName, taskSvcPrefix, msgName, taskPrefix, localPart};
        return MessageFormat.format(cpRuleName, objs);
    }

    private boolean isValid(String pString) {
        return pString != null && pString.trim().length() != 0;
    }

    private String inferFrom(From from) {
        String fromStr = "";
        if (this.isValid(from.getLiteral())) {
            fromStr = from.getLiteral();
        } else if (this.isValid(from.getExpression())) {
            fromStr = "expression=\"" + from.getExpression() + "\"";
        } else if (this.isValid(from.getVariable())) {
            StringBuffer strBuf = new StringBuffer("variable=\"");
            strBuf.append(from.getVariable());
            strBuf.append("\"");
            if (this.isValid(from.getPart())) {
                strBuf.append(" part=\"");
                strBuf.append(from.getPart());
                strBuf.append("\"");
            }
            if (this.isValid(from.getQuery())) {
                strBuf.append(" query=\"");
                strBuf.append(from.getQuery());
                strBuf.append("\"");
            }
            fromStr = strBuf.toString();
        } else if (this.isValid(from.getPartnerLink())) {
            StringBuffer strBuf = new StringBuffer("partnerLink=\"");
            strBuf.append(from.getPartnerLink());
            strBuf.append("\"");
            if (this.isValid(from.getEndpointReference())) {
                strBuf.append("endpointReference=\"");
                strBuf.append(from.getEndpointReference());
                strBuf.append("\"");
            }
            fromStr = strBuf.toString();
        }
        return fromStr;
    }

    public String genPayloadCPRuleForElem(From from, String taskVarName, String taskSvcPrefix, String msgName, String taskPrefix, String localPartPrefix, String localPart) {
        String fromStr = "";
        String cpRuleName = WF_PAYLOAD_CP_RULE_1_ELEM;
        if (from.getLiteral() != null) {
            cpRuleName = WF_PAYLOAD_CP_RULE_2_ELEM;
        }
        fromStr = this.inferFrom(from);
        Object[] objs = new Object[]{fromStr, taskVarName, taskSvcPrefix, msgName, taskPrefix, localPartPrefix, localPart};
        return MessageFormat.format(cpRuleName, objs);
    }

    public void addReinitCopyRule(String varName, String taskPrefix, String taskVarName, String msgName, String taskSvcPrefix) {
        Object[] objs = new Object[]{varName, taskPrefix, taskVarName, taskSvcPrefix};
        this.m_userCPList.add(0, MessageFormat.format(WF_REINIT_RULE, objs));
    }

    public String getSwitchCondition(String outcome) {
        Object[] objs = new Object[]{this.m_varName, this.m_taskPrefix, outcome};
        return MessageFormat.format(WF_SWITCHCASE_CONDITION, objs);
    }

    public void addUserCopyRule(String rule) {
        this.m_userCPList.add(rule);
    }

    public void addPayloadCopyRule(String rule) {
        this.m_payloadCPList.add(rule);
    }

    public void setScopeName(String scopeName) {
        this.m_scopeName = scopeName;
    }

    public void setPartnerLinkName(String name) {
        this.m_plName = name;
    }

    public void setPartnerLinkTypePrefix(String prefix) {
        this.m_pltypePrefix = prefix;
    }

    public void setTaskServicePrefix(String prefix) {
        this.m_taskSvcPrefix = prefix;
    }

    public void setTaskPrefix(String prefix) {
        this.m_taskPrefix = prefix;
    }

    public void setWFCommonPrefix(String prefix) {
        this.m_wfCommonPrefix = prefix;
    }

    public void setVariableName(String varName) {
        this.m_varName = varName;
    }

    public Node generateBPELCode(String patternName, Process process) throws Exception {
        HashMap<String, String> args = new HashMap<String, String>();
        StringBuffer strUser = new StringBuffer();
        for (int i = 0; i < this.m_userCPList.size(); ++i) {
            strUser.append(this.m_userCPList.get(i));
        }
        args.put(USER_CP_RULES_VAR_NAME, strUser.toString());
        StringBuffer strPayload = new StringBuffer();
        for (int i = 0; i < this.m_payloadCPList.size(); ++i) {
            strPayload.append(this.m_payloadCPList.get(i));
        }
        args.put(PAYLOAD_CP_RULES_VAR_NAME, strPayload.toString());
        args.put(SCOPE_VAR_NAME, this.m_scopeName);
        args.put(TASK_SVC_PREFIX, this.m_taskSvcPrefix);
        args.put(TASK_PREFIX, this.m_taskPrefix);
        args.put(WF_VAR_NAME, this.m_varName);
        args.put(WF_COMMON_PREFIX, this.m_wfCommonPrefix);
        if (this.m_plName != null) {
            args.put(PARTNERLINK_NAME, this.m_plName);
        }
        return PatternFragmentUtil.getPatternFragementNode(patternName, args);
    }
}

