/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor;

import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpelparser.iface.Copy;
import oracle.tip.tools.ide.common.bpelparser.iface.From;

public class TaskPayloadData {
    public static final int SIMPLE_ATTR_TYPE = 1;
    public static final int COMPLEX_ATTR_TYPE = 2;
    public static final int ELEMENT_ATTR_TYPE = 3;
    protected String m_name;
    protected int m_attrType;
    protected QName m_type;
    protected String m_queryStr;
    protected From m_from;
    protected Copy m_copy;

    public TaskPayloadData(String name, int attrType, QName type) {
        this.m_name = name;
        this.m_attrType = attrType;
        this.m_type = type;
    }

    public TaskPayloadData(String name, int attrType, QName type, Copy c) {
        this.m_name = name;
        this.m_attrType = attrType;
        this.m_type = type;
        this.m_copy = c;
        this.updateCopyRule();
    }

    private void updateCopyRule() {
        if (this.m_copy != null) {
            this.m_from = this.m_copy.getFrom();
            if (this.m_from != null) {
                this.m_queryStr = this.m_from.getQuery();
                if (this.m_from.getExpression() != null) {
                    this.m_queryStr = this.m_from.getExpression();
                }
                if (this.m_from.getLiteral() != null) {
                    this.m_queryStr = this.m_from.getLiteral();
                }
                if (this.m_queryStr == null || this.m_queryStr.trim().length() == 0 && this.m_from.getVariable() != null) {
                    this.m_queryStr = this.m_from.getVariable();
                }
            }
        }
    }

    public String getName() {
        return this.m_name;
    }

    public int getAttrType() {
        return this.m_attrType;
    }

    public QName getType() {
        return this.m_type;
    }

    public void setQueryStr(String queryStr) {
        this.m_queryStr = queryStr;
    }

    public String getQueryStr() {
        return this.m_queryStr;
    }

    public void setFrom(From from) {
        this.m_from = from;
    }

    public From getFrom() {
        return this.m_from;
    }

    public void setCopyRule(Copy c) {
        this.m_copy = c;
        this.updateCopyRule();
    }

    public Copy getCopyRule() {
        return this.m_copy;
    }

    public static int getAttrTypeFromString(String attrType) {
        int attr = -1;
        if ("SIMPLE_TYPE".equals(attrType)) {
            attr = 1;
        } else if ("COMPLEX_TYPE".equals(attrType)) {
            attr = 2;
        } else if ("ELEMENT".equals(attrType)) {
            attr = 3;
        }
        return attr;
    }
}

