/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import oracle.tip.tools.ide.common.bpelparser.iface.From;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.TaskPayloadData;

public class TaskDataTableModel
extends AbstractTableModel {
    private List<TaskPayloadData> mData = new ArrayList<TaskPayloadData>();
    private List<ChangeListener> mListeners = new ArrayList<ChangeListener>();
    private static final String[] HEADERS = new String[]{BPELStringTranslator.getString("TASK_DATA"), BPELStringTranslator.getString("BPEL_VARIABLE")};

    @Override
    public int getRowCount() {
        return this.mData.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        From from;
        TaskPayloadData d = this.mData.get(row);
        if (d == null) {
            return "";
        }
        if (col == 0) {
            return d.getName();
        }
        String s = d.getQueryStr();
        if (s == null && (from = d.getFrom()) != null) {
            if (from.getExpression() != null) {
                return from.getExpression();
            }
            if (from.getLiteral() != null) {
                return from.getLiteral();
            }
            if (from.getPartnerLink() != null) {
                return from.getPartnerLink();
            }
        }
        return s == null ? "" : s;
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        TaskPayloadData d = this.mData.get(row);
        if (d != null) {
            String str = obj.toString();
            if (str.length() == 0) {
                str = null;
            }
            d.setQueryStr(str);
        }
    }

    public Object getRow(int row) {
        return this.mData.get(row);
    }

    public void setRow(TaskPayloadData obj, int row) {
        this.mData.set(row, obj);
        this.fireTableCellUpdated(row, row);
        this.fireChangeOccurred();
    }

    public void insertRow(TaskPayloadData obj) {
        this.mData.add(obj);
        int row = this.mData.size() - 1;
        this.fireTableRowsInserted(row, row);
        this.fireChangeOccurred();
    }

    @Override
    public int getColumnCount() {
        return HEADERS.length;
    }

    @Override
    public String getColumnName(int col) {
        return HEADERS[col];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 1;
    }

    public void removeAll() {
        this.mData.clear();
        this.fireTableDataChanged();
        this.fireChangeOccurred();
    }

    public List<TaskPayloadData> getData() {
        return this.mData;
    }

    public void setData(List<TaskPayloadData> pData) {
        this.mData.clear();
        this.mData.addAll(pData);
        this.fireTableDataChanged();
    }

    public void addChangeListener(ChangeListener pListener) {
        if (pListener != null) {
            this.mListeners.add(pListener);
        }
    }

    public void removeChangeListener(ChangeListener pListener) {
        this.mListeners.remove(pListener);
    }

    public void fireChangeOccurred() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener cl : this.mListeners) {
            cl.stateChanged(e);
        }
    }
}

