/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor;

import java.awt.Component;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Copy;
import oracle.tip.tools.ide.common.bpelparser.iface.From;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CopyDialogEditPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CopyPageFactory;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CopyPageInputs;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CopyRuleDialog;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.TaskPayloadData;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.WorkflowEditorContext;

public class ShowCopyRuleCommand {
    private WorkflowEditorContext mContext = null;
    public final Result NULL = new NullResult();
    private final FromHandler[] HANDLERS = new FromHandler[]{new QueryHandler(), new LiteralHandler(), new ExpressionHandler(), new PartnerLinkHandler()};

    public ShowCopyRuleCommand(WorkflowEditorContext pContext) {
        this.mContext = pContext;
    }

    public Result doIt(Copy copy) {
        int ret_code;
        if (this.mContext == null) {
            return this.NULL;
        }
        Activity task = this.mContext.getActivity();
        BPELGraphPane pane = this.mContext.getGraphPane();
        CopyPageInputs in = new CopyPageInputs(task);
        in.storeData("ShowToPanel", Boolean.FALSE);
        CopyDialogEditPage page = null;
        page = copy != null ? CopyPageFactory.editCopyDialogEditPage(8, copy, pane, in) : CopyPageFactory.newCopyDialogEditPage(8, pane, in);
        if (page == null) {
            return this.NULL;
        }
        page.loadControls();
        page.setHelpTopicId("oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.GeneralTaskEditPage.ExtGenCopyDialogEditPage");
        String title = BPELStringTranslator.getString("WF_TASK_PAYLOAD");
        CopyRuleDialog dlg = new CopyRuleDialog(GraphUtils.getFrame((Component)((Object)pane)), page, title);
        int n = ret_code = copy != null ? dlg.edit() : dlg.create();
        if (ret_code == 0) {
            Copy rule = (Copy)page.getCopyRule();
            From from = rule.getFrom();
            for (int i = 0; i < this.HANDLERS.length; ++i) {
                FromHandler fh = this.HANDLERS[i];
                Result r = fh.getResult(from);
                r.setCopy(rule);
                r.accept(true);
                if (r == this.NULL) continue;
                return r;
            }
        }
        Result r = new Result();
        r.setCopy(copy);
        r.accept(false);
        return r;
    }

    public Result doIt(TaskPayloadData pData) {
        Copy copy = pData.getCopyRule();
        Result result = this.doIt(copy);
        if (result.hasAccepted()) {
            pData.setCopyRule(result.getCopy());
        }
        return result;
    }

    class QueryHandler
    implements FromHandler {
        QueryHandler() {
        }

        @Override
        public Result getResult(From pFrom) {
            String r = null;
            if (pFrom == null) {
                return ShowCopyRuleCommand.this.NULL;
            }
            String query = pFrom.getQuery();
            if (query == null) {
                return ShowCopyRuleCommand.this.NULL;
            }
            r = query.trim().length() == 0 ? pFrom.getVariable() : query;
            Result result = new Result();
            result.setSource(r);
            return result;
        }
    }

    class ExpressionHandler
    implements FromHandler {
        ExpressionHandler() {
        }

        @Override
        public Result getResult(From pFrom) {
            if (pFrom == null) {
                return ShowCopyRuleCommand.this.NULL;
            }
            String expression = pFrom.getExpression();
            if (expression == null) {
                return ShowCopyRuleCommand.this.NULL;
            }
            Result result = new Result();
            result.setSource(expression);
            return result;
        }
    }

    class LiteralHandler
    implements FromHandler {
        LiteralHandler() {
        }

        @Override
        public Result getResult(From pFrom) {
            if (pFrom == null) {
                return ShowCopyRuleCommand.this.NULL;
            }
            String literal = pFrom.getLiteral();
            if (literal == null) {
                return ShowCopyRuleCommand.this.NULL;
            }
            Result result = new Result();
            result.setSource(literal);
            return result;
        }
    }

    class PartnerLinkHandler
    implements FromHandler {
        PartnerLinkHandler() {
        }

        @Override
        public Result getResult(From pFrom) {
            if (pFrom == null) {
                return ShowCopyRuleCommand.this.NULL;
            }
            String pl = pFrom.getPartnerLink();
            if (pl == null) {
                return ShowCopyRuleCommand.this.NULL;
            }
            Result result = new Result();
            result.setSource(pl);
            return result;
        }
    }

    static interface FromHandler {
        public Result getResult(From var1);
    }

    class NullResult
    extends Result {
        NullResult() {
        }
    }

    public class Result {
        private boolean mAccepted = false;
        private Copy mCopy = null;
        private String mSource = null;

        public Copy getCopy() {
            return this.mCopy;
        }

        public void setCopy(Copy pCopy) {
            this.mCopy = pCopy;
        }

        public String getSource() {
            return this.mSource;
        }

        public void setSource(String pSource) {
            this.mSource = pSource;
        }

        public String toString() {
            return this.mSource;
        }

        public boolean hasAccepted() {
            return this.mAccepted;
        }

        public void accept(boolean pAccept) {
            this.mAccepted = pAccept;
        }
    }
}

