/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor;

import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import oracle.ide.editor.EditorManager;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class OpenWorkflowAction
extends AbstractAction {
    private IWorkflowURLProvider mProvider = null;

    public OpenWorkflowAction(IWorkflowURLProvider provider) {
        this.mProvider = provider;
        this.putValue("SmallIcon", ImageCache.getIcon("edit16"));
        this.putValue("ShortDescription", BPELStringTranslator.getString("EDIT_TASK_DEFINITION"));
    }

    @Override
    public void actionPerformed(ActionEvent pEvent) {
        final URL url = this.mProvider.getURL();
        if (url != null) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    EditorManager.getEditorManager().openDefaultEditorInFrame(url);
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    static interface IWorkflowURLProvider {
        public URL getURL();
    }
}

