/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.bpel.services.workflow.metadata.taskdefinition.model.TaskDefinition;
import oracle.ide.util.ResourceUtils;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ide.integration.IntegrationProject;
import oracle.tip.tools.ide.common.ide.workflow.WorkflowProject;
import oracle.tip.tools.ide.common.ui.CardPanel;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.UIUtil;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.collaxalaf.popupeditor.UserTaskEditorData;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.GeneralTaskComponent;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.GeneralTaskData;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.GeneralTaskIOHandler;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.IValidator;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.NewWorkflowAction;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.TaskPayloadData;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.WorkflowEditorContext;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.WorkflowURLRenderer;
import oracle.tip.tools.ide.pm.modules.workflow.wizard.ParameterData;
import oracle.tip.tools.ide.pm.modules.workflow.wizard.ParameterProvider;
import oracle.tip.tools.ide.workflow.api.IPayloadData;
import oracle.tip.tools.ide.workflow.api.ITitleHandler;

public class NewWorkflowComponent
extends JPanel
implements IValidator {
    public static final String WORKFLOW_ADDED = "WF added";
    private static final String MESSAGE1 = BPELStringTranslator.getString("SELECT_TASK_DEFINITION");
    private static final String MESSAGE2 = BPELStringTranslator.getString("CLICK_TO_CREATE");
    private static final String HIDE = "Hide";
    private static final String SHOW = "Show";
    private GeneralTaskComponent mComponent = null;
    private JComboBox mWorkflows = null;
    private JButton mNewWorkflow = null;
    private UserTaskEditorData mEditorData = null;
    private WorkflowEditorContext mContext = null;
    private JLabel mTaskDefLbl = new JLabel(BPELStringTranslator.getString("WF_TASK_DEFINITION"));
    private WorkflowProject NULL_WORKFLOW = null;
    private CardPanel mCardPanel = null;
    private Map<WorkflowProject, GeneralTaskData> map = new HashMap<WorkflowProject, GeneralTaskData>();
    private Map<WorkflowProject, TaskDefinition> mDefinitionCache = new HashMap<WorkflowProject, TaskDefinition>();
    private static final Color ASPHALT = new Color(116, 116, 116);
    private static final Font MESSAGE_FONT = new Font("Dialog", 1, 11);
    private NewWorkflowAction mNewWorkflowAction = null;

    public GeneralTaskData getData() {
        GeneralTaskData data = this.mComponent.getData();
        data.setWorkflow((WorkflowProject)this.mWorkflows.getSelectedItem());
        return data;
    }

    public NewWorkflowComponent(UserTaskEditorData pData, WorkflowEditorContext pContext) {
        this.mContext = pContext;
        this.mEditorData = pData;
        this.initialize();
        this.layoutComponents();
    }

    private void initialize() {
        this.mCardPanel = new CardPanel();
        this.mComponent = new GeneralTaskComponent(this.mContext);
        this.mNewWorkflowAction = new NewWorkflowAction(this.mEditorData, this.mContext);
        this.mNewWorkflow = new JButton(this.mNewWorkflowAction);
        UIHelper.setupButton((JButton)this.mNewWorkflow);
        Vector<WorkflowProject> v = new Vector<WorkflowProject>(GeneralTaskIOHandler.getWorkflows((IntegrationProject)this.mContext.getProject()));
        v.insertElementAt(this.NULL_WORKFLOW, 0);
        this.mWorkflows = new JComboBox<WorkflowProject>(v);
        this.mWorkflows.setRenderer(new WorkflowURLRenderer());
        this.mCardPanel.add(HIDE, (Component)this.prepareMessagePanel());
        this.mCardPanel.add(SHOW, (Component)this.mComponent);
        this.mCardPanel.show(HIDE);
        this.mWorkflows.addItemListener(new LocalItemListener());
        this.mNewWorkflowAction.addPropertyChangeListener(new LocalPropertyChangeListener());
    }

    private void layoutComponents() {
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        int x = 0;
        int y = 0;
        JPanel top = this.prepareTopPanel();
        gbl.setConstraints(top, new GridBagConstraints(x, y, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 5, 5, 5), 0, 0));
        this.add(top);
        gbl.setConstraints((Component)this.mCardPanel, new GridBagConstraints(x, ++y, 1, 1, 1.0, 1.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.mCardPanel);
        ArrayList<JComponent> list = new ArrayList<JComponent>(this.mComponent.getLeftLabels());
        list.add(this.mTaskDefLbl);
        UIUtil.equatePreferredWidths(list);
    }

    private JPanel prepareMessagePanel() {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        int x = 0;
        int y = 0;
        JComponent l = UIHelper.getMultiLineLabel((String)MESSAGE1);
        gbl.setConstraints(l, new GridBagConstraints(x, y, 1, 1, 0.0, 0.0, 10, 1, new Insets(20, 20, 5, 20), 0, 0));
        panel.add(l);
        JComponent m = UIHelper.getMultiLineLabel((String)MESSAGE2);
        gbl.setConstraints(m, new GridBagConstraints(x, ++y, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 20, 10, 20), 0, 0));
        panel.add(m);
        l.setFont(MESSAGE_FONT);
        m.setFont(MESSAGE_FONT);
        l.setForeground(ASPHALT);
        m.setForeground(ASPHALT);
        return panel;
    }

    private JPanel prepareTopPanel() {
        JPanel panel = new JPanel();
        ResourceUtils.resLabel((JLabel)this.mTaskDefLbl, (Component)this.mWorkflows, (String)BPELStringTranslator.getString("WF_TASK_DEFINITION"));
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        int x = 0;
        int y = 0;
        gbl.setConstraints(this.mTaskDefLbl, new GridBagConstraints(x, y, 1, 1, 0.0, 1.0, 21, 0, new Insets(0, 0, 0, 5), 0, 0));
        panel.add(this.mTaskDefLbl);
        gbl.setConstraints(this.mWorkflows, new GridBagConstraints(++x, y, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 10), 0, 0));
        panel.add(this.mWorkflows);
        gbl.setConstraints(this.mNewWorkflow, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add(this.mNewWorkflow);
        return panel;
    }

    public String getTitle() {
        return BPELStringTranslator.getString("GENERAL_EDITOR_TITLE");
    }

    private void handleWorkflow() {
        WorkflowProject wfp = (WorkflowProject)this.mWorkflows.getSelectedItem();
        if (wfp == null) {
            this.mCardPanel.show(HIDE);
        } else {
            this.loadNewWorkflow(wfp);
        }
        this.mEditorData.setTaskDefinition(this.getTaskDefinition(wfp));
    }

    private TaskDefinition getTaskDefinition(WorkflowProject project) {
        if (project == null) {
            return null;
        }
        TaskDefinition def = this.mDefinitionCache.get(project);
        if (def == null) {
            def = GeneralTaskIOHandler.getTaskDefinition(project);
            this.mDefinitionCache.put(project, def);
        }
        return def;
    }

    private void loadNewWorkflow(WorkflowProject project) {
        GeneralTaskData data = this.map.get(project);
        if (data == null) {
            ITitleHandler titleHandler;
            data = GeneralTaskIOHandler.read(project);
            data.setOldWorkflow(null);
            ParameterProvider pp = this.mNewWorkflowAction.getParameterProvider();
            if (pp != null) {
                Map<String, ParameterData> map = this.convertParametersToMap(pp.getAllParameters());
                List<TaskPayloadData> ltp = data.getPayload();
                for (TaskPayloadData tpd : ltp) {
                    String name = tpd.getName();
                    ParameterData pd = map.get(name);
                    if (pd == null) continue;
                    tpd.setCopyRule(pd.getCopy());
                }
                data.setPayload(ltp);
            }
            if ((titleHandler = this.mNewWorkflowAction.getTitleHandler()) != null) {
                data.setTitle(titleHandler.getContextualTitle());
            }
        }
        this.mComponent.setData(data);
        this.mCardPanel.show(SHOW);
    }

    private Map<String, ParameterData> convertParametersToMap(Collection<ParameterData> pdc) {
        HashMap<String, ParameterData> map = new HashMap<String, ParameterData>();
        for (ParameterData pd : pdc) {
            IPayloadData ipd = pd.getPayload();
            if (ipd == null) {
                System.out.println("Input payload is null!");
                continue;
            }
            map.put(ipd.getName(), pd);
        }
        return map;
    }

    private void handleNewWorkflow(WorkflowProject project) {
        this.loadNewWorkflow(project);
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.mWorkflows.getModel();
        model.addElement(project);
        this.mWorkflows.setSelectedItem(project);
        this.fireNewWorkflowAdded(project);
    }

    private void fireNewWorkflowAdded(WorkflowProject project) {
        this.firePropertyChange(WORKFLOW_ADDED, null, project);
    }

    @Override
    public boolean checkForValidity() {
        WorkflowProject wfp = (WorkflowProject)this.mWorkflows.getSelectedItem();
        if (wfp == null) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("WF_SPECIFY_TASK_DEFINITION"), (String)BPELStringTranslator.getString("GENERAL_EDITOR_ERROR"), (int)0);
            return false;
        }
        return this.mComponent.checkForValidity();
    }

    private class LocalPropertyChangeListener
    implements PropertyChangeListener {
        private LocalPropertyChangeListener() {
        }

        @Override
        public void propertyChange(final PropertyChangeEvent e) {
            if ("Workflow Added".equals(e.getPropertyName())) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        NewWorkflowComponent.this.handleNewWorkflow((WorkflowProject)e.getNewValue());
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    r.run();
                } else {
                    SwingUtilities.invokeLater(r);
                }
            }
        }
    }

    private class LocalItemListener
    implements ItemListener {
        private LocalItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent pEvent) {
            NewWorkflowComponent.this.handleWorkflow();
        }
    }
}

