/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import oracle.bpel.services.workflow.metadata.taskdefinition.model.TaskDefinition;
import oracle.ide.Context;
import oracle.tip.tools.ide.common.ide.workflow.WorkflowProject;
import oracle.tip.tools.ide.common.ui.statusglasspane.StatusGlassPane;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.collaxalaf.popupeditor.UserTaskEditorData;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.WorkflowEditorContext;
import oracle.tip.tools.ide.pm.modules.workflow.wizard.ParameterProvider;
import oracle.tip.tools.ide.pm.modules.workflow.wizard.TitleHandler;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;
import oracle.tip.tools.ide.workflow.api.IParameterProvider;
import oracle.tip.tools.ide.workflow.api.ITitleHandler;
import oracle.tip.tools.ide.workflow.contextwizard.ContextualWorkflowData;
import oracle.tip.tools.ide.workflow.util.CreateContextualWorkflowCommand;
import oracle.tip.tools.ide.workflow.util.WorkflowUtil;

public class NewWorkflowAction
extends AbstractAction {
    public static final String WORKFLOW_ADDED = "Workflow Added";
    private ParameterProvider mParameterProvider = null;
    private ITitleHandler mTitleHandler = null;
    private WorkflowEditorContext mContext = null;
    UserTaskEditorData mEditorData = null;

    public NewWorkflowAction(UserTaskEditorData pData, WorkflowEditorContext pContext) {
        this.mEditorData = pData;
        this.mContext = pContext;
        this.putValue("SmallIcon", ImageCache.getIcon("create16"));
    }

    public ParameterProvider getParameterProvider() {
        return this.mParameterProvider;
    }

    public ITitleHandler getTitleHandler() {
        return this.mTitleHandler;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.mParameterProvider == null) {
            this.mParameterProvider = new ParameterProvider(this.mContext);
        }
        if (this.mTitleHandler == null) {
            this.mTitleHandler = new TitleHandler(this.mContext);
        }
        Component root = (Component)e.getSource();
        final CreateContextualWorkflowCommand command = new CreateContextualWorkflowCommand(Context.newIdeContext().getProject(), root, (IParameterProvider)this.mParameterProvider, this.mTitleHandler);
        final ContextualWorkflowData data = command.showDialog();
        if (data == null) {
            return;
        }
        final StatusGlassPane pane = new StatusGlassPane((Component)e.getSource());
        pane.enableUserInput(false);
        pane.setStatusMessage("Creating New Workflow", "Creating " + data.getName() + ".task");
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                WorkflowProject wp = command.create(data);
                URL taskURL = wp.getRoutingSlipURL();
                WorkflowUtil util = new WorkflowUtil();
                try {
                    TaskDefinition def = util.convertToTaskDefinition(taskURL);
                    NewWorkflowAction.this.mEditorData.setTaskDefinition(def);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    pane.enableUserInput(true);
                    NewWorkflowAction.this.fireWorkflowAdded(wp);
                }
            }
        };
        new Thread(r).start();
    }

    private void fireWorkflowAdded(WorkflowProject project) {
        this.firePropertyChange(WORKFLOW_ADDED, null, project);
    }
}

