/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.util.ResourceUtils;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ide.workflow.WorkflowProject;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.UIUtil;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.GeneralTaskComponent;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.GeneralTaskData;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.IValidator;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.OpenWorkflowAction;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.WorkflowEditorContext;

public class GeneralTaskPanel
extends JPanel
implements IValidator {
    private GeneralTaskComponent mComponent;
    protected JLabel mTaskDefField;
    private GeneralTaskData mData = null;
    private JButton mTaskDefEditBtn;
    private List<ChangeListener> mChangeListeners = new ArrayList<ChangeListener>();
    private LocalChangeListener mListener = new LocalChangeListener();
    private WorkflowEditorContext mContext = null;

    public GeneralTaskPanel(WorkflowEditorContext pContext) {
        this.mContext = pContext;
        this.initialize();
        this.layoutControls();
        this.setData(null);
    }

    public void initialize() {
        this.mTaskDefField = new JLabel();
        this.mTaskDefEditBtn = new JButton(new OpenWorkflowAction(new LocalWorkflowProvider()));
        UIHelper.setupButton((JButton)this.mTaskDefEditBtn);
        this.mComponent = new GeneralTaskComponent(this.mContext);
    }

    public static void main(String[] argv) {
        BPELStringTranslator.initialize();
        JFrame f = new JFrame();
        f.setContentPane(new GeneralTaskPanel(null));
        f.setDefaultCloseOperation(3);
        f.setSize(100, 100);
        f.setVisible(true);
    }

    private void layoutControls() {
        JLabel taskDefLbl = new JLabel(BPELStringTranslator.getString("WF_TASK_DEFINITION"));
        ResourceUtils.resLabel((JLabel)taskDefLbl, (Component)this.mTaskDefField, (String)BPELStringTranslator.getString("WF_TASK_DEFINITION"));
        this.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)this, (Component)taskDefLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.mTaskDefField, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.mTaskDefEditBtn, (int)2, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.mComponent, (int)0, (int)row, (int)0, (int)0, (int)17, (int)1, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        ArrayList<JComponent> list = new ArrayList<JComponent>(this.mComponent.getLeftLabels());
        list.add(taskDefLbl);
        UIUtil.equatePreferredWidths(list);
    }

    public void setData(GeneralTaskData pData) {
        this.mData = pData == null ? new GeneralTaskData() : pData;
        this.fillUI();
    }

    private void fillUI() {
        if (this.mData.getWorkflow() != null) {
            this.mTaskDefField.setText(this.mData.getWorkflow().getWorkflowName());
        }
        this.mComponent.setData(this.mData);
    }

    public GeneralTaskData getData() {
        GeneralTaskData gd = this.mComponent.getData();
        return gd;
    }

    private void fireChangeOccurred() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener cl : this.mChangeListeners) {
            cl.stateChanged(e);
        }
    }

    private URL getSelectedRoutingSlip() {
        WorkflowProject project = this.mData.getOldWorkflow();
        if (project != null) {
            return project.getRoutingSlipURL();
        }
        return null;
    }

    @Override
    public boolean checkForValidity() {
        return this.mComponent.checkForValidity();
    }

    class LocalWorkflowProvider
    implements OpenWorkflowAction.IWorkflowURLProvider {
        LocalWorkflowProvider() {
        }

        @Override
        public URL getURL() {
            return GeneralTaskPanel.this.getSelectedRoutingSlip();
        }
    }

    class LocalChangeListener
    implements DocumentListener,
    ItemListener,
    ChangeListener {
        LocalChangeListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent pEvent) {
        }

        @Override
        public void insertUpdate(DocumentEvent pEvent) {
            GeneralTaskPanel.this.fireChangeOccurred();
        }

        @Override
        public void removeUpdate(DocumentEvent pEvent) {
            GeneralTaskPanel.this.fireChangeOccurred();
        }

        @Override
        public void itemStateChanged(ItemEvent pEvent) {
            GeneralTaskPanel.this.fireChangeOccurred();
        }

        @Override
        public void stateChanged(ChangeEvent pEvent) {
            GeneralTaskPanel.this.fireChangeOccurred();
        }
    }
}

