/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor;

import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import oracle.bpel.services.common.util.JaxbUtil;
import oracle.bpel.services.workflow.metadata.config.model.MessageAttributeType;
import oracle.bpel.services.workflow.metadata.config.model.MessageAttributeTypeImpl;
import oracle.bpel.services.workflow.metadata.config.model.PayloadType;
import oracle.bpel.services.workflow.metadata.config.model.WorkflowConfigurationType;
import oracle.bpel.services.workflow.metadata.routingslip.model.GlobalConfigurationType;
import oracle.bpel.services.workflow.metadata.routingslip.model.RoutingSlipType;
import oracle.bpel.services.workflow.metadata.taskdefinition.TaskDefinitionUtil;
import oracle.bpel.services.workflow.metadata.taskdefinition.model.TaskDefinition;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.Append;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.From;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.FromOpType;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.To;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.iface.UserTask;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Assign;
import oracle.tip.tools.ide.common.bpelparser.iface.ContainerActivity;
import oracle.tip.tools.ide.common.bpelparser.iface.Copy;
import oracle.tip.tools.ide.common.bpelparser.iface.Invoke;
import oracle.tip.tools.ide.common.bpelparser.iface.ParserContext;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLinks;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.iface.Sequence;
import oracle.tip.tools.ide.common.bpelparser.iface.Switch;
import oracle.tip.tools.ide.common.bpelparser.iface.SwitchCase;
import oracle.tip.tools.ide.common.bpelparser.iface.SwitchOtherwise;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.ide.integration.IntegrationProject;
import oracle.tip.tools.ide.common.ide.workflow.WorkflowProject;
import oracle.tip.tools.ide.common.ui.MultiLineOptionPaneDialog;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.MixedXPathExpressionParser;
import oracle.tip.tools.ide.pm.addin.BPELAddin;
import oracle.tip.tools.ide.pm.bpelgraph.model.AssignNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.PartnerLinkNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.SwimLaneNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.SwitchCaseNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.SwimLaneView;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.collaxalaf.popupeditor.UserTaskEditorData;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.GeneralTaskData;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.GeneralTaskEditPage;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.TaskPayloadData;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.WFBPELCodeGen;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.util.WFBpelCodeUtil;
import oracle.tip.tools.ide.workflow.util.WorkflowUtil;
import oracle.xml.jaxb.JaxbNode;
import oracle.xml.parser.v2.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GeneralTaskIOHandler {
    private UserTaskEditorData mEditorData;
    private Process mProcess;
    private UserTask mTask;
    protected Assign m_taskTitleAssign;
    protected Copy m_taskTitleCPRule;
    protected Copy m_creatorCPRule;
    protected Assign m_creatorAssign;
    protected Copy m_priorityCPRule;
    protected Assign m_priorityAssign;
    protected Assign m_taskDataAssign;
    protected List m_taskDataCPList = new ArrayList();
    protected String m_partnerLinkName;
    private Component mParent;
    private BPELProject mProject;
    private BPELGraphModel m_graphModel;
    private BPELGraphPane m_graphPane;
    private static final String CHAR_ENC = "UTF-8";

    public GeneralTaskIOHandler(Component parent, UserTaskEditorData pEditorData, UserTask pTask, BPELProject project, BPELGraphPane pane, Process process) {
        this.mParent = parent;
        this.mProcess = process;
        this.mEditorData = pEditorData;
        this.setUserTask(pTask);
        this.mProject = project;
        this.m_graphPane = pane;
        this.m_graphModel = (BPELGraphModel)this.m_graphPane.getModel();
    }

    public static GeneralTaskData read(WorkflowProject project) {
        GeneralTaskData data = new GeneralTaskData();
        data.setWorkflow(project);
        TaskDefinition def = GeneralTaskIOHandler.getTaskDefinition(project.getRoutingSlipURL());
        GeneralTaskIOHandler.loadUnfilledTaskData(data, def);
        return data;
    }

    public void setUserTask(UserTask pTask) {
        this.mTask = pTask;
    }

    public GeneralTaskData read() {
        GeneralTaskData data = new GeneralTaskData();
        this.loadTaskDefinition(data);
        GeneralTaskIOHandler.loadUnfilledTaskData(data, this.mEditorData.getTaskDefinition());
        List actList = this.mTask.getActivityList();
        Collection<Assign> assigns = this.fetchAssigns(actList);
        this.handleAssigns(assigns, data);
        Invoke invoke = this.mTask.getInvoke();
        if (invoke != null) {
            this.m_partnerLinkName = invoke.getPartnerLink();
        }
        return data;
    }

    private void handleAssigns(Collection<Assign> pAssigns, GeneralTaskData pData) {
        for (Assign a : pAssigns) {
            ArrayList<Copy> copyRules = new ArrayList<Copy>();
            ArrayList<Append> appends = new ArrayList<Append>();
            this.filterCopyAndAppendRules(a.getCopyRules(), copyRules, appends);
            this.handleCopyRules(a, copyRules, pData);
            this.handleAppendRules(a, appends, pData);
        }
    }

    private void handleAppendRules(Assign act, Collection<Append> pAppends, GeneralTaskData pData) {
        for (Append a : pAppends) {
            if (!this.loadTaskData(a, pData) || this.m_taskDataAssign != null) continue;
            this.m_taskDataAssign = act;
        }
    }

    private void filterCopyAndAppendRules(List pCopyRules, Collection<Copy> pCopies, Collection<Append> pAppends) {
        for (Object obj : pCopyRules) {
            if (obj instanceof Copy) {
                Copy c = (Copy)obj;
                pCopies.add(c);
                continue;
            }
            if (!(obj instanceof Append)) continue;
            Append a = (Append)obj;
            pAppends.add(a);
        }
    }

    private void handleCopyRules(Assign act, Collection<Copy> pCopies, GeneralTaskData pData) {
        for (Copy c : pCopies) {
            if (this.loadTaskTitle(c, pData)) {
                this.m_taskTitleCPRule = c;
                this.m_taskTitleAssign = act;
                continue;
            }
            if (this.loadCreator(c, pData)) {
                this.m_creatorCPRule = c;
                this.m_creatorAssign = act;
                continue;
            }
            if (this.loadPriority(c, pData)) {
                this.m_priorityCPRule = c;
                this.m_priorityAssign = act;
                continue;
            }
            if (!this.loadTaskData(c, pData) || this.m_taskDataAssign != null) continue;
            this.m_taskDataAssign = act;
        }
    }

    private Collection<Assign> fetchAssigns(List pActivities) {
        for (Activity a : pActivities) {
            if (!(a instanceof Sequence)) continue;
            return this.fetchAssigns((Sequence)a);
        }
        return Collections.EMPTY_LIST;
    }

    private Collection<Assign> fetchAssigns(Sequence pSequence) {
        ArrayList<Assign> l = new ArrayList<Assign>();
        List activities = pSequence.getActivityList();
        for (Activity a : activities) {
            if (!(a instanceof Assign)) continue;
            l.add((Assign)a);
        }
        return l;
    }

    private void prepareEditorData(GeneralTaskData pData) {
        this.mEditorData.setProcess(this.mProcess);
        if (pData.getOldWorkflow() == null || !pData.getWorkflow().equals(pData.getOldWorkflow())) {
            this.mEditorData.setGenerateData(true);
        }
    }

    public void saveChanges(GeneralTaskData pData) {
        this.prepareEditorData(pData);
        boolean bGenerateNewCode = true;
        if (pData.getOldWorkflow() == pData.getWorkflow()) {
            bGenerateNewCode = false;
        } else {
            this.mEditorData.setGenerateData(true);
        }
        Process process = this.mEditorData.getProcess();
        WFBPELCodeGen u = this.mEditorData.getBPELCodeGen();
        String title = pData.getTitle();
        String varName = this.mEditorData.getTaskVariableName();
        if (varName == null) {
            WorkflowProject project;
            TaskDefinition def = this.mEditorData.getTaskDefinition();
            if (def == null && (project = pData.getWorkflow()) != null) {
                def = GeneralTaskIOHandler.getTaskDefinition(project.getRoutingSlipURL());
                this.mEditorData.setTaskDefinition(def);
            }
            if (def == null) {
                return;
            }
            String name = def.getName();
            name = BPELModelUtil.generateUniqueName((Process)process, (String)name, Scope.class);
            varName = name + "_globalVariable";
        }
        u.setVariableName(varName);
        String taskPrefix = process.addNamespace("http://xmlns.oracle.com/bpel/workflow/task", "task");
        String taskSvcPrefix = process.addNamespace("http://xmlns.oracle.com/bpel/workflow/taskService", "taskservice");
        String wfCommonPrefix = process.addNamespace("http://xmlns.oracle.com/bpel/workflow/common", "wfcommon");
        u.setTaskPrefix(taskPrefix);
        u.setTaskServicePrefix(taskSvcPrefix);
        u.setWFCommonPrefix(wfCommonPrefix);
        boolean bIncHist = this.mEditorData.getIncludeHistory();
        String taskVarName = bIncHist ? "reinitiateTaskInput" : "initiateTaskInput";
        String msgName = bIncHist ? "reinitiateTask" : "initiateTask";
        String exp = "";
        if (title != null && title.trim().length() > 0) {
            MixedXPathExpressionParser parser = new MixedXPathExpressionParser();
            exp = parser.convertMixedStringToXPathCompliantForm(title);
            u.addUserCopyRule(u.genTitleCPRule(exp, taskVarName, taskSvcPrefix, msgName, taskPrefix));
            this.saveTaskTitle(exp, taskVarName, taskSvcPrefix, msgName, taskPrefix);
        } else {
            this.removeTaskTitle();
        }
        String t = pData.getInitiator();
        exp = "";
        if (t != null && t.trim().length() > 0) {
            MixedXPathExpressionParser parser = new MixedXPathExpressionParser();
            exp = parser.convertMixedStringToXPathCompliantForm(t);
            u.addUserCopyRule(u.genCreatorCPRule(exp, taskVarName, taskSvcPrefix, msgName, taskPrefix));
            if (!bGenerateNewCode) {
                this.saveTaskCreator(exp, taskVarName, taskSvcPrefix, msgName, taskPrefix);
            }
        } else {
            this.removeTaskCreator();
        }
        int p = pData.getPriority();
        u.addUserCopyRule(u.genPriorityCPRule(Integer.toString(p), taskVarName, taskSvcPrefix, msgName, taskPrefix));
        this.saveTaskPriority(Integer.toString(p), taskVarName, taskSvcPrefix, msgName, taskPrefix);
        List<TaskPayloadData> vec = pData.getPayload();
        u.m_payloadCPList.clear();
        this.addPayloadInitSegment(taskVarName, taskSvcPrefix, msgName, taskPrefix, u, bGenerateNewCode, pData);
        for (int i = 0; i < vec.size(); ++i) {
            TaskPayloadData data = vec.get(i);
            if (data.getFrom() != null && data.getQueryStr() != null) {
                if (data.getAttrType() == 3) {
                    String localPartPrefix = process.getPrefixForNamespace(data.getType().getNamespaceURI());
                    u.addPayloadCopyRule(u.genPayloadCPRuleForElem(data.getFrom(), taskVarName, taskSvcPrefix, msgName, taskPrefix, localPartPrefix, data.getName()));
                    if (bGenerateNewCode) continue;
                    this.savePayloadCopyRuleForElem(data.getName(), data.getFrom(), taskVarName, taskSvcPrefix, msgName, taskPrefix, localPartPrefix);
                    continue;
                }
                u.addPayloadCopyRule(u.genPayloadCPRule(data.getFrom(), taskVarName, taskSvcPrefix, msgName, taskPrefix, data.getName()));
                if (bGenerateNewCode) continue;
                this.savePayloadCopyRule(data.getName(), data.getFrom(), taskVarName, taskSvcPrefix, msgName, taskPrefix);
                continue;
            }
            if (bGenerateNewCode) continue;
            int ruleType = data.getAttrType() == 3 ? 2 : 1;
            this.removePayloadRule(data.getName(), ruleType);
        }
        this.removeReduntantCopyRules();
        this.generateCopyRulesForSwitchAct(u.m_payloadCPList, varName, taskPrefix);
        this.modifySwitchNode(process.getDOMElement().getOwnerDocument(), varName);
        u.setPartnerLinkTypePrefix(taskPrefix);
        this.addingPartnerLink(taskSvcPrefix, u, pData);
    }

    private void saveTaskCreator(String exp, String taskVarName, String taskSvcPrefix, String msgName, String taskPrefix) {
        if (this.m_creatorAssign == null) {
            this.m_creatorAssign = this.getFirstAssign();
            if (this.m_creatorAssign == null) {
                return;
            }
        }
        if (this.m_creatorCPRule == null) {
            this.m_creatorCPRule = this.createCopyRule();
            this.m_creatorAssign.addCopyRule(this.m_creatorCPRule);
        }
        Object[] objs = new Object[]{taskSvcPrefix, msgName, taskPrefix};
        String queryStr = MessageFormat.format("/{0}:{1}/{2}:task/{2}:creator", objs);
        this.m_creatorCPRule.getFrom().setExpression(exp);
        this.m_creatorCPRule.getTo().setVariable(taskVarName);
        this.m_creatorCPRule.getTo().setPart("payload");
        this.m_creatorCPRule.getTo().setQuery(queryStr);
    }

    private void removeTaskCreator() {
        List list;
        if (this.m_creatorCPRule == null) {
            return;
        }
        if (this.m_creatorAssign != null && (list = this.m_creatorAssign.getCopyRules()) != null) {
            ArrayList newList = new ArrayList(list);
            newList.remove(this.m_creatorCPRule);
            this.m_creatorAssign.setCopyRules(newList);
        }
    }

    private void saveTaskPriority(String priority, String taskVarName, String taskSvcPrefix, String msgName, String taskPrefix) {
        if (this.m_priorityAssign == null) {
            this.m_priorityAssign = this.getFirstAssign();
            if (this.m_priorityAssign == null) {
                return;
            }
        }
        if (this.m_priorityCPRule == null) {
            this.m_priorityCPRule = this.createCopyRule();
            this.m_priorityAssign.addCopyRule(this.m_priorityCPRule);
        }
        Object[] objs = new Object[]{taskSvcPrefix, msgName, taskPrefix};
        String queryStr = MessageFormat.format("/{0}:{1}/{2}:task/{2}:priority", objs);
        this.m_priorityCPRule.getFrom().setExpression("number(" + priority + ")");
        this.m_priorityCPRule.getTo().setVariable(taskVarName);
        this.m_priorityCPRule.getTo().setPart("payload");
        this.m_priorityCPRule.getTo().setQuery(queryStr);
    }

    public Copy createCopyRule() {
        return GeneralTaskIOHandler.createCopyRule((Activity)this.mTask);
    }

    public static Copy createCopyRule(Activity pTask) {
        Element elem = pTask.getDOMElement();
        Copy c = (Copy)BPELParser.createImplementation(Copy.class);
        c.createDOMElement(elem.getOwnerDocument(), "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
        oracle.tip.tools.ide.common.bpelparser.iface.From from = (oracle.tip.tools.ide.common.bpelparser.iface.From)BPELParser.createImplementation(oracle.tip.tools.ide.common.bpelparser.iface.From.class);
        from.createDOMElement(elem.getOwnerDocument(), "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
        oracle.tip.tools.ide.common.bpelparser.iface.To to = (oracle.tip.tools.ide.common.bpelparser.iface.To)BPELParser.createImplementation(oracle.tip.tools.ide.common.bpelparser.iface.To.class);
        to.createDOMElement(elem.getOwnerDocument(), "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
        c.setFrom(from);
        c.setTo(to);
        return c;
    }

    private Copy findTitleCopy() {
        Assign taskTitleAssign = this.getFirstAssign();
        if (taskTitleAssign == null) {
            return null;
        }
        Copy copy = null;
        ArrayList l = new ArrayList(taskTitleAssign.getCopyRules());
        for (Copy c : l) {
            oracle.tip.tools.ide.common.bpelparser.iface.To to = c.getTo();
            String query = to.getQuery();
            if (query == null || !query.endsWith(":title")) continue;
            copy = c;
            break;
        }
        return copy;
    }

    private void removeTaskTitle() {
        Assign taskTitleAssign = this.getFirstAssign();
        if (taskTitleAssign == null) {
            return;
        }
        Copy copy = null;
        ArrayList l = new ArrayList(taskTitleAssign.getCopyRules());
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            Copy c = (Copy)iter.next();
            oracle.tip.tools.ide.common.bpelparser.iface.To to = c.getTo();
            String query = to.getQuery();
            if (query == null || !query.endsWith(":title")) continue;
            copy = c;
            iter.remove();
            break;
        }
        if (copy != null) {
            taskTitleAssign.setCopyRules(l);
        }
    }

    private void saveTaskTitle(String exp, String taskVarName, String taskSvcPrefix, String msgName, String taskPrefix) {
        Assign taskTitleAssign = this.getFirstAssign();
        if (taskTitleAssign == null) {
            return;
        }
        Copy taskTitleCPRule = this.createCopyRule();
        taskTitleAssign.addCopyRule(taskTitleCPRule);
        Object[] objs = new Object[]{taskSvcPrefix, msgName, taskPrefix};
        String queryStr = MessageFormat.format("/{0}:{1}/{2}:task/{2}:title", objs);
        taskTitleCPRule.getFrom().setExpression(exp);
        taskTitleCPRule.getTo().setVariable(taskVarName);
        taskTitleCPRule.getTo().setPart("payload");
        taskTitleCPRule.getTo().setQuery(queryStr);
    }

    private Object getPayloadInitCpRule() {
        Assign assign = GeneralTaskEditPage.getAssignFromTaskActList(this.mTask.getActivityList());
        List list = assign.getCopyRules();
        if (list != null) {
            for (Object copy : list) {
                if (!(copy instanceof Copy) || ((Copy)copy).getFrom() == null || ((Copy)copy).getFrom().getLiteral() == null || !((Copy)copy).getFrom().getLiteral().trim().startsWith("<payload") || ((Copy)copy).getTo() == null || !((Copy)copy).getTo().getPart().trim().equals("payload") || !((Copy)copy).getTo().getQuery().trim().endsWith("payload")) continue;
                return copy;
            }
        }
        return null;
    }

    private Assign getFirstAssign() {
        if (this.mTask == null) {
            return null;
        }
        List actList = this.mTask.getActivityList();
        return GeneralTaskEditPage.getAssignFromTaskActList(actList);
    }

    private void savePayloadInitRule(String payloadInitRule) {
        DOMParser parser;
        Copy oldCopy = null;
        Copy data = (Copy)BPELParser.createImplementation(Copy.class);
        String strData = payloadInitRule;
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(strData.getBytes(CHAR_ENC));
            parser = new DOMParser();
            parser.parse((InputStream)in);
        }
        catch (Exception e) {
            return;
        }
        Element retNode = parser.getDocument().getDocumentElement();
        ParserContext pctxt = this.mProcess.createParserContext();
        data.readFromElement(retNode, pctxt);
        oracle.tip.tools.ide.common.bpelparser.iface.From cpFrom = data.getFrom();
        oracle.tip.tools.ide.common.bpelparser.iface.To cpTo = data.getTo();
        Copy c = (Copy)this.getPayloadInitCpRule();
        if (c != null) {
            oldCopy = (Copy)BPELParser.createImplementation(Copy.class);
            oracle.tip.tools.ide.common.bpelparser.iface.From from = (oracle.tip.tools.ide.common.bpelparser.iface.From)BPELParser.createImplementation(oracle.tip.tools.ide.common.bpelparser.iface.From.class);
            oracle.tip.tools.ide.common.bpelparser.iface.To to = (oracle.tip.tools.ide.common.bpelparser.iface.To)BPELParser.createImplementation(oracle.tip.tools.ide.common.bpelparser.iface.To.class);
            oldCopy.setFrom(from);
            oldCopy.setTo(to);
            from.setLiteral(c.getFrom().getLiteral());
            to.setVariable(c.getTo().getVariable());
            to.setPart(c.getTo().getPart());
            to.setQuery(c.getTo().getQuery());
        }
        if (c == null) {
            c = this.createCopyRule();
        }
        c.getFrom().setLiteral(cpFrom.getLiteral());
        c.getTo().setVariable(cpTo.getVariable());
        c.getTo().setPart(cpTo.getPart());
        c.getTo().setQuery(cpTo.getQuery());
        if (this.m_taskDataAssign == null) {
            this.m_taskDataAssign = this.getFirstAssign();
        }
        ArrayList<Copy> list = new ArrayList<Copy>(this.m_taskDataAssign.getCopyRules());
        list.add(0, c);
        this.removePayloadUsages(list, oldCopy, c);
        this.m_taskDataAssign.setCopyRules(list);
    }

    private Collection<Copy> removePayloadUsages(Collection<Copy> pList, Copy pOldCopy, Copy pNewCopy) {
        if (pOldCopy == null) {
            return pList;
        }
        ArrayList c = new ArrayList();
        HashSet<String> oldNames = new HashSet<String>();
        HashSet<String> newNames = new HashSet<String>();
        this.getPayloadElementsFromPayload(pOldCopy, oldNames);
        this.getPayloadElementsFromPayload(pNewCopy, newNames);
        Iterator iter = oldNames.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (!newNames.contains(name)) continue;
            iter.remove();
        }
        HashSet<String> tos = new HashSet<String>();
        for (String name : oldNames) {
            tos.add("/taskservice:initiateTask/task:task/task:payload/task:" + name);
        }
        Iterator<Object> iter2 = pList.iterator();
        while (iter2.hasNext()) {
            String query;
            Copy copy = (Copy)iter2.next();
            oracle.tip.tools.ide.common.bpelparser.iface.To to = copy.getTo();
            if (to == null || !tos.contains(query = to.getQuery())) continue;
            iter2.remove();
        }
        return pList;
    }

    private void getPayloadElementsFromPayload(Copy pCopy, Collection<String> pNames) {
        DOMParser parser;
        oracle.tip.tools.ide.common.bpelparser.iface.From from = pCopy.getFrom();
        if (from == null) {
            return;
        }
        String strData = from.getLiteral();
        if (strData == null || strData.trim().length() == 0) {
            return;
        }
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(strData.getBytes(CHAR_ENC));
            parser = new DOMParser();
            parser.parse((InputStream)in);
        }
        catch (Exception e) {
            return;
        }
        Element retNode = parser.getDocument().getDocumentElement();
        NodeList nl = retNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element e;
            String name;
            Node n = nl.item(i);
            if (!(n instanceof Element) || (name = (e = (Element)n).getTagName()) == null || name.trim().length() == 0) continue;
            pNames.add(name);
        }
    }

    private void addPayloadInitSegment(String taskVarName, String taskSvcPrefix, String msgName, String taskPrefix, WFBPELCodeGen u, boolean bGenerateNewCode, GeneralTaskData pData) {
        List<TaskPayloadData> vec = pData.getPayload();
        String payloadInitFromFrag = "";
        for (int i = 0; i < vec.size(); ++i) {
            TaskPayloadData data = vec.get(i);
            if (data.getFrom() == null || data.getQueryStr() == null) continue;
            payloadInitFromFrag = data.getAttrType() == 3 ? payloadInitFromFrag + "\t<" + data.getName() + " xmlns = " + "\"" + data.getType().getNamespaceURI() + "\"" + "/> \n" : payloadInitFromFrag + " <" + data.getName() + " xmlns = " + "\"" + "http://xmlns.oracle.com/bpel/workflow/task" + "\"" + " />\n";
        }
        boolean reInit = this.mEditorData.reinitializePayload();
        if (reInit) {
            String payloadInitCpRule = u.genPayloadInitCPRule(payloadInitFromFrag, taskVarName, taskSvcPrefix, msgName, taskPrefix);
            u.addPayloadCopyRule(payloadInitCpRule);
            if (!bGenerateNewCode) {
                this.savePayloadInitRule(payloadInitCpRule);
            }
        } else {
            this.removeOldPayloadInitCpRule();
        }
    }

    private void removeOldPayloadInitCpRule() {
        Copy c = null;
        Assign assign = GeneralTaskEditPage.getAssignFromTaskActList(this.mTask.getActivityList());
        if (assign == null) {
            return;
        }
        List list = assign.getCopyRules();
        if (list != null) {
            for (Object copy : list) {
                if (!(copy instanceof Copy) || ((Copy)copy).getFrom() == null || ((Copy)copy).getFrom().getLiteral() == null || !((Copy)copy).getFrom().getLiteral().trim().startsWith("<payload") || ((Copy)copy).getTo() == null || !((Copy)copy).getTo().getPart().trim().equals("payload") || !((Copy)copy).getTo().getQuery().trim().endsWith("payload")) continue;
                c = (Copy)copy;
                break;
            }
        }
        if (list != null) {
            ArrayList newList = new ArrayList(list);
            newList.remove(c);
            assign.setCopyRules(newList);
        }
    }

    private void removeReduntantCopyRules() {
        if (this.m_taskDataAssign == null) {
            return;
        }
        List cpRules = this.m_taskDataAssign.getCopyRules();
        ArrayList newList = new ArrayList();
        for (int j = 0; j < cpRules.size(); ++j) {
            Object curCopy = cpRules.get(j);
            if (!(curCopy instanceof Copy)) continue;
            boolean skipAddingCur = false;
            for (int i = cpRules.size() - 1; i >= 0; --i) {
                oracle.tip.tools.ide.common.bpelparser.iface.To to;
                Object c;
                if (i == j || !((c = cpRules.get(i)) instanceof Copy) || (to = ((Copy)c).getTo()) == null || to.getQuery() == null || !to.getQuery().trim().equals(((Copy)curCopy).getTo().getQuery().trim()) || j >= i) continue;
                skipAddingCur = true;
            }
            if (skipAddingCur) continue;
            newList.add(curCopy);
        }
        this.m_taskDataAssign.setCopyRules(newList);
    }

    private void addingPartnerLink(String taskSvcPrefix, WFBPELCodeGen u, GeneralTaskData pData) {
        PartnerLinks pls = this.mProcess.getPartnerLinks();
        if (pls == null) {
            pls = this.mProcess.createPartnerLinks();
        }
        List plList = pls.getPartnerLinks();
        boolean bAdd = true;
        TaskDefinition def = this.mEditorData.getTaskDefinition();
        if (def == null) {
            return;
        }
        String compositeName = def.getName();
        PartnerLink plink = null;
        String plName = compositeName + "." + "TaskService" + "_1";
        if (this.m_partnerLinkName != null) {
            bAdd = false;
            if (plList != null && plList.size() > 0) {
                for (int i = 0; i < plList.size(); ++i) {
                    PartnerLink pl = (PartnerLink)plList.get(i);
                    if (!this.m_partnerLinkName.equals(pl.getName())) continue;
                    plink = pl;
                    break;
                }
            }
        } else {
            boolean bHandled = false;
            List plinks = WFBpelCodeUtil.getPartnerLinksForTaskDef(this.mProject, compositeName, this.mProcess);
            if (plinks != null && plinks.size() > 0) {
                String plinkName = (String)plinks.get(0);
                PartnerLinks plss = this.mProcess.getPartnerLinks();
                List pList = null;
                if (plss != null) {
                    pList = plss.getPartnerLinks();
                }
                if (plinkName != null && pList != null && pList.size() > 0) {
                    for (int i = 0; i < pList.size(); ++i) {
                        PartnerLink pl = (PartnerLink)pList.get(i);
                        if (!plinkName.equals(pl.getName())) continue;
                        plink = pl;
                        plName = plinkName;
                        bHandled = true;
                        bAdd = false;
                        break;
                    }
                }
            }
            if (!bHandled) {
                bAdd = true;
                int idx = 1;
                while (!BPELModelUtil.isUniquePartnerLinkName((List)plList, (String)(plName = compositeName + "." + "TaskService" + "_" + idx++))) {
                }
            }
        }
        u.setPartnerLinkName(plName);
        if (bAdd) {
            plink = (PartnerLink)BPELParser.createImplementation(PartnerLink.class);
            plink.setName(plName);
            QName qNameTms = new QName("http://xmlns.oracle.com/bpel/workflow/taskService", "TaskService", taskSvcPrefix);
            plink.setPartnerLinkType(qNameTms);
            plink.setPartnerRole("TaskService");
            plink.setMyRole("TaskServiceCallbackListener");
            URL wsdlURL = URLFactory.newURL((String)"oramds:/soa/shared/workflow/TaskServiceInterface.wsdl");
            plink.setWSDLLocation(wsdlURL.toString());
            this.mProcess.addPartnerLink(plink);
            PartnerLinkNode partnerLinkNode = new PartnerLinkNode();
            partnerLinkNode.setUserObject(plink);
            String iconName = "usertask_palette.png";
            URL url = URLFactory.newURL((URL)BPELAddin.getPartnerLinkIconsDirectory(), (String)iconName);
            if (URLFileSystem.exists((URL)url)) {
                partnerLinkNode.setIcon(new ImageIcon(url));
                partnerLinkNode.setIconName(iconName);
            }
            SwimLaneView swimLaneView = this.m_graphPane.getLeftSwimLaneView();
            SwimLaneNode swimLaneNode = (SwimLaneNode)swimLaneView.getNode();
            this.m_graphModel.addChildNode((oracle.tip.tools.ide.common.graph.model.Node)swimLaneNode, (oracle.tip.tools.ide.common.graph.model.Node)partnerLinkNode);
        }
        try {
            this.firePartnerLinkCreated(plink, bAdd, pData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void firePartnerLinkCreated(PartnerLink plink, boolean bAddPartnerLink, GeneralTaskData pData) {
        String name = pData.getWorkflow().getWorkflowName();
        if (name == null) {
            return;
        }
        String title = pData.getTitle();
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (bAddPartnerLink) {
            map.put("CompSvcPartnerLink", Boolean.TRUE);
            map.put("OutboundPartnerLink", bAddPartnerLink);
            map.put("CompSvcName", "TaskService");
            map.put("CompName", name);
            this.mProcess.fireModelChanged((Object)this.mProcess, 5, (Object)plink, map);
        } else {
            WorkflowProject p = pData.getOldWorkflow();
            if (p != null && name.equals(p.getWorkflowName())) {
                return;
            }
            map.put("TargetComponentName", name);
            map.put("OldTargetComponentName", pData.getOldWorkflow());
            map.put("TargetComponentSrvName", "TaskService");
            map.put("OldTargetComponentSrvName", "TaskService");
            this.mProcess.fireModelChanged((Object)this.mProcess, 29, (Object)plink.getName(), map);
        }
    }

    private Object findPayloadCoptRule(String name, int type) {
        for (int i = 0; i < this.m_taskDataCPList.size(); ++i) {
            PayLoadCopyRule p = (PayLoadCopyRule)this.m_taskDataCPList.get(i);
            if (!p.m_name.equals(name) || p.m_type != type) continue;
            return p.m_rule;
        }
        return null;
    }

    private void savePayloadCopyRule(String name, oracle.tip.tools.ide.common.bpelparser.iface.From from, String taskVarName, String taskSvcPrefix, String msgName, String taskPrefix) {
        Copy c = this.getCpRule(name);
        this.changePayloadCPRule(c, from, taskVarName, taskSvcPrefix, msgName, taskPrefix, name);
    }

    private Copy getCpRule(String name) {
        Copy c = (Copy)this.findPayloadCoptRule(name, 1);
        if (c == null) {
            ArrayList<Object> list;
            c = this.createCopyRule();
            if (this.m_taskDataAssign == null) {
                this.m_taskDataAssign = this.getFirstAssign();
            }
            list = (list = this.m_taskDataAssign.getCopyRules()) == null ? new ArrayList<Copy>() : new ArrayList(list);
            list.add(c);
            this.m_taskDataAssign.setCopyRules(list);
        }
        return c;
    }

    private void savePayloadCopyRuleForElem(String name, oracle.tip.tools.ide.common.bpelparser.iface.From from, String taskVarName, String taskSvcPrefix, String msgName, String taskPrefix, String localPartPrefix) {
        Copy c = this.getCpRule(name);
        this.changePayloadCPRuleForElem(c, from, taskVarName, taskSvcPrefix, msgName, taskPrefix, localPartPrefix, name);
    }

    private void changePayloadCPRule(Copy cp, oracle.tip.tools.ide.common.bpelparser.iface.From from, String taskVarName, String taskSvcPrefix, String msgName, String taskPrefix, String localPart) {
        this.getCpRuleFrom(from, cp);
        Object[] objs = new Object[]{taskSvcPrefix, msgName, taskPrefix, localPart};
        String queryStr = MessageFormat.format("/{0}:{1}/{2}:task/{2}:payload/{2}:{3}", objs);
        cp.getTo().setVariable(taskVarName);
        cp.getTo().setPart("payload");
        cp.getTo().setQuery(queryStr);
    }

    private void changePayloadCPRuleForElem(Copy cp, oracle.tip.tools.ide.common.bpelparser.iface.From from, String taskVarName, String taskSvcPrefix, String msgName, String taskPrefix, String localPartPrefix, String localPart) {
        this.getCpRuleFrom(from, cp);
        Object[] objs = new Object[]{taskSvcPrefix, msgName, taskPrefix, localPartPrefix, localPart};
        String queryStr = MessageFormat.format("/{0}:{1}/{2}:task/{2}:payload/{3}:{4}", objs);
        cp.getTo().setVariable(taskVarName);
        cp.getTo().setPart("payload");
        cp.getTo().setQuery(queryStr);
    }

    private void getCpRuleFrom(oracle.tip.tools.ide.common.bpelparser.iface.From from, Copy cp) {
        if (from != cp.getFrom()) {
            cp.getFrom().setLiteral(null);
            cp.getFrom().setExpression(null);
            cp.getFrom().setPartnerLink(null);
            cp.getFrom().setVariable(null);
            cp.getFrom().setPart(null);
            cp.getFrom().setQuery(null);
            if (from.getLiteral() != null) {
                cp.getFrom().setLiteral(from.getLiteral());
            } else if (from.getExpression() != null) {
                cp.getFrom().setExpression(from.getExpression());
            } else if (from.getVariable() != null) {
                cp.getFrom().setVariable(from.getVariable());
                cp.getFrom().setPart(from.getPart());
                cp.getFrom().setQuery(from.getQuery());
            } else if (from.getPartnerLink() != null) {
                cp.getFrom().setEndpointReference(from.getEndpointReference());
                cp.getFrom().setPartnerLink(from.getPartnerLink());
            }
        }
    }

    private void removePayloadRule(String name, int type) {
        if (this.m_taskDataAssign == null) {
            return;
        }
        for (int i = 0; i < this.m_taskDataCPList.size(); ++i) {
            Object obj;
            int idx;
            List origList;
            PayLoadCopyRule p = (PayLoadCopyRule)this.m_taskDataCPList.get(i);
            if (!p.m_name.equals(name) || p.m_type != type || !(origList = this.m_taskDataAssign.getCopyRules()).contains(p.m_rule)) continue;
            ArrayList newList = new ArrayList(origList);
            if (type == 1 && (idx = newList.indexOf(p.m_rule)) > 1 && (obj = newList.get(idx - 1)) instanceof FromOpType) {
                newList.remove(idx - 1);
            }
            newList.remove(p.m_rule);
            this.m_taskDataAssign.setCopyRules(newList);
        }
    }

    private void modifySwitchNode(Document doc, String varName) {
        ArrayList<String> existingOutcomes = new ArrayList<String>();
        ContainerActivity container = (ContainerActivity)this.mTask.getParentActivity();
        if (container == null) {
            return;
        }
        Iterator iter = container.getActivities();
        while (iter.hasNext()) {
            Activity utSwitch;
            Activity act = (Activity)iter.next();
            if (!act.getName().trim().equalsIgnoreCase(this.mTask.getName().trim()) || !iter.hasNext() || !((utSwitch = (Activity)iter.next()) instanceof Switch)) continue;
            Iterator iterS = ((Switch)utSwitch).getSwitchCases();
            while (iterS.hasNext()) {
                Activity cases = (Activity)iterS.next();
                if (!(cases instanceof SwitchCase)) continue;
                this.replaceVarName((SwitchCase)cases, varName);
                String name = ((SwitchCase)cases).getDescription();
                if (name == null) continue;
                String outcomeName = name.replaceFirst("Task outcome is ", "");
                existingOutcomes.add(outcomeName);
                Iterator iterCase = ((SwitchCase)cases).getActivities();
                while (iterCase.hasNext()) {
                    Activity seq = (Activity)iterCase.next();
                    if (!(seq instanceof Sequence)) continue;
                    Iterator iterSeq = ((Sequence)seq).getActivities();
                    while (iterSeq.hasNext()) {
                        Activity actAssign = (Activity)iterSeq.next();
                        if (!(actAssign instanceof Assign) || actAssign.getName() == null || !actAssign.getName().trim().equalsIgnoreCase("CopyPayloadFromTask")) continue;
                        List cpList = this.mEditorData.getSwitchRuleList();
                        ((Assign)actAssign).setCopyRules(new ArrayList());
                        this.addCopyRules((Assign)actAssign, doc, cpList);
                    }
                }
            }
            SwitchOtherwise otherwise = ((Switch)utSwitch).getSwitchOtherwise();
            if (otherwise == null) {
                return;
            }
            Iterator iterCase = otherwise.getActivities();
            while (iterCase.hasNext()) {
                Activity seq = (Activity)iterCase.next();
                if (!(seq instanceof Sequence)) continue;
                Iterator iterSeq = ((Sequence)seq).getActivities();
                while (iterSeq.hasNext()) {
                    Activity actAssign = (Activity)iterSeq.next();
                    if (!(actAssign instanceof Assign) || actAssign.getName() == null || !actAssign.getName().trim().equalsIgnoreCase("CopyPayloadFromTask")) continue;
                    List cpList = this.mEditorData.getSwitchRuleList();
                    ((Assign)actAssign).setCopyRules(new ArrayList());
                    this.addCopyRules((Assign)actAssign, doc, cpList);
                }
            }
            if (!(utSwitch instanceof Switch)) continue;
            this.modifySwitchBasedOnOutcomes(existingOutcomes, (Switch)utSwitch);
        }
    }

    private void replaceVarName(SwitchCase cases, String varName) {
        String str = cases.getCondition();
        if (str == null || str.length() == 0) {
            return;
        }
        int beginIdx = str.indexOf("bpws:getVariableData('");
        if (beginIdx != 0) {
            return;
        }
        int endIdx = (str = str.substring(22, str.length())).indexOf("'");
        if (endIdx == -1) {
            return;
        }
        String origVarName = str.substring(0, endIdx);
        if (!origVarName.equals(varName)) {
            str = cases.getCondition();
            cases.setCondition(str.replaceAll(origVarName, varName));
        }
    }

    private Collection removeDuplicateOutcomes(Collection<String> pOutcomes) {
        ArrayList<String> c = new ArrayList<String>();
        if (pOutcomes == null) {
            return c;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String str : pOutcomes) {
            String newStr;
            if ((str = str.trim()).length() == 0 || map.containsKey(newStr = str.toUpperCase())) continue;
            map.put(newStr, str);
            c.add(str);
        }
        return c;
    }

    private void modifySwitchBasedOnOutcomes(ArrayList existingOutcomes, Switch utSwitch) {
        oracle.tip.tools.ide.common.graph.model.Node pn;
        if (existingOutcomes == null || existingOutcomes.size() == 0) {
            return;
        }
        TaskDefinition def = this.mEditorData.getTaskDefinition();
        if (def == null) {
            return;
        }
        Collection outcomesList = def.getWorkflowConfiguration().getOutcomes().getOutcome();
        outcomesList = this.removeDuplicateOutcomes(outcomesList);
        ArrayList<String> addedOutcomes = new ArrayList<String>();
        ArrayList<String> deletedOutcomes = new ArrayList<String>();
        for (String outcome : outcomesList) {
            if (existingOutcomes.contains(outcome)) continue;
            addedOutcomes.add(outcome);
        }
        for (String outcome : existingOutcomes) {
            if (outcomesList.contains(outcome)) continue;
            deletedOutcomes.add(outcome);
        }
        Iterator iter = addedOutcomes.iterator();
        while (iter.hasNext()) {
            List cpList = this.mEditorData.getSwitchRuleList();
            String newOutcome = (String)iter.next();
            WFBPELCodeGen u = this.mEditorData.getBPELCodeGen();
            SwitchCase c = (SwitchCase)BPELParser.createImplementation(SwitchCase.class);
            c.createDOMElement(this.mProcess.getDOMElement().getOwnerDocument(), "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
            c.setCondition(u.getSwitchCondition(newOutcome));
            c.setDescription("Task outcome is " + newOutcome);
            Sequence s = (Sequence)BPELParser.createImplementation(Sequence.class);
            s.createDOMElement(this.mProcess.getDOMElement().getOwnerDocument(), "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
            Assign a = (Assign)BPELParser.createImplementation(Assign.class);
            a.setName("CopyPayloadFromTask");
            a.createDOMElement(this.mProcess.getDOMElement().getOwnerDocument(), "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
            this.addCopyRules(a, this.mProcess.getDOMElement().getOwnerDocument(), cpList);
            try {
                s.addActivity((Activity)a);
                c.addActivity((Activity)s);
                utSwitch.addSwitchCase(c);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.m_graphModel == null) continue;
            SwitchCaseNode cn = new SwitchCaseNode();
            AssignNode an = new AssignNode();
            an.setUserObject(a);
            cn.addChildNode((oracle.tip.tools.ide.common.graph.model.Node)an);
            cn.setUserObject(c);
            pn = this.m_graphModel.getNodeForActivity((Activity)utSwitch);
            cn.setParentNode(pn);
            this.m_graphModel.insertChildNode(pn, (oracle.tip.tools.ide.common.graph.model.Node)cn, 0);
        }
        if (deletedOutcomes.size() > 0) {
            Object[] options = new String[]{BPELStringTranslator.getString("DELETE_OPTION"), BPELStringTranslator.getString("KEEP_OPTION")};
            int retVal = MultiLineOptionPaneDialog.showOptionDialog((Component)this.mParent, (Object)BPELStringTranslator.getString("OUTCOME_DELETED"), (String)BPELStringTranslator.getString("CASE_REGEN"), (int)0, (int)3, (Icon)UIHelper.loadIcon((String)"images/question_and_answer.png", UIHelper.class), (Object[])options, (Object)new Integer(1));
            if (retVal == 0) {
                for (String oldOutcome : deletedOutcomes) {
                    Iterator casesIter = utSwitch.getSwitchCases();
                    while (casesIter.hasNext()) {
                        SwitchCase sCase = (SwitchCase)casesIter.next();
                        String name = sCase.getDescription();
                        String outcomeName = name.replaceFirst("Task outcome is ", "");
                        if (!outcomeName.trim().equalsIgnoreCase(oldOutcome.trim())) continue;
                        try {
                            utSwitch.deleteActivity((Activity)sCase);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (this.m_graphModel == null) continue;
                        oracle.tip.tools.ide.common.graph.model.Node cn = this.m_graphModel.getNodeForActivity((Activity)sCase);
                        pn = cn.getParentNode();
                        this.m_graphModel.deleteNode(pn, cn);
                    }
                }
            }
        }
    }

    private void addCopyRules(Assign a, Document doc, List cpList) {
        if (cpList == null) {
            return;
        }
        for (int j = 0; j < cpList.size(); ++j) {
            Copy cp = (Copy)cpList.get(j);
            Copy newCP = (Copy)BPELParser.createImplementation(Copy.class);
            newCP.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
            oracle.tip.tools.ide.common.bpelparser.iface.From f = (oracle.tip.tools.ide.common.bpelparser.iface.From)BPELParser.createImplementation(oracle.tip.tools.ide.common.bpelparser.iface.From.class);
            f.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
            f.setVariable(cp.getFrom().getVariable());
            f.setPart(cp.getFrom().getPart());
            f.setQuery(cp.getFrom().getQuery());
            f.setExpression(cp.getFrom().getExpression());
            f.setLiteral(cp.getFrom().getLiteral());
            f.setPartnerLink(cp.getFrom().getPartnerLink());
            newCP.setFrom(f);
            oracle.tip.tools.ide.common.bpelparser.iface.To t = (oracle.tip.tools.ide.common.bpelparser.iface.To)BPELParser.createImplementation(oracle.tip.tools.ide.common.bpelparser.iface.To.class);
            t.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
            t.setVariable(cp.getTo().getVariable());
            t.setPart(cp.getTo().getPart());
            t.setQuery(cp.getTo().getQuery());
            t.setPartnerLink(cp.getTo().getPartnerLink());
            newCP.setTo(t);
            a.addCopyRule(newCP);
        }
    }

    private void generateCopyRulesForSwitchAct(List payloadCpList, String varName, String taskPrefix) {
        ArrayList<Copy> cpList = new ArrayList<Copy>();
        Copy data = (Copy)BPELParser.createImplementation(Copy.class);
        Copy c = null;
        oracle.tip.tools.ide.common.bpelparser.iface.From f = null;
        oracle.tip.tools.ide.common.bpelparser.iface.To t = null;
        for (int i = 0; i < payloadCpList.size(); ++i) {
            DOMParser parser;
            String strData = (String)payloadCpList.get(i);
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(strData.getBytes(CHAR_ENC));
                parser = new DOMParser();
                parser.parse((InputStream)in);
            }
            catch (Exception e) {
                return;
            }
            Element retNode = parser.getDocument().getDocumentElement();
            ParserContext pctxt = this.mProcess.createParserContext();
            data.readFromElement(retNode, pctxt);
            oracle.tip.tools.ide.common.bpelparser.iface.From cpFrom = data.getFrom();
            oracle.tip.tools.ide.common.bpelparser.iface.To cpTo = data.getTo();
            if (!this.isReverseable(cpFrom, cpTo) || this.isPayloadCopyRule(cpFrom, cpTo)) continue;
            c = (Copy)BPELParser.createImplementation(Copy.class);
            f = (oracle.tip.tools.ide.common.bpelparser.iface.From)BPELParser.createImplementation(oracle.tip.tools.ide.common.bpelparser.iface.From.class);
            t = (oracle.tip.tools.ide.common.bpelparser.iface.To)BPELParser.createImplementation(oracle.tip.tools.ide.common.bpelparser.iface.To.class);
            t.setQuery(cpFrom.getQuery());
            t.setVariable(cpFrom.getVariable());
            t.setPart(cpFrom.getPart());
            f.setVariable(varName);
            f.setPart("payload");
            String st = cpTo.getQuery();
            if (st != null) {
                int idx = st.lastIndexOf("/");
                if (idx != -1) {
                    st = st.substring(idx, st.length());
                }
                f.setQuery("/" + taskPrefix + ":task/" + taskPrefix + ":payload" + st);
            }
            c.setFrom(f);
            c.setTo(t);
            cpList.add(c);
        }
        this.mEditorData.setSwitchCopyRuleList(cpList);
    }

    private boolean isReverseable(oracle.tip.tools.ide.common.bpelparser.iface.From pFrom, oracle.tip.tools.ide.common.bpelparser.iface.To pTo) {
        if (pFrom == null || pTo == null) {
            return false;
        }
        return pFrom.getVariable() != null;
    }

    private boolean isPayloadCopyRule(oracle.tip.tools.ide.common.bpelparser.iface.From pFrom, oracle.tip.tools.ide.common.bpelparser.iface.To pTo) {
        String literal = pFrom.getLiteral();
        if (literal == null) {
            return false;
        }
        String payload = "<payload xmlns=";
        payload = payload + "\"http://xmlns.oracle.com/bpel/workflow/task\"";
        payload = payload + ">";
        if (!literal.trim().startsWith(payload)) {
            return false;
        }
        if (!"initiateTaskInput".equals(pTo.getVariable())) {
            return false;
        }
        if (!"payload".equals(pTo.getPart())) {
            return false;
        }
        return "/taskservice:initiateTask/task:task/task:payload".equals(pTo.getQuery());
    }

    public static Collection<WorkflowProject> getWorkflows(IntegrationProject project) {
        List l = new WorkflowUtil().getWorkflowProjects(project);
        return l;
    }

    public static TaskDefinition getTaskDefinition(WorkflowProject project) {
        if (project == null) {
            return null;
        }
        return GeneralTaskIOHandler.getTaskDefinition(project.getRoutingSlipURL());
    }

    public static TaskDefinition getTaskDefinition(URL pURL) {
        TaskDefinition def = null;
        try {
            def = (TaskDefinition)TaskDefinitionUtil.getInstance().unmarshal(pURL);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return def;
    }

    private void loadTaskDefinition(GeneralTaskData pData) {
        Invoke invoke = this.mTask.getInvoke();
        if (invoke != null) {
            String plName = invoke.getPartnerLink();
            String filename = WFBpelCodeUtil.getTaskFileForPartnerLink((Project)this.mProject.getProjectContext(), plName);
            if (filename == null) {
                return;
            }
            URL url = URLFactory.newURL((URL)this.mProject.getBPELDirectoryURL(), (String)filename);
            WorkflowProject wfp = new WorkflowUtil().getWorkflowProject(url);
            pData.setOldWorkflow(wfp);
            pData.setWorkflow(wfp);
            TaskDefinition def = GeneralTaskIOHandler.getTaskDefinition(wfp.getRoutingSlipURL());
            this.mEditorData.setTaskDefinition(def);
        }
    }

    private boolean loadTaskTitle(Copy c, GeneralTaskData pData) {
        String str = null;
        oracle.tip.tools.ide.common.bpelparser.iface.To to = c.getTo();
        oracle.tip.tools.ide.common.bpelparser.iface.From from = c.getFrom();
        if (to == null || from == null) {
            return false;
        }
        String q = to.getQuery();
        String p = to.getPart();
        boolean bHandled = false;
        if (p != null && p.equals("payload") && q != null && q.endsWith("title") && from.getExpression() != null) {
            String exp = from.getExpression();
            bHandled = true;
            if (exp.startsWith("string(")) {
                MessageFormat fmt = new MessageFormat("string(''{0}''");
                try {
                    Object[] obj = fmt.parse(exp);
                    str = (String)obj[0];
                }
                catch (ParseException ex) {
                    ex.printStackTrace();
                }
            } else {
                str = exp.startsWith("concat(") && exp.endsWith(")") ? this.parseConcatExp(exp) : "<%" + exp.trim() + "%>";
            }
            pData.setTitle(str);
        }
        return bHandled;
    }

    protected String parseConcatExp(String exp) {
        if (!exp.startsWith("concat(") || !exp.endsWith(")")) {
            return exp;
        }
        String str = exp.substring(7, exp.length() - 1);
        ArrayList<String> strList = new ArrayList<String>();
        char[] chArray = str.toCharArray();
        boolean bEscape = false;
        int beginIdx = 0;
        for (int i = 0; i < chArray.length; ++i) {
            if (chArray[i] == ',') {
                if (!bEscape) {
                    strList.add(str.substring(beginIdx, i));
                    beginIdx = i + 1;
                }
            } else if (chArray[i] == '(') {
                bEscape = true;
            } else if (chArray[i] == ')') {
                bEscape = false;
            }
            if (i != chArray.length - 1 || beginIdx == chArray.length) continue;
            strList.add(str.substring(beginIdx, chArray.length));
        }
        StringBuffer strBuf = new StringBuffer();
        for (int i = 0; i < strList.size(); ++i) {
            String s = (String)strList.get(i);
            if ((s = s.trim()).startsWith("string(")) {
                MessageFormat fmt = new MessageFormat("string(''{0}'')");
                try {
                    Object[] obj = fmt.parse(s);
                    strBuf.append((String)obj[0]);
                }
                catch (ParseException ex) {
                    ex.printStackTrace();
                }
                continue;
            }
            strBuf.append("<%");
            strBuf.append(s);
            strBuf.append("%>");
        }
        return strBuf.toString();
    }

    private boolean loadCreator(Copy c, GeneralTaskData pData) {
        oracle.tip.tools.ide.common.bpelparser.iface.To to = c.getTo();
        oracle.tip.tools.ide.common.bpelparser.iface.From from = c.getFrom();
        if (to == null || from == null) {
            return false;
        }
        String q = to.getQuery();
        String p = to.getPart();
        boolean bHandled = false;
        if (p != null && p.equals("payload") && q != null && q.endsWith("creator") && from.getExpression() != null) {
            String exp = from.getExpression();
            bHandled = true;
            MixedXPathExpressionParser parser = new MixedXPathExpressionParser();
            String str = parser.convertXPathComplaintStringToMixedForm(exp);
            pData.setInitiator(str);
        }
        return bHandled;
    }

    private boolean loadPriority(Copy c, GeneralTaskData pData) {
        String exp;
        oracle.tip.tools.ide.common.bpelparser.iface.To to = c.getTo();
        oracle.tip.tools.ide.common.bpelparser.iface.From from = c.getFrom();
        if (to == null || from == null) {
            return false;
        }
        String q = to.getQuery();
        String p = to.getPart();
        boolean bHandled = false;
        if (p != null && p.equals("payload") && q != null && q.endsWith("priority") && from.getExpression() != null && (exp = from.getExpression()).startsWith("number(")) {
            MessageFormat fmt = new MessageFormat("number({0})");
            try {
                Object[] obj = fmt.parse(exp);
                int pri = Integer.parseInt((String)obj[0]);
                pData.setPriority(pri);
                bHandled = true;
            }
            catch (ParseException ex) {
                ex.printStackTrace();
            }
        }
        return bHandled;
    }

    private boolean loadTaskData(Copy c, GeneralTaskData pData) {
        PayloadType payloadType;
        List msgAttrList;
        boolean bHandled = false;
        oracle.tip.tools.ide.common.bpelparser.iface.To to = c.getTo();
        oracle.tip.tools.ide.common.bpelparser.iface.From from = c.getFrom();
        if (to == null || to.getQuery() == null || from == null) {
            return false;
        }
        String query = to.getQuery();
        TaskDefinition def = this.mEditorData.getTaskDefinition();
        if (def != null && (msgAttrList = (payloadType = def.getWorkflowConfiguration().getPayload()).getMessageAttribute()) != null && msgAttrList.size() > 0) {
            List<TaskPayloadData> vec = pData.getPayload();
            for (int i = 0; i < msgAttrList.size() && !bHandled; ++i) {
                MessageAttributeType m = (MessageAttributeType)msgAttrList.get(i);
                try {
                    QName qname = GeneralTaskIOHandler.getQNameForAttrType(m);
                    String queryStr = query;
                    int idx = queryStr.lastIndexOf(":");
                    String s = "";
                    if (idx != -1) {
                        s = queryStr.substring(idx + 1, queryStr.length());
                    }
                    if (!s.trim().equals(m.getName()) || qname == null) continue;
                    boolean bAddedToModel = false;
                    for (int k = 0; k < vec.size() && !bAddedToModel; ++k) {
                        TaskPayloadData data = vec.get(k);
                        if (!data.getName().equals(m.getName())) continue;
                        vec.remove(data);
                        bAddedToModel = true;
                    }
                    int attrType = TaskPayloadData.getAttrTypeFromString(m.getAttributeType());
                    vec.add(new TaskPayloadData(m.getName(), attrType, qname, this.clone(c)));
                    bHandled = true;
                    PayLoadCopyRule p = new PayLoadCopyRule(m.getName(), 1, c);
                    this.m_taskDataCPList.add(p);
                    continue;
                }
                catch (JAXBException jex) {
                    jex.printStackTrace();
                }
            }
        }
        return bHandled;
    }

    private boolean loadTaskData(Append c, GeneralTaskData pData) {
        PayloadType payloadType;
        List msgAttrList;
        boolean bHandled = false;
        To to = c.getTo();
        From from = c.getFrom();
        if (to == null || to.getQuery() == null || from == null) {
            return false;
        }
        TaskDefinition def = this.mEditorData.getTaskDefinition();
        if (def != null && (msgAttrList = (payloadType = def.getWorkflowConfiguration().getPayload()).getMessageAttribute()) != null && msgAttrList.size() > 0) {
            for (int i = 0; i < msgAttrList.size() && !bHandled; ++i) {
                MessageAttributeType m = (MessageAttributeType)msgAttrList.get(i);
                try {
                    QName qname;
                    int attrType = TaskPayloadData.getAttrTypeFromString(m.getAttributeType());
                    if (attrType != 3 || (qname = GeneralTaskIOHandler.getQNameForAttrType(m)) == null) continue;
                    if (from.getQuery() != null) {
                        String queryStr = from.getQuery();
                        int idx = queryStr.lastIndexOf(":");
                        String s = "";
                        if (idx != -1) {
                            s = queryStr.substring(idx + 1, queryStr.length());
                        }
                        if (qname.getLocalPart().equals(s)) {
                            bHandled = true;
                        }
                    } else {
                        QName vQName;
                        Variable v = BPELModelUtil.getVariableForName((Activity)this.mTask, (String)from.getVariable());
                        if (v != null && (vQName = v.getElement()) != null && qname.equals(vQName)) {
                            bHandled = true;
                        }
                    }
                    if (!bHandled) continue;
                    PayLoadCopyRule p = new PayLoadCopyRule(m.getName(), 2, c);
                    this.m_taskDataCPList.add(p);
                    Copy newC = (Copy)BPELParser.createImplementation(Copy.class);
                    oracle.tip.tools.ide.common.bpelparser.iface.From f = (oracle.tip.tools.ide.common.bpelparser.iface.From)BPELParser.createImplementation(oracle.tip.tools.ide.common.bpelparser.iface.From.class);
                    f.setQuery(from.getQuery());
                    f.setVariable(from.getVariable());
                    f.setPart(from.getPart());
                    newC.setFrom(f);
                    pData.getPayload().add(new TaskPayloadData(m.getName(), attrType, qname, newC));
                    continue;
                }
                catch (JAXBException jex) {
                    jex.printStackTrace();
                }
            }
        }
        return bHandled;
    }

    private Copy clone(Copy pCopy) {
        if (pCopy == null) {
            return null;
        }
        Copy newCopy = (Copy)BPELParser.createImplementation(Copy.class);
        oracle.tip.tools.ide.common.bpelparser.iface.From from = (oracle.tip.tools.ide.common.bpelparser.iface.From)BPELParser.createImplementation(oracle.tip.tools.ide.common.bpelparser.iface.From.class);
        oracle.tip.tools.ide.common.bpelparser.iface.To to = (oracle.tip.tools.ide.common.bpelparser.iface.To)BPELParser.createImplementation(oracle.tip.tools.ide.common.bpelparser.iface.To.class);
        this.cloneFrom(pCopy.getFrom(), from);
        this.cloneTo(pCopy.getTo(), to);
        newCopy.setFrom(from);
        newCopy.setTo(to);
        return newCopy;
    }

    private void cloneTo(oracle.tip.tools.ide.common.bpelparser.iface.To pTo, oracle.tip.tools.ide.common.bpelparser.iface.To pDestination) {
        if (pTo == null || pDestination == null) {
            return;
        }
        pDestination.setPart(pTo.getPart());
        pDestination.setPartnerLink(pTo.getPartnerLink());
        pDestination.setQuery(pTo.getQuery());
        pDestination.setVariable(pTo.getVariable());
    }

    private void cloneFrom(oracle.tip.tools.ide.common.bpelparser.iface.From pFrom, oracle.tip.tools.ide.common.bpelparser.iface.From pDestination) {
        if (pFrom == null || pDestination == null) {
            return;
        }
        pDestination.setExpression(pFrom.getExpression());
        pDestination.setLiteral(pFrom.getLiteral());
        pDestination.setOpaque(pFrom.getOpaque());
        pDestination.setPart(pFrom.getPart());
        pDestination.setPartnerLink(pFrom.getPartnerLink());
        pDestination.setProperty(pFrom.getProperty());
        pDestination.setQuery(pFrom.getQuery());
        pDestination.setVariable(pFrom.getVariable());
    }

    private static void loadUnfilledTaskData(GeneralTaskData pData, TaskDefinition def) {
        WorkflowConfigurationType wcft;
        String owner;
        GlobalConfigurationType gct;
        if (def == null) {
            return;
        }
        RoutingSlipType routingSlip = def.getRoutingSlip();
        if (routingSlip != null && (gct = routingSlip.getGlobalConfiguration()) != null && (owner = gct.getOwner()) != null) {
            pData.setInitiator(owner);
        }
        if (def.getPriority() != null) {
            pData.setPriority(def.getPriority().intValue());
        }
        if ((wcft = def.getWorkflowConfiguration()) != null) {
            PayloadType payloadType = def.getWorkflowConfiguration().getPayload();
            List msgAttrList = payloadType.getMessageAttribute();
            if (msgAttrList == null) {
                return;
            }
            List<TaskPayloadData> vec = pData.getPayload();
            for (int i = 0; i < msgAttrList.size(); ++i) {
                MessageAttributeType m = (MessageAttributeType)msgAttrList.get(i);
                boolean bAddToModel = false;
                for (int j = 0; j < vec.size() && !bAddToModel; ++j) {
                    TaskPayloadData data = vec.get(j);
                    if (!data.getName().equals(m.getName())) continue;
                    bAddToModel = true;
                }
                if (bAddToModel) continue;
                try {
                    QName qname = GeneralTaskIOHandler.getQNameForAttrType(m);
                    int attrType = TaskPayloadData.getAttrTypeFromString(m.getAttributeType());
                    vec.add(new TaskPayloadData(m.getName(), attrType, qname));
                    continue;
                }
                catch (JAXBException jex) {
                    jex.printStackTrace();
                }
            }
        }
    }

    private static QName getQNameForAttrType(MessageAttributeType m) throws JAXBException {
        String nsPrefix;
        String type = m.getType();
        int index = type.indexOf(":");
        if (index == -1) {
            return null;
        }
        Map nsMap = JaxbUtil.getNamespaceDeclaration((JaxbNode)((MessageAttributeTypeImpl)m));
        String ns = (String)nsMap.get(nsPrefix = type.substring(0, index));
        if (ns == null) {
            return null;
        }
        String localPart = type.substring(index + 1, type.length());
        return new QName(ns, localPart);
    }

    class PayLoadCopyRule {
        protected static final int COPY_RULE = 1;
        protected static final int APPEND_RULE = 2;
        protected String m_name;
        protected int m_type;
        protected Object m_rule;

        public PayLoadCopyRule(String name, int type, Object rule) {
            this.m_name = name;
            this.m_type = type;
            this.m_rule = rule;
        }

        public String getName() {
            return this.m_name;
        }

        public int getType() {
            return this.m_type;
        }

        public Object getCopyRule() {
            return this.m_rule;
        }
    }
}

