/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import oracle.ide.model.Project;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.iface.UserTask;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Assign;
import oracle.tip.tools.ide.common.bpelparser.iface.Sequence;
import oracle.tip.tools.ide.common.ide.workflow.WorkflowProject;
import oracle.tip.tools.ide.fabric.addin.SCAProject;
import oracle.tip.tools.ide.fabric.model.SCAComposite;
import oracle.tip.tools.ide.fabric.model.SCAModelBuilder;
import oracle.tip.tools.ide.fabric.model.SCAModelBuilderException;
import oracle.tip.tools.ide.fabric.model.SCASource;
import oracle.tip.tools.ide.fabric.model.SCATarget;
import oracle.tip.tools.ide.fabric.model.SCAWire;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.EditorPage;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.collaxalaf.popupeditor.UserTaskEditorData;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.GeneralTaskData;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.GeneralTaskIOHandler;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.GeneralTaskPanel;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.WorkflowEditorContext;

public class GeneralTaskEditPage
extends BaseEditingPage
implements EditorPage {
    protected UserTask m_task;
    protected UserTaskEditorData mEditorData;
    protected String m_taskDefURI;
    protected String m_taskDefFileName;
    protected boolean m_bLocalTaskFile;
    protected WorkflowProject m_wfProject;
    protected String m_origTaskDefURI;
    SCAComposite composite;
    private GeneralTaskPanel mPanel;
    private WorkflowEditorContext mContext;
    private GeneralTaskIOHandler mIOHandler;

    public GeneralTaskEditPage(BPELGraphPane graphPane, UserTaskEditorData pData) {
        super(graphPane);
        this.mEditorData = pData;
        this.mContext = new WorkflowEditorContext();
        this.mContext.setGraphPane(this.m_graphPane);
        this.composite = this.getSCAComposite();
        this.createControls();
        this.layoutControls();
    }

    private void createControls() {
        this.mPanel = new GeneralTaskPanel(this.mContext);
    }

    @Override
    public void loadData() {
        this.loadControls();
    }

    private void layoutControls() {
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        int x = 0;
        int y = 0;
        gbl.setConstraints(this.mPanel, new GridBagConstraints(x, y, 1, 1, 1.0, 1.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.mPanel);
    }

    @Override
    public void setUserObject(Object model) {
        this.m_task = (UserTask)model;
        this.mContext.setActivity((Activity)this.getUserObject());
        this.mContext.setProcess(this.m_graphModel.getProcess());
        this.mContext.setNSResolver(this.getNSResolver((Activity)this.m_task));
    }

    @Override
    public Object getUserObject() {
        return this.m_task;
    }

    @Override
    public String getTitle() {
        return BPELStringTranslator.getString("GENERAL_EDITOR_TITLE");
    }

    @Override
    public void saveChanges() {
        this.loadIOHandler();
        if (this.mIOHandler != null) {
            this.mIOHandler.saveChanges(this.mPanel.getData());
        }
    }

    @Override
    public boolean validateEditorChanges() {
        return this.mPanel.checkForValidity();
    }

    private GeneralTaskData getData() {
        return this.mPanel.getData();
    }

    protected static Assign getAssignFromTaskActList(List actList) {
        if (actList == null || actList.size() == 0 || actList.size() > 1) {
            return null;
        }
        Activity act = (Activity)actList.get(0);
        if (!(act instanceof Sequence)) {
            return null;
        }
        actList = ((Sequence)act).getActivityList();
        for (int i = 0; i < actList.size(); ++i) {
            act = (Activity)actList.get(i);
            if (!(act instanceof Assign)) continue;
            return (Assign)act;
        }
        return null;
    }

    private void loadControls() {
        this.loadIOHandler();
        GeneralTaskData data = this.mIOHandler.read();
        this.mPanel.setData(data);
    }

    private void loadIOHandler() {
        if (this.mIOHandler == null) {
            this.mIOHandler = new GeneralTaskIOHandler(this, this.mEditorData, this.m_task, this.m_graphPane.getBPELProject(), this.m_graphPane, this.m_processModel);
        }
    }

    private String getTargetWireName(String plName) {
        if (this.composite == null) {
            this.composite = this.getSCAComposite();
        }
        if (this.composite == null) {
            return null;
        }
        List wires = this.composite.getWires();
        for (int count = 0; count < wires.size(); ++count) {
            SCAWire wire = (SCAWire)wires.get(count);
            try {
                SCASource source = wire.getSource();
                String name = source.getDisplayString();
                if (!name.endsWith(plName)) continue;
                SCATarget target = wire.getTarget();
                return target.getDisplayString();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    private SCAComposite getSCAComposite() {
        SCAComposite composite = null;
        SCAProject project = this.getScaProject();
        if (project == null) {
            return null;
        }
        Project prj = (Project)this.m_graphModel.getBPELProject().getProjectContext();
        SCAModelBuilder modelBuilder = SCAModelBuilder.getSCAModelBuilder((Project)prj);
        try {
            composite = modelBuilder.getSCAComposite();
        }
        catch (SCAModelBuilderException e) {
            e.printStackTrace();
        }
        return composite;
    }

    private SCAProject getScaProject() {
        if (!SCAProject.isSCAProject((Project)((Project)this.m_graphModel.getBPELProject().getProjectContext()))) {
            return null;
        }
        return SCAProject.getSCAProject((Project)((Project)this.m_graphModel.getBPELProject().getProjectContext()));
    }
}

