/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.ui.search.PromptedTextField;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.BrowsableTableCellEditor;
import oracle.tip.tools.ide.common.ui.BrowsableTableCellEditorCallback;
import oracle.tip.tools.ide.common.ui.ComponentPanel;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.GeneralTaskData;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.GeneralTaskPanel;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.IValidator;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.PriorityRenderer;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.ShowCopyRuleCommand;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.TaskDataTableModel;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.TaskPayloadData;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.WorkflowEditorContext;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.XPathAction;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class GeneralTaskComponent
extends JPanel
implements IValidator {
    private static final String TASK_TITLE_HINT = BPELStringTranslator.getString("TASK_TITLE_HINT");
    private static final String TASK_TITLE_PROMPT = BPELStringTranslator.getString("TASK_TITLE_PROMPT");
    private static final Integer[] PRIORITIES = new Integer[]{1, 2, 3, 4, 5};
    protected PromptedTextField mTaskTitleField;
    protected JTextField mCreatorField;
    protected JTable mTaskTable;
    protected JComboBox mPriorityCB;
    protected JButton mCreateTaskTitleBtn;
    protected JButton mCreateCreatorBtn;
    protected DefaultComboBoxModel mTaskListModel;
    private GeneralTaskData mData = null;
    private boolean mListen = true;
    private TaskDataTableModel mTaskTableModel;
    private List<ChangeListener> mChangeListeners = new ArrayList<ChangeListener>();
    private LocalChangeListener mListener = new LocalChangeListener();
    private WorkflowEditorContext mContext = null;
    private Collection<JComponent> mLabels = new ArrayList<JComponent>();
    private static final Color ASPHALT = new Color(116, 116, 116);

    public GeneralTaskComponent(WorkflowEditorContext pContext) {
        this.mContext = pContext;
        this.initialize();
        this.layoutControls();
        this.setData(null);
    }

    public void initialize() {
        this.mTaskListModel = new DefaultComboBoxModel();
        this.mTaskTitleField = new PromptedTextField();
        this.mTaskTitleField.setPrompt(TASK_TITLE_PROMPT);
        this.mCreatorField = new JTextField();
        this.mCreateTaskTitleBtn = new JButton(new XPathAction((JTextComponent)this.mTaskTitleField, this.mContext));
        UIHelper.setupButton((JButton)this.mCreateTaskTitleBtn);
        this.mCreateCreatorBtn = new JButton(new XPathAction(this.mCreatorField, this.mContext));
        UIHelper.setupButton((JButton)this.mCreateCreatorBtn);
        this.mPriorityCB = new JComboBox<Integer>(new DefaultComboBoxModel<Integer>(PRIORITIES));
        this.mPriorityCB.setRenderer(new PriorityRenderer());
        this.mPriorityCB.setSelectedItem(3);
        this.mTaskTableModel = new TaskDataTableModel();
        this.mTaskTable = new JTable(this.mTaskTableModel);
        TableColumnModel colModel = this.mTaskTable.getColumnModel();
        MyBrowsableTableCellEditorCallback btc = new MyBrowsableTableCellEditorCallback(this.mContext);
        BrowsableTableCellEditor editor = new BrowsableTableCellEditor((BrowsableTableCellEditorCallback)btc);
        editor.setClickCountToStart(1);
        colModel.getColumn(1).setCellEditor((TableCellEditor)editor);
        colModel.getColumn(1).setWidth(375);
        colModel.getColumn(1).setPreferredWidth(375);
        colModel.getColumn(1).setCellRenderer(new MyTableCellRenderer());
        this.mTaskTable.setRowHeight(20);
        ComponentPanel panel = editor.getComponentPanel();
        LocalUIValidator tableValidator = new LocalUIValidator(panel, this.mTaskTable);
        this.mCreatorField.getDocument().addDocumentListener(this.mListener);
        this.mTaskTitleField.getDocument().addDocumentListener(this.mListener);
        this.mCreatorField.getDocument().addDocumentListener(this.mListener);
        this.mPriorityCB.addItemListener(this.mListener);
        this.mTaskTableModel.addChangeListener(this.mListener);
    }

    public Collection<JComponent> getLeftLabels() {
        return Collections.unmodifiableCollection(this.mLabels);
    }

    public static void main(String[] argv) {
        BPELStringTranslator.initialize();
        JFrame f = new JFrame();
        f.setContentPane(new GeneralTaskPanel(null));
        f.setDefaultCloseOperation(3);
        f.setSize(100, 100);
        f.setVisible(true);
    }

    private void layoutControls() {
        this.mLabels.clear();
        ToolBar taskTitleTB = new ToolBar();
        taskTitleTB.add((Component)this.mCreateTaskTitleBtn);
        ToolBar taskCreatorTB = new ToolBar();
        taskCreatorTB.add((Component)this.mCreateCreatorBtn);
        JLabel taskTitleLbl = new JLabel(BPELStringTranslator.getString("WF_TASK_TITLE"));
        this.mLabels.add(taskTitleLbl);
        JLabel taskTitleHint = new JLabel(TASK_TITLE_HINT);
        taskTitleHint.setForeground(ASPHALT);
        JLabel taskCreatorLbl = new JLabel(BPELStringTranslator.getString("WF_CREATOR"));
        this.mLabels.add(taskCreatorLbl);
        JLabel priorityLbl = new JLabel(BPELStringTranslator.getString("WF_PRIORITY"));
        ResourceUtils.resLabel((JLabel)taskTitleLbl, (Component)this.mTaskTitleField, (String)BPELStringTranslator.getString("WF_TASK_TITLE"));
        ResourceUtils.resLabel((JLabel)taskCreatorLbl, (Component)this.mCreatorField, (String)BPELStringTranslator.getString("WF_CREATOR"));
        ResourceUtils.resLabel((JLabel)priorityLbl, (Component)this.mPriorityCB, (String)BPELStringTranslator.getString("WF_PRIORITY"));
        this.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)this, (Component)taskTitleLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.mTaskTitleField, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)taskTitleTB, (int)2, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)taskTitleHint, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)taskCreatorLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        JPanel creatorPanel = new JPanel();
        creatorPanel.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)creatorPanel, (Component)this.mCreatorField, (int)0, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)creatorPanel, (Component)taskCreatorTB, (int)1, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)creatorPanel, (Component)priorityLbl, (int)2, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)creatorPanel, (Component)this.mPriorityCB, (int)3, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)creatorPanel, (int)1, (int)row++, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(0, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)GraphUtils.getScrollPane((Component)this.mTaskTable), (int)0, (int)row++, (int)3, (int)1, (int)17, (int)1, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    public void setData(GeneralTaskData pData) {
        this.mData = pData == null ? new GeneralTaskData() : pData;
        this.stopListening();
        this.fillUI();
        this.startListening();
    }

    private void stopListening() {
        this.mListen = false;
    }

    private void startListening() {
        this.mListen = true;
    }

    private void fillUI() {
        this.mCreatorField.setText(this.mData.getInitiator());
        this.mPriorityCB.setSelectedItem(this.mData.getPriority());
        this.mTaskTableModel.setData(this.mData.getPayload());
        this.mTaskTitleField.setText(this.mData.getTitle());
    }

    public GeneralTaskData getData() {
        GeneralTaskData gd = this.mData;
        gd.setPriority((Integer)this.mPriorityCB.getSelectedItem());
        gd.setInitiator(this.mCreatorField.getText());
        gd.setTitle(this.mTaskTitleField.getText());
        gd.setPayload(this.mTaskTableModel.getData());
        return gd;
    }

    private void fireChangeOccurred() {
        if (!this.mListen) {
            return;
        }
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener cl : this.mChangeListeners) {
            cl.stateChanged(e);
        }
    }

    @Override
    public boolean checkForValidity() {
        GeneralTaskData data = this.getData();
        return true;
    }

    private class LocalUIValidator
    implements DocumentListener {
        private ComponentPanel mComponent = null;
        private Document mDocument = null;
        private Border mOldBorder = null;
        private final Border RED_BORDER = BorderFactory.createLineBorder(Color.RED);

        public LocalUIValidator(ComponentPanel pComponent, JTable pTable) {
            if (pComponent != null) {
                this.mComponent = pComponent;
                this.mOldBorder = BorderFactory.createLineBorder(pTable.getBackground());
                this.mDocument = this.mComponent.getTextField().getDocument();
            }
            if (this.mDocument != null) {
                this.mDocument.addDocumentListener(this);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent pEvent) {
            this.fireDocumentUpdated();
        }

        @Override
        public void removeUpdate(DocumentEvent pEvent) {
            this.fireDocumentUpdated();
        }

        @Override
        public void changedUpdate(DocumentEvent pEvent) {
            this.fireDocumentUpdated();
        }

        private void fireDocumentUpdated() {
            if (this.mComponent == null) {
                return;
            }
            Border border = this.mOldBorder;
            if (this.mComponent.isShowing()) {
                try {
                    String text = this.mDocument.getText(0, this.mDocument.getLength());
                    if (text == null || text.trim().length() == 0) {
                        border = this.RED_BORDER;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                this.mComponent.setBorder(border);
            }
        }
    }

    class MyTableCellRenderer
    extends JPanel
    implements TableCellRenderer {
        private ComponentPanel mCP = new ComponentPanel(null, null);

        public MyTableCellRenderer() {
            this.layoutComponent();
        }

        private void layoutComponent() {
            this.setLayout(new BorderLayout());
            this.add((Component)this.mCP);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setOpaque(false);
            if (value instanceof ShowCopyRuleCommand.Result) {
                ShowCopyRuleCommand.Result r = (ShowCopyRuleCommand.Result)value;
                this.mCP.getTextField().setText(r.getSource());
            }
            if (value instanceof String) {
                String text = (String)value;
                this.mCP.getTextField().setText(text);
                if (text.trim().length() == 0) {
                    this.setBorder(BorderFactory.createLineBorder(Color.RED));
                } else {
                    this.setBorder(BorderFactory.createLineBorder(table.getBackground()));
                }
            }
            return this;
        }
    }

    class MyBrowsableTableCellEditorCallback
    implements BrowsableTableCellEditorCallback {
        ShowCopyRuleCommand mCommand = null;

        public MyBrowsableTableCellEditorCallback(WorkflowEditorContext pContext) {
            this.mCommand = new ShowCopyRuleCommand(pContext);
        }

        public boolean shouldSelectCell(EventObject anEvent) {
            return false;
        }

        public Object showChooser(JTable table, int row, int col) {
            TaskDataTableModel model = (TaskDataTableModel)table.getModel();
            TaskPayloadData data = (TaskPayloadData)model.getRow(row);
            ShowCopyRuleCommand.Result r = this.mCommand.doIt(data);
            if (!r.hasAccepted()) {
                return null;
            }
            return r;
        }
    }

    class LocalChangeListener
    implements DocumentListener,
    ItemListener,
    ChangeListener {
        LocalChangeListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent pEvent) {
        }

        @Override
        public void insertUpdate(DocumentEvent pEvent) {
            GeneralTaskComponent.this.fireChangeOccurred();
        }

        @Override
        public void removeUpdate(DocumentEvent pEvent) {
            GeneralTaskComponent.this.fireChangeOccurred();
        }

        @Override
        public void itemStateChanged(ItemEvent pEvent) {
            GeneralTaskComponent.this.fireChangeOccurred();
        }

        @Override
        public void stateChanged(ChangeEvent pEvent) {
            GeneralTaskComponent.this.fireChangeOccurred();
        }
    }

    public class NewWorkflowAction
    extends AbstractAction {
        public NewWorkflowAction() {
            this.putValue("SmallIcon", ImageCache.getIcon("create16"));
        }

        @Override
        public void actionPerformed(ActionEvent pEvent) {
        }
    }
}

